/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.util.List;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;

public final class TreeUtility {
    public static ITreeNode calculateCommonParentNode(ITreeNode[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        if (nodes.length == 1) {
            return nodes[0].getParentNode();
        }
        ITreeNode test = nodes[0].getParentNode();
        int i = 1;
        while (i < nodes.length) {
            if (nodes[i].getParentNode() != test) {
                test = null;
                break;
            }
            ++i;
        }
        return test;
    }

    public static ITreeNode findLowestCommonAncestorNode(List<ITreeNode> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.get(0).getParentNode();
        }
        ITreeNode commonParent = nodes.get(0).getParentNode();
        int i = 1;
        while (i < nodes.size()) {
            ITreeNode parentNode = nodes.get(i).getParentNode();
            if (parentNode != commonParent) {
                commonParent = TreeUtility.findLowestCommonAncestorNode(commonParent, parentNode);
            }
            ++i;
        }
        return commonParent;
    }

    public static ITreeNode findLowestCommonAncestorNode(ITreeNode firstNode, ITreeNode secondNode) {
        if (firstNode == null || secondNode == null) {
            return null;
        }
        if (firstNode.getTree() != secondNode.getTree()) {
            return null;
        }
        if (firstNode.getParentNode() == secondNode.getParentNode()) {
            return firstNode.getParentNode();
        }
        if (secondNode.getTreeLevel() > firstNode.getTreeLevel()) {
            secondNode = TreeUtility.findAncestorNodeAtLevel(secondNode, firstNode.getTreeLevel());
        } else if (firstNode.getTreeLevel() > secondNode.getTreeLevel()) {
            firstNode = TreeUtility.findAncestorNodeAtLevel(firstNode, secondNode.getTreeLevel());
        }
        while (firstNode.getParentNode() != secondNode.getParentNode()) {
            firstNode = firstNode.getParentNode();
            secondNode = secondNode.getParentNode();
        }
        return firstNode.getParentNode();
    }

    /*
     * Unable to fully structure code
     */
    public static ITreeNode findAncestorNodeAtLevel(ITreeNode node, int level) {
        if (node == null) {
            return null;
        }
        if (node.getTreeLevel() >= level) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParentNode();
lbl6:
            // 2 sources

            ** while (node.getTreeLevel() > level)
        }
lbl7:
        // 1 sources

        return node;
    }
}

