/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.tabbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBoxUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.internal.TabBoxGrid;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractTabBox
extends AbstractCompositeField
implements ITabBox {
    private ITabBoxUIFacade m_uiFacade;
    private TabBoxGrid m_grid;

    public AbstractTabBox() {
        this(true);
    }

    public AbstractTabBox(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @Override
    @ConfigPropertyValue(value="FULL_WIDTH")
    protected int getConfiguredGridW() {
        return 0;
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execTabSelected(IGroupBox selectedBox) throws ProcessingException {
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        this.m_grid = new TabBoxGrid(this);
        super.initConfig();
        this.addPropertyChangeListener("selectedTab", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                try {
                    AbstractTabBox.this.execTabSelected(AbstractTabBox.this.getSelectedTab());
                }
                catch (ProcessingException ex) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                }
            }
        });
    }

    @Override
    public void rebuildFieldGrid() {
        this.m_grid.validate();
        if (this.isInitialized() && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    @Override
    protected void handleFieldVisibilityChanged() {
        block8: {
            IGroupBox selectedBox;
            block9: {
                super.handleFieldVisibilityChanged();
                if (this.isInitialized()) {
                    this.rebuildFieldGrid();
                }
                if ((selectedBox = this.getSelectedTab()) != null) break block9;
                IGroupBox[] iGroupBoxArray = this.getGroupBoxes();
                int n = iGroupBoxArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IGroupBox box = iGroupBoxArray[n2];
                    if (box.isVisible()) {
                        this.setSelectedTab(box);
                        break block8;
                    }
                    ++n2;
                }
                break block8;
            }
            if (selectedBox.isVisible()) break block8;
            int index = this.getFieldIndex(selectedBox);
            IGroupBox[] boxes = this.getGroupBoxes();
            int i = index + 1;
            while (i < this.getFieldCount()) {
                if (boxes[i].isVisible()) {
                    this.setSelectedTab(boxes[i]);
                    break;
                }
                ++i;
            }
            if (this.getSelectedTab() == selectedBox) {
                i = index - 1;
                while (i >= 0) {
                    if (boxes[i].isVisible()) {
                        this.setSelectedTab(boxes[i]);
                        break;
                    }
                    --i;
                }
            }
        }
    }

    @Override
    public final int getGridColumnCount() {
        return this.m_grid.getGridColumnCount();
    }

    @Override
    public final int getGridRowCount() {
        return this.m_grid.getGridRowCount();
    }

    @Override
    public IGroupBox[] getGroupBoxes() {
        IGroupBox[] a = new IGroupBox[this.getFieldCount()];
        if (a.length > 0) {
            System.arraycopy(this.getFields(), 0, a, 0, a.length);
        }
        return a;
    }

    @Override
    public void setSelectedTab(IGroupBox box) {
        if (box.getParentField() == this) {
            this.propertySupport.setProperty("selectedTab", (Object)box);
        }
    }

    @Override
    public IGroupBox getSelectedTab() {
        return (IGroupBox)this.propertySupport.getProperty("selectedTab");
    }

    @Override
    public ITabBoxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private class P_UIFacade
    implements ITabBoxUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void setSelectedTabFromUI(IGroupBox box) {
            AbstractTabBox.this.setSelectedTab(box);
        }
    }
}

