/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.busy;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.IClientSessionProvider;
import org.eclipse.scout.rt.client.IJobChangeListenerEx;
import org.eclipse.scout.rt.client.JobChangeAdapterEx;
import org.eclipse.scout.rt.client.busy.IBusyHandler;
import org.eclipse.scout.rt.client.busy.IBusyManagerService;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.ServiceRegistration;

@Priority(value=-1000.0f)
public class BusyManagerService
extends AbstractService
implements IBusyManagerService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BusyManagerService.class);
    private static final String HANDLER_CLIENT_SESSION_KEY = IBusyHandler.class.getName();
    private final IJobChangeListener m_jobChangeListener = new P_JobChangeListener();
    private final IJobChangeListenerEx m_jobChangeListenerEx = new P_JobChangeListenerEx();
    private JobManagerResumeThread m_jobManagerResumeThread;

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        Job.getJobManager().addJobChangeListener(this.m_jobChangeListener);
        this.m_jobManagerResumeThread = new JobManagerResumeThread();
        this.m_jobManagerResumeThread.start();
    }

    public void disposeServices() {
        try {
            if (this.m_jobManagerResumeThread != null) {
                this.m_jobManagerResumeThread.cancel();
            }
            this.m_jobManagerResumeThread = null;
            Job.getJobManager().removeJobChangeListener(this.m_jobChangeListener);
        }
        finally {
            super.disposeServices();
        }
    }

    private IBusyHandler getHandlerInternal(Job job) {
        if (job instanceof IClientSessionProvider) {
            IClientSession session = ((IClientSessionProvider)job).getClientSession();
            return this.getHandler(session);
        }
        return null;
    }

    @Override
    public IBusyHandler getHandler(IClientSession session) {
        if (session != null) {
            return (IBusyHandler)session.getData(HANDLER_CLIENT_SESSION_KEY);
        }
        return null;
    }

    @Override
    public synchronized void register(IClientSession session, IBusyHandler handler) {
        if (session == null || handler == null) {
            return;
        }
        session.setData(HANDLER_CLIENT_SESSION_KEY, handler);
    }

    @Override
    public synchronized void unregister(IClientSession session) {
        if (session == null) {
            return;
        }
        session.setData(HANDLER_CLIENT_SESSION_KEY, null);
    }

    private static class JobManagerResumeThread
    extends Thread {
        private boolean m_running = true;

        public JobManagerResumeThread() {
            super("JobManager-Resume");
            this.setDaemon(true);
        }

        public void cancel() {
            this.m_running = false;
        }

        @Override
        public void run() {
            while (this.m_running) {
                try {
                    Thread.sleep(2000L);
                    if (!this.m_running) {
                        return;
                    }
                    IJobManager m = Job.getJobManager();
                    if (m == null || m.isSuspended()) continue;
                    m.resume();
                    continue;
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
            return;
        }
    }

    private class P_JobChangeListener
    extends JobChangeAdapter {
        private P_JobChangeListener() {
        }

        public void running(IJobChangeEvent event) {
            Job job = event.getJob();
            IBusyHandler handler = BusyManagerService.this.getHandlerInternal(job);
            if (handler == null) {
                return;
            }
            if (!handler.acceptJob(job)) {
                return;
            }
            if (job instanceof ClientJob) {
                ((ClientJob)job).addJobChangeListenerEx(BusyManagerService.this.m_jobChangeListenerEx);
            }
            handler.onJobBegin(job);
        }

        public void done(IJobChangeEvent event) {
            Job job = event.getJob();
            IBusyHandler handler = BusyManagerService.this.getHandlerInternal(job);
            if (handler == null) {
                return;
            }
            if (!handler.acceptJob(job)) {
                return;
            }
            if (job instanceof ClientJob) {
                ((ClientJob)job).removeJobChangeListenerEx(BusyManagerService.this.m_jobChangeListenerEx);
            }
            handler.onJobEnd(job);
        }
    }

    private class P_JobChangeListenerEx
    extends JobChangeAdapterEx {
        private P_JobChangeListenerEx() {
        }

        @Override
        public void blockingConditionStart(IJobChangeEvent event) {
            Job job = event.getJob();
            IBusyHandler handler = BusyManagerService.this.getHandlerInternal(job);
            if (handler == null) {
                return;
            }
            handler.onJobEnd(job);
        }

        @Override
        public void blockingConditionEnd(IJobChangeEvent event) {
            Job job = event.getJob();
            IBusyHandler handler = BusyManagerService.this.getHandlerInternal(job);
            if (handler == null) {
                return;
            }
            handler.onJobBegin(job);
        }
    }
}

