/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;

public abstract class AbstractOutlineTableField
extends AbstractTableField<ITable> {
    private DesktopListener m_desktopListener;
    private PropertyChangeListener m_tablePropertyListener;

    @Override
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @ConfigOperation
    @Order(value=1000.0)
    protected void execTableTitleChanged() {
        if (this.getTable() != null) {
            this.setLabel(this.getTable().getTitle());
        } else {
            this.setLabel(null);
        }
    }

    @Override
    protected void execInitField() throws ProcessingException {
        this.m_tablePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("title")) {
                    AbstractOutlineTableField.this.execTableTitleChanged();
                }
            }
        };
    }

    @Override
    protected void execDisposeField() throws ProcessingException {
        super.execDisposeField();
        ClientSyncJob.getCurrentSession().getDesktop().removeDesktopListener(this.m_desktopListener);
        this.m_desktopListener = null;
    }

    public void installTable(ITable table) {
        if (this.getTable() == table) {
            return;
        }
        if (this.getTable() != null) {
            this.getTable().removePropertyChangeListener(this.m_tablePropertyListener);
        }
        this.setTable(table, true);
        if (this.getTable() != null) {
            this.getTable().addPropertyChangeListener(this.m_tablePropertyListener);
        }
        this.execTableTitleChanged();
    }
}

