/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.xmlparser.SimpleXmlElement;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.common.search.ISearchFilterService;
import org.eclipse.scout.rt.client.ui.DataChangeListener;
import org.eclipse.scout.rt.client.ui.WeakDataChangeListener;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValidateContentDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.MasterListener;
import org.eclipse.scout.rt.client.ui.form.fields.ValidateFormFieldDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

@FormData(value=AbstractFormFieldData.class, sdkCommand=FormData.SdkCommand.USE)
public abstract class AbstractFormField
extends AbstractPropertyObserver
implements IFormField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractFormField.class);
    private IForm m_form;
    private boolean m_initialized;
    private Permission m_enabledPermission;
    private boolean m_enabledGranted;
    private boolean m_enabledProperty;
    private boolean m_enabledSlave;
    private boolean m_enabledProcessingButton;
    private Permission m_visiblePermission;
    private boolean m_visibleGranted;
    private boolean m_visibleProperty;
    private int m_valueChangeTriggerEnabled = 1;
    private IValueField<?> m_masterField;
    private boolean m_masterRequired;
    private GridData m_gridData;
    private GridData m_gridDataHints;
    private boolean m_labelVisible;
    private boolean m_labelSuppressed;
    private int m_labelPosition;
    private int m_labelWidthInPixel;
    private int m_labelHorizontalAlignment;
    private boolean m_touched;
    private BasicPropertySupport m_subtreePropertyChangeSupport;
    private P_MasterListener m_currentMasterListener;
    private DataChangeListener m_internalDataChangeListener;
    private String m_initialLabel;

    public AbstractFormField() {
        this(true);
    }

    public AbstractFormField(boolean callInitializer) {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerFormField(this);
        }
        this.m_enabledGranted = true;
        this.m_enabledSlave = true;
        this.m_enabledProcessingButton = true;
        this.m_visibleGranted = true;
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            try {
                this.setValueChangeTriggerEnabled(false);
                this.initConfig();
            }
            finally {
                this.setValueChangeTriggerEnabled(true);
            }
            this.m_initialized = true;
        }
    }

    public static String parseFormFieldId(String className) {
        String s = className;
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Deprecated
    protected String getConfiguredSearchTerm() {
        return null;
    }

    @Deprecated
    public final String getLegacySearchTerm() {
        return this.getConfiguredSearchTerm();
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredLabel() {
        return null;
    }

    @ConfigProperty(value="LABEL_POSITION")
    @Order(value=15.0)
    @ConfigPropertyValue(value="LABEL_POSITION_DEFAULT")
    protected int getConfiguredLabelPosition() {
        return 0;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=16.0)
    @ConfigPropertyValue(value="LABEL_WIDTH_DEFAULT")
    protected int getConfiguredLabelWidthInPixel() {
        return 0;
    }

    @ConfigProperty(value="LABEL_HORIZONTAL_ALIGNMENT")
    @Order(value=17.0)
    @ConfigPropertyValue(value="LABEL_HORIZONTAL_ALIGNMENT_DEFAULT")
    protected int getConfiguredLabelHorizontalAlignment() {
        return 1000;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredLabelVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=40.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=45.0)
    @ConfigPropertyValue(value="false")
    @ValidationRule(value="mandatory")
    protected boolean getConfiguredMandatory() {
        return false;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=50.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTooltipText() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=60.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredForegroundColor() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=70.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredBackgroundColor() {
        return null;
    }

    @ConfigProperty(value="FONT")
    @Order(value=80.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFont() {
        return null;
    }

    @ConfigProperty(value="HORIZONTAL_ALIGNMENT")
    @Order(value=85.0)
    @ConfigPropertyValue(value="-1")
    protected int getConfiguredHorizontalAlignment() {
        return -1;
    }

    @ConfigProperty(value="VERTICAL_ALIGNMENT")
    @Order(value=86.0)
    @ConfigPropertyValue(value="-1")
    protected int getConfiguredVerticalAlignment() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=87.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredFillHorizontal() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=88.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredFillVertical() {
        return true;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=90.0)
    @ConfigPropertyValue(value="-1")
    protected int getConfiguredGridX() {
        return -1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=95.0)
    @ConfigPropertyValue(value="-1")
    protected int getConfiguredGridY() {
        return -1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=100.0)
    @ConfigPropertyValue(value="1")
    protected int getConfiguredGridW() {
        return 1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=105.0)
    @ConfigPropertyValue(value="1")
    protected int getConfiguredGridH() {
        return 1;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=130.0)
    @ConfigPropertyValue(value="-1")
    protected double getConfiguredGridWeightX() {
        return -1.0;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=140.0)
    @ConfigPropertyValue(value="-1")
    protected double getConfiguredGridWeightY() {
        return -1.0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=142.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredGridUseUiWidth() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=142.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredGridUseUiHeight() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=150.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredWidthInPixel() {
        return 0;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=160.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredHeightInPixel() {
        return 0;
    }

    @ConfigProperty(value="MASTER_FIELD")
    @Order(value=170.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="masterValueField")
    protected Class<? extends IValueField> getConfiguredMasterField() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=180.0)
    @ConfigPropertyValue(value="false")
    @ValidationRule(value="masterValueRequired")
    protected boolean getConfiguredMasterRequired() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=190.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredFocusable() {
        return true;
    }

    @ConfigProperty(value="DOC")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDoc() {
        return null;
    }

    private Class<? extends IKeyStroke>[] getConfiguredKeyStrokes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, IKeyStroke.class);
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitField() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=11.0)
    protected boolean execIsSaveNeeded() throws ProcessingException {
        return false;
    }

    @ConfigOperation
    @Order(value=12.0)
    protected void execMarkSaved() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=13.0)
    protected boolean execIsEmpty() throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=14.0)
    protected void execDataChanged(Object ... dataTypes) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDisposeField() throws ProcessingException {
    }

    @Override
    public final void applySearch(SearchFilter search) {
        this.execAddSearchTerms(search);
    }

    protected void execAddSearchTerms(SearchFilter search) {
        this.applySearchInternal(search);
    }

    protected void applySearchInternal(SearchFilter search) {
        ISearchFilterService sfs = (ISearchFilterService)SERVICES.getService(ISearchFilterService.class);
        if (sfs != null) {
            sfs.applySearchDelegate(this, search, true);
        }
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execChangedMasterValue(Object newMasterValue) throws ProcessingException {
    }

    protected void initConfig() {
        this.m_gridData = new GridData(-1, -1, 1, 1, -1.0, -1.0);
        this.m_gridDataHints = new GridData(-1, -1, 1, 1, -1.0, -1.0);
        this.propertySupport.setPropertyBool("empty", true);
        this.setEnabled(this.getConfiguredEnabled());
        this.setVisible(this.getConfiguredVisible());
        this.setMandatory(this.getConfiguredMandatory());
        this.setTooltipText(this.getConfiguredTooltipText());
        this.setInitialLabel(this.getConfiguredLabel());
        this.setLabel(this.getConfiguredLabel());
        this.setLabelPosition(this.getConfiguredLabelPosition());
        this.setLabelWidthInPixel(this.getConfiguredLabelWidthInPixel());
        this.setLabelHorizontalAlignment(this.getConfiguredLabelHorizontalAlignment());
        this.setLabelVisible(this.getConfiguredLabelVisible());
        if (this.getConfiguredBackgroundColor() != null) {
            this.setBackgroundColor(this.getConfiguredBackgroundColor());
        }
        if (this.getConfiguredForegroundColor() != null) {
            this.setForegroundColor(this.getConfiguredForegroundColor());
        }
        if (this.getConfiguredFont() != null) {
            this.setFont(FontSpec.parse((String)this.getConfiguredFont()));
        }
        this.setFocusable(this.getConfiguredFocusable());
        this.setGridDataHints(new GridData(this.getConfiguredGridX(), this.getConfiguredGridY(), this.getConfiguredGridW(), this.getConfiguredGridH(), this.getConfiguredGridWeightX(), this.getConfiguredGridWeightY(), this.getConfiguredGridUseUiWidth(), this.getConfiguredGridUseUiHeight(), this.getConfiguredHorizontalAlignment(), this.getConfiguredVerticalAlignment(), this.getConfiguredFillHorizontal(), this.getConfiguredFillVertical(), this.getConfiguredWidthInPixel(), this.getConfiguredHeightInPixel()));
        this.setMasterRequired(this.getConfiguredMasterRequired());
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AbstractFormField.this.fireSubtreePropertyChange(e);
            }
        });
    }

    @Override
    public boolean isInitialized() {
        return this.m_initialized;
    }

    @Override
    public void postInitConfig() throws ProcessingException {
        this.updateKeyStrokes();
        if (this.getConfiguredMasterField() != null) {
            IValueField master = this.getForm().getFieldByClass(this.getConfiguredMasterField());
            this.setMasterField(master);
        }
    }

    @Override
    public final void initField() throws ProcessingException {
        try {
            this.setValueChangeTriggerEnabled(false);
            this.initFieldInternal();
            this.execInitField();
        }
        finally {
            this.setValueChangeTriggerEnabled(true);
        }
    }

    protected void initFieldInternal() throws ProcessingException {
        this.checkSaveNeeded();
        this.checkEmpty();
    }

    @Override
    public final void disposeField() {
        try {
            this.disposeFieldInternal();
        }
        catch (Throwable t) {
            LOG.warn("Field " + this.getClass().getName(), t);
        }
        try {
            this.execDisposeField();
        }
        catch (Throwable t) {
            LOG.warn("Field " + this.getClass().getName(), t);
        }
    }

    protected void disposeFieldInternal() {
    }

    public void registerDataChangeListener(Object ... dataTypes) {
        IDesktop desktop;
        if (this.m_internalDataChangeListener == null) {
            this.m_internalDataChangeListener = new WeakDataChangeListener(){

                @Override
                public void dataChanged(Object ... innerDataTypes) throws ProcessingException {
                    AbstractFormField.this.execDataChanged(innerDataTypes);
                }
            };
        }
        if ((desktop = ClientSyncJob.getCurrentSession().getDesktop()) == null) {
            desktop = ClientSyncJob.getCurrentSession().getVirtualDesktop();
        }
        desktop.addDataChangeListener(this.m_internalDataChangeListener, dataTypes);
    }

    public void unregisterDataChangeListener(Object ... dataTypes) {
        if (this.m_internalDataChangeListener != null) {
            ClientSyncJob.getCurrentSession().getDesktop().removeDataChangeListener(this.m_internalDataChangeListener, dataTypes);
        }
    }

    protected void fireSubtreePropertyChange(PropertyChangeEvent e) {
        ICompositeField parentField = this.getParentField();
        if (parentField instanceof AbstractFormField) {
            ((AbstractFormField)((Object)parentField)).fireSubtreePropertyChange(e);
        }
        if (this.m_subtreePropertyChangeSupport != null) {
            this.m_subtreePropertyChangeSupport.firePropertyChange(e);
        }
    }

    @Override
    public IForm getForm() {
        return this.m_form;
    }

    @Override
    public IGroupBox getParentGroupBox() {
        ICompositeField f = this.getParentField();
        while (f != null && !(f instanceof IGroupBox)) {
            f = f.getParentField();
        }
        return (IGroupBox)f;
    }

    @Override
    public ICompositeField getParentField() {
        return (ICompositeField)this.propertySupport.getProperty("parentField");
    }

    @Override
    public void setParentFieldInternal(ICompositeField f) {
        this.propertySupport.setProperty("parentField", (Object)f);
    }

    @Override
    public void setFormInternal(IForm form) {
        this.m_form = form;
    }

    public String toString() {
        return String.valueOf(this.getLabel()) + "/" + this.getFieldId() + " (" + this.getClass().getName() + ")";
    }

    @Override
    public void printField(PrintDevice device, Map<String, Object> parameters) {
        this.getForm().printField(this, device, parameters);
    }

    @Override
    public void setView(boolean visible, boolean enabled, boolean mandatory) {
        this.setVisible(visible);
        this.setEnabled(enabled);
        this.setMandatory(mandatory);
    }

    @Override
    public boolean isValueChangeTriggerEnabled() {
        return this.m_valueChangeTriggerEnabled >= 1;
    }

    @Override
    public void setValueChangeTriggerEnabled(boolean b) {
        this.m_valueChangeTriggerEnabled = b ? ++this.m_valueChangeTriggerEnabled : --this.m_valueChangeTriggerEnabled;
    }

    @Override
    public void addSubtreePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null && this.m_subtreePropertyChangeSupport == null) {
            this.m_subtreePropertyChangeSupport = new BasicPropertySupport((Object)this);
        }
        this.m_subtreePropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addSubtreePropertyChangeListener(String propName, PropertyChangeListener listener) {
        if (listener != null && this.m_subtreePropertyChangeSupport == null) {
            this.m_subtreePropertyChangeSupport = new BasicPropertySupport((Object)this);
        }
        this.m_subtreePropertyChangeSupport.addPropertyChangeListener(propName, listener);
    }

    @Override
    public void removeSubtreePropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_subtreePropertyChangeSupport != null) {
            this.m_subtreePropertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    @Override
    public void removeSubtreePropertyChangeListener(String propName, PropertyChangeListener listener) {
        if (this.m_subtreePropertyChangeSupport != null) {
            this.m_subtreePropertyChangeSupport.removePropertyChangeListener(propName, listener);
        }
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertySupport.hasProperty(name);
    }

    @Override
    public boolean isFieldChanging() {
        return this.propertySupport.isPropertiesChanging();
    }

    @Override
    public void setFieldChanging(boolean b) {
        this.propertySupport.setPropertiesChanging(b);
    }

    @Override
    public String getFieldId() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void exportFormFieldData(AbstractFormFieldData target) throws ProcessingException {
    }

    @Override
    public void importFormFieldData(AbstractFormFieldData source, boolean valueChangeTriggersEnabled) throws ProcessingException {
    }

    @Override
    public void storeXML(SimpleXmlElement x) throws ProcessingException {
        Class currentEnclosingFieldType = ConfigurationUtility.getEnclosingContainerType((Object)this);
        ICompositeField p = this.getParentField();
        while (p != null) {
            Class enclosingFieldType = ConfigurationUtility.getEnclosingContainerType((Object)p);
            if (enclosingFieldType != currentEnclosingFieldType) {
                SimpleXmlElement enclosingField = new SimpleXmlElement("enclosingField");
                this.setXmlFormFieldIds(enclosingField, p);
                x.addChild(enclosingField, 0);
                currentEnclosingFieldType = enclosingFieldType;
            }
            p = p.getParentField();
        }
        this.setXmlFormFieldIds(x, this);
    }

    private void setXmlFormFieldIds(SimpleXmlElement x, IFormField f) {
        x.setAttribute("fieldId", (Object)f.getFieldId());
        x.setAttribute("fieldQname", (Object)f.getClass().getName());
    }

    @Override
    public void loadXML(SimpleXmlElement x) throws ProcessingException {
    }

    @Override
    public final void setXML(String xml) throws ProcessingException {
        if (xml == null) {
            return;
        }
        try {
            SimpleXmlElement root = new SimpleXmlElement();
            root.parseString(xml);
            this.loadXML(root);
        }
        catch (Exception e) {
            throw new ProcessingException("Error in AbstractFormField.setXML: ", (Throwable)e);
        }
    }

    @Override
    public final String getXML() throws ProcessingException {
        SimpleXmlElement x = new SimpleXmlElement("field");
        this.storeXML(x);
        StringWriter sw = new StringWriter();
        try {
            x.writeDocument((Writer)sw, null, "UTF-8");
        }
        catch (IOException iOException) {}
        return sw.toString();
    }

    @Override
    public String getInitialLabel() {
        return this.m_initialLabel;
    }

    @Override
    public void setInitialLabel(String name) {
        this.m_initialLabel = name;
    }

    @Override
    public String getLabel() {
        return this.propertySupport.getPropertyString("label");
    }

    @Override
    public void setLabel(String name) {
        this.propertySupport.setPropertyString("label", name);
    }

    @Override
    public int getLabelPosition() {
        return this.m_labelPosition;
    }

    @Override
    public void setLabelPosition(int position) {
        this.m_labelPosition = position;
    }

    @Override
    public int getLabelWidthInPixel() {
        return this.m_labelWidthInPixel;
    }

    @Override
    public void setLabelWidthInPixel(int w) {
        this.m_labelWidthInPixel = w;
    }

    @Override
    public int getLabelHorizontalAlignment() {
        return this.m_labelHorizontalAlignment;
    }

    @Override
    public void setLabelHorizontalAlignment(int a) {
        this.m_labelHorizontalAlignment = a;
    }

    @Override
    public String getFullyQualifiedLabel(String separator) {
        String s;
        StringBuffer b = new StringBuffer();
        ICompositeField p = this.getParentField();
        if (p != null && (s = p.getFullyQualifiedLabel(separator)) != null) {
            b.append(s);
        }
        if ((s = this.getLabel()) != null) {
            if (b.length() > 0) {
                b.append(separator);
            }
            b.append(s);
        }
        return b.toString();
    }

    @Override
    public boolean isLabelVisible() {
        return this.propertySupport.getPropertyBool("labelVisible");
    }

    @Override
    public void setLabelVisible(boolean b) {
        this.m_labelVisible = b;
        this.calculateLabelVisible();
    }

    private void calculateLabelVisible() {
        this.propertySupport.setPropertyBool("labelVisible", this.m_labelVisible && !this.m_labelSuppressed);
    }

    @Override
    public boolean isLabelSuppressed() {
        return this.m_labelSuppressed;
    }

    @Override
    public void setLabelSuppressed(boolean b) {
        this.m_labelSuppressed = b;
        this.calculateLabelVisible();
    }

    @Override
    public Object getCustomProperty(String propName) {
        return this.propertySupport.getProperty(propName);
    }

    @Override
    public void setCustomProperty(String propName, Object o) {
        this.propertySupport.setProperty(propName, o);
    }

    @Override
    public Permission getEnabledPermission() {
        return this.m_enabledPermission;
    }

    @Override
    public void setEnabledPermission(Permission p) {
        ICompositeField container;
        this.m_enabledPermission = p;
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : ((container = this.getParentField()) != null ? container.isEnabledGranted() : this.getForm().isEnabledGranted());
        this.setEnabledGranted(b);
    }

    @Override
    public boolean isEnabledGranted() {
        return this.m_enabledGranted;
    }

    @Override
    public boolean getEnabledProperty() {
        return this.m_enabledProperty;
    }

    @Override
    public void setEnabledGranted(boolean b) {
        this.m_enabledGranted = b;
        this.calculateEnabled();
    }

    @Override
    public boolean isEnabledProcessingButton() {
        return this.m_enabledProcessingButton;
    }

    @Override
    public void setEnabledProcessingButton(boolean b) {
        this.m_enabledProcessingButton = b;
        this.calculateEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_enabledProperty = b;
        if (b) {
            this.m_enabledSlave = true;
        }
        this.calculateEnabled();
    }

    protected void calculateEnabled() {
        boolean applyAccessControl = true;
        if (this instanceof IButton) {
            IButton but = (IButton)((Object)this);
            switch (but.getSystemType()) {
                case 1: 
                case 2: {
                    applyAccessControl = false;
                }
            }
        }
        if (applyAccessControl) {
            this.propertySupport.setPropertyBool("enabled", this.m_enabledGranted && this.m_enabledProperty && this.m_enabledSlave && this.m_enabledProcessingButton);
        } else {
            this.propertySupport.setPropertyBool("enabled", this.m_enabledProperty && this.m_enabledSlave && this.m_enabledProcessingButton);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.propertySupport.getPropertyBool("enabled");
    }

    @Override
    public Permission getVisiblePermission() {
        return this.m_visiblePermission;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        ICompositeField container;
        this.m_visiblePermission = p;
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : ((container = this.getParentField()) != null ? container.isVisibleGranted() : true);
        this.setVisibleGranted(b);
    }

    @Override
    public final boolean isSaveNeeded() {
        return this.propertySupport.getPropertyBool("saveNeeded");
    }

    @Override
    public final void checkSaveNeeded() {
        if (this.isInitialized()) {
            try {
                this.propertySupport.setPropertyBool("saveNeeded", this.m_touched || this.execIsSaveNeeded());
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    @Override
    public void touch() {
        this.m_touched = true;
        this.checkSaveNeeded();
    }

    @Override
    public final void markSaved() {
        try {
            this.m_touched = false;
            this.execMarkSaved();
            this.checkSaveNeeded();
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.propertySupport.getPropertyBool("empty");
    }

    protected final void checkEmpty() {
        if (this.isInitialized()) {
            try {
                this.propertySupport.setPropertyBool("empty", this.execIsEmpty());
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        this.calculateVisibleInternal();
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean b) {
        this.m_visibleProperty = b;
        this.calculateVisibleInternal();
    }

    protected boolean execCalculateVisible() {
        return true;
    }

    protected void calculateVisibleInternal() {
        boolean changed;
        boolean applyAccessControl = true;
        if (this instanceof IButton) {
            IButton but = (IButton)((Object)this);
            switch (but.getSystemType()) {
                case 1: 
                case 2: {
                    applyAccessControl = false;
                }
            }
        }
        if ((changed = applyAccessControl ? this.propertySupport.setPropertyBool("visible", this.m_visibleGranted && this.m_visibleProperty && this.execCalculateVisible()) : this.propertySupport.setPropertyBool("visible", this.m_visibleProperty && this.execCalculateVisible())) && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    @Override
    public boolean isMandatory() {
        return this.propertySupport.getPropertyBool("mandatory");
    }

    @Override
    public void setMandatory(boolean b) {
        this.propertySupport.setPropertyBool("mandatory", b);
    }

    @Override
    public IProcessingStatus getErrorStatus() {
        return (IProcessingStatus)this.propertySupport.getProperty("errorStatus");
    }

    @Override
    public void setErrorStatus(String message) {
        this.setErrorStatus((IProcessingStatus)new ProcessingStatus(message, null, 0, 4));
    }

    @Override
    public void setErrorStatus(IProcessingStatus status) {
        this.propertySupport.setProperty("errorStatus", (Object)status);
    }

    @Override
    public void clearErrorStatus() {
        this.propertySupport.setProperty("errorStatus", null);
    }

    @Override
    public IValidateContentDescriptor validateContent() {
        if (!this.isContentValid()) {
            return new ValidateFormFieldDescriptor(this);
        }
        return null;
    }

    @Override
    public boolean isContentValid() {
        IProcessingStatus errorStatus = this.getErrorStatus();
        return errorStatus == null || errorStatus.getSeverity() != 4 && errorStatus.getSeverity() != 16;
    }

    @Override
    public void setTooltipText(String text) {
        this.propertySupport.setPropertyString("tooltipText", text);
    }

    @Override
    public String getTooltipText() {
        return this.propertySupport.getPropertyString("tooltipText");
    }

    @Override
    public void setForegroundColor(String c) {
        this.propertySupport.setProperty("foregroundColor", (Object)c);
    }

    @Override
    public String getForegroundColor() {
        return (String)this.propertySupport.getProperty("foregroundColor");
    }

    @Override
    public void setBackgroundColor(String c) {
        this.propertySupport.setProperty("backgroundColor", (Object)c);
    }

    @Override
    public String getBackgroundColor() {
        return (String)this.propertySupport.getProperty("backgroundColor");
    }

    @Override
    public void setFont(FontSpec f) {
        this.propertySupport.setProperty("font", (Object)f);
    }

    @Override
    public FontSpec getFont() {
        return (FontSpec)this.propertySupport.getProperty("font");
    }

    @Override
    public GridData getGridData() {
        return new GridData(this.m_gridData);
    }

    @Override
    public void setGridDataInternal(GridData data) {
        this.m_gridData = new GridData(data);
    }

    @Override
    public GridData getGridDataHints() {
        return new GridData(this.m_gridDataHints);
    }

    @Override
    public void setGridDataHints(GridData hints) {
        this.m_gridDataHints = new GridData(hints);
    }

    @Override
    public void requestFocus() {
        IForm form = this.getForm();
        if (form != null) {
            form.requestFocus(this);
        }
    }

    @Override
    public boolean fetchFocusRequested() {
        return false;
    }

    @Override
    public void setFocusable(boolean b) {
        this.propertySupport.setPropertyBool("focusable", b);
    }

    @Override
    public boolean isFocusable() {
        return this.propertySupport.getPropertyBool("focusable");
    }

    @Override
    public void setMasterField(IValueField field) {
        IValueField oldMasterField = this.getMasterField();
        if (oldMasterField != null && this.m_currentMasterListener != null) {
            oldMasterField.removeMasterListener(this.m_currentMasterListener);
            this.m_currentMasterListener = null;
        }
        if (field != null) {
            this.m_currentMasterListener = new P_MasterListener();
            field.addMasterListener(this.m_currentMasterListener);
            this.m_enabledSlave = field.getValue() != null || !this.isMasterRequired();
            this.setEnabledGranted(this.m_enabledGranted);
        }
        this.m_masterField = field;
    }

    @Override
    public IValueField getMasterField() {
        return this.m_masterField;
    }

    @Override
    public Object getMasterValue() {
        if (this.getMasterField() != null) {
            return this.getMasterField().getValue();
        }
        return null;
    }

    @Override
    public void setMasterRequired(boolean b) {
        this.m_masterRequired = b;
    }

    @Override
    public boolean isMasterRequired() {
        return this.m_masterRequired;
    }

    @Override
    public void updateKeyStrokes() {
        IKeyStroke ks;
        int n;
        int n2;
        IKeyStroke[] iKeyStrokeArray;
        HashMap<String, IKeyStroke> ksMap = new HashMap<String, IKeyStroke>();
        IKeyStroke[] c = this.getLocalKeyStrokes();
        if (c != null) {
            iKeyStrokeArray = c;
            n2 = c.length;
            n = 0;
            while (n < n2) {
                ks = iKeyStrokeArray[n];
                if (ks != null) {
                    ksMap.put(ks.getKeyStroke().toUpperCase(), ks);
                }
                ++n;
            }
        }
        if ((c = this.getContributedKeyStrokes()) != null) {
            iKeyStrokeArray = c;
            n2 = c.length;
            n = 0;
            while (n < n2) {
                ks = iKeyStrokeArray[n];
                if (ks != null) {
                    ksMap.put(ks.getKeyStroke().toUpperCase(), ks);
                }
                ++n;
            }
        }
        this.propertySupport.setProperty("keyStrokes", (Object)ksMap.values().toArray(new IKeyStroke[ksMap.size()]));
    }

    @Override
    public IKeyStroke[] getContributedKeyStrokes() {
        return null;
    }

    @Override
    public IKeyStroke[] getLocalKeyStrokes() {
        HashMap<String, IKeyStroke> ksMap = new HashMap<String, IKeyStroke>();
        Class<? extends IKeyStroke>[] shortcutArray = this.getConfiguredKeyStrokes();
        int i = 0;
        while (i < shortcutArray.length) {
            try {
                IKeyStroke ks = (IKeyStroke)ConfigurationUtility.newInnerInstance((Object)this, shortcutArray[i]);
                ksMap.put(ks.getKeyStroke().toUpperCase(), ks);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("keyStroke: " + shortcutArray[i].getName(), t));
            }
            ++i;
        }
        return ksMap.values().toArray(new IKeyStroke[ksMap.size()]);
    }

    @Override
    public IKeyStroke[] getKeyStrokes() {
        IKeyStroke[] keyStrokes = (IKeyStroke[])this.propertySupport.getProperty("keyStrokes");
        if (keyStrokes == null) {
            keyStrokes = new IKeyStroke[]{};
        }
        return keyStrokes;
    }

    private class P_MasterListener
    implements MasterListener {
        private P_MasterListener() {
        }

        @Override
        public void masterChanged(Object newMasterValue) {
            if (this == AbstractFormField.this.m_currentMasterListener) {
                AbstractFormField.this.m_enabledSlave = newMasterValue != null || !AbstractFormField.this.isMasterRequired();
                AbstractFormField.this.setEnabledGranted(AbstractFormField.this.m_enabledGranted);
                try {
                    AbstractFormField.this.execChangedMasterValue(newMasterValue);
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
            }
        }
    }
}

