/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ThreadContextLegacy;
import org.eclipse.scout.rt.server.transaction.ITransaction;

public final class ThreadContext {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ThreadContext.class);
    private static final ThreadLocal<HttpServletRequest> HTTP_SERVLET_REQUEST = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> HTTP_SERVLET_RESPONSE = new ThreadLocal();
    private static final ThreadLocal<IServerSession> SERVER_SESSION = new ThreadLocal();
    private static final ThreadLocal<ITransaction> TRANSACTION = new ThreadLocal();

    private ThreadContext() {
    }

    public static HttpServletRequest getHttpServletRequest() {
        return HTTP_SERVLET_REQUEST.get();
    }

    public static HttpServletResponse getHttpServletResponse() {
        return HTTP_SERVLET_RESPONSE.get();
    }

    public static IServerSession getServerSession() {
        return SERVER_SESSION.get();
    }

    public static ITransaction getTransaction() {
        return TRANSACTION.get();
    }

    public static Map<Class, Object> backup() {
        return ThreadContextLegacy.backup();
    }

    public static void restore(Map<Class, Object> map) {
        ThreadContextLegacy.restore(map);
    }

    public static void putHttpServletRequest(HttpServletRequest value) {
        HTTP_SERVLET_REQUEST.set(value);
    }

    public static void putHttpServletResponse(HttpServletResponse value) {
        HTTP_SERVLET_RESPONSE.set(value);
    }

    public static void putServerSession(IServerSession value) {
        SERVER_SESSION.set(value);
    }

    public static void putTransaction(ITransaction value) {
        TRANSACTION.set(value);
    }

    @Deprecated
    public static <T> T get(Class<T> key) {
        return ThreadContextLegacy.get(key);
    }

    @Deprecated
    public static <T> void put(T value) {
        ThreadContextLegacy.put(value);
    }
}

