/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueInputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindInput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class SingleInput
implements IBindInput {
    private int m_batchIndex = -1;
    private int m_jdbcBindIndex = -1;
    private Object m_value;
    private Class m_nullType;
    private ValueInputToken m_target;

    public SingleInput(Object value, Class nullType, ValueInputToken target) {
        this.m_value = value;
        this.m_nullType = nullType;
        this.m_target = target;
    }

    @Override
    public IToken getToken() {
        return this.m_target;
    }

    @Override
    public boolean isBatch() {
        return this.m_target.isBatch();
    }

    @Override
    public boolean hasBatch(int i) {
        return i <= 0;
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_batchIndex = i;
    }

    @Override
    public boolean isJdbcBind() {
        if (this.m_target.isPlainValue()) {
            return false;
        }
        return !this.m_target.isPlainSql();
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_jdbcBindIndex;
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_jdbcBindIndex = index;
    }

    @Override
    public SqlBind produceSqlBindAndSetReplaceToken(ISqlStyle sqlStyle) throws ProcessingException {
        Object value = null;
        if (!this.isBatch() || this.m_batchIndex <= 0) {
            value = this.m_value;
        }
        if (this.m_target.isPlainValue()) {
            this.m_target.setReplaceToken(sqlStyle.toPlainText(value));
            return null;
        }
        if (this.m_target.isPlainSql()) {
            this.m_target.setReplaceToken("" + value);
            return null;
        }
        this.m_target.setReplaceToken("?");
        return sqlStyle.buildBindFor(value, this.m_nullType);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[value=" + this.m_value + ", token=" + this.m_target + "]";
    }
}

