/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.server.admin.html.AbstractHtmlAction;
import org.eclipse.scout.rt.server.admin.html.view.TopView;
import org.eclipse.scout.rt.server.admin.html.widget.table.HtmlComponent;
import org.eclipse.scout.rt.server.admin.inspector.ProcessInspector;
import org.eclipse.scout.rt.shared.OfficialVersion;

public class AdminSession {
    private TopView m_topView = new TopView(this);
    private Map<String, AbstractHtmlAction> m_actionMap = new HashMap<String, AbstractHtmlAction>();

    public void serviceRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        AbstractHtmlAction action;
        HtmlComponent emitter = new HtmlComponent(req, res);
        String actionId = req.getParameter("actionId");
        if (actionId != null && (action = this.getAction(actionId)) != null) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            for (String n : req.getParameterMap().keySet()) {
                String v = StringUtility.valueOf((Object)req.getParameter(n));
                paramMap.put(n, v);
            }
            action.setFormParameters(paramMap);
            try {
                action.run();
            }
            catch (Exception e) {
                action.setException(e);
            }
            emitter.setInvokedAction(action);
        }
        ProcessInspector.getDefault().update();
        this.m_topView.produceBody(emitter);
        this.setActionMap(emitter.getActionMap());
        res.setContentType("text/html");
        res.setDateHeader("Expires", -1L);
        res.setHeader("Cache-Control", "no-cache");
        res.setHeader("pragma", "no-cache");
        ServletOutputStream out = res.getOutputStream();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Eclipse Scout</title>");
        out.println("<style>");
        out.println("body {font-family: sans-serif; font-size: 12; background-color : #F6F6F6;}");
        out.println("a,a:VISITED {color: #6666ff;text-decoration: none;}");
        out.println("table {font-size: 12; empty-cells: show;}");
        out.println("th {text-align: left;vertical-align: top; padding-left: 2; background-color : #cccccc;}");
        out.println("td {text-align: left;vertical-align: top; padding-left: 2;}");
        out.println("p {margin-top: 4; margin-bottom: 4; padding-top: 4; padding-bottom: 4;}");
        out.println(".copyright {font-size: 10;}");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h3>Eclipse Scout</h3>");
        out.print(emitter.getProducedHtml());
        out.println("<p class=\"copyright\">&copy; " + OfficialVersion.COPYRIGHT + "</p>");
        out.println("</body>");
        out.println("</html>");
    }

    private AbstractHtmlAction getAction(String actionId) {
        return this.m_actionMap.get(actionId);
    }

    private void setActionMap(Map<String, AbstractHtmlAction> newActionMap) {
        this.m_actionMap = new HashMap<String, AbstractHtmlAction>(newActionMap);
    }

    public TopView getTopView() {
        return this.m_topView;
    }
}

