/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.scheduler;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.scout.rt.server.scheduler.TickSignal;

public class Ticker {
    private Calendar m_cal;
    private int m_tickField = 12;

    public Ticker() {
        this(12);
    }

    public Ticker(int tickMode) {
        this.m_cal = Calendar.getInstance();
        this.setTickMode(tickMode);
    }

    public Ticker(Ticker other) {
        this.setTickMode(other.getTickMode());
        this.setTime(other.getTime());
    }

    public void setTickMode(int calendarField) {
        switch (calendarField) {
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                this.m_tickField = calendarField;
                break;
            }
            default: {
                throw new IllegalArgumentException("tickMode must be one of: Calendar.DATE,Calendar.HOUR_OF_DAY, Calendar.MINUTE, Calendar.SECOND");
            }
        }
        this.adjustTime();
    }

    public int getTickMode() {
        return this.m_tickField;
    }

    public void setTime(long time) {
        this.m_cal.setTimeInMillis(time);
        this.adjustTime();
    }

    private void adjustTime() {
        switch (this.m_tickField) {
            case 5: {
                this.m_cal.set(11, 0);
                this.m_cal.set(10, 0);
                this.m_cal.set(12, 0);
                this.m_cal.set(13, 0);
                this.m_cal.set(14, 0);
                break;
            }
            case 11: {
                this.m_cal.set(12, 0);
                this.m_cal.set(13, 0);
                this.m_cal.set(14, 0);
                break;
            }
            case 12: {
                this.m_cal.set(13, 0);
                this.m_cal.set(14, 0);
                break;
            }
            case 13: {
                this.m_cal.set(14, 0);
            }
        }
    }

    public TickSignal waitForNextTick() {
        GregorianCalendar nextCal = new GregorianCalendar();
        nextCal.setTime(this.m_cal.getTime());
        ((Calendar)nextCal).add(this.m_tickField, 1);
        long t = nextCal.getTimeInMillis();
        long dt = t - System.currentTimeMillis();
        while (dt > 0L) {
            try {
                Thread.sleep(Math.min(dt, 15000L));
            }
            catch (InterruptedException interruptedException) {}
            dt = t - System.currentTimeMillis();
        }
        this.m_cal.add(this.m_tickField, 1);
        return this.getCurrentTick();
    }

    public long getTime() {
        return this.m_cal.getTimeInMillis();
    }

    public TickSignal getCurrentTick() {
        return new TickSignal(this.m_cal.get(13), this.m_cal.get(12), this.m_cal.get(11), (7 + this.m_cal.get(7) - 2) % 7 + 1, this.m_cal.get(5), this.m_cal.getActualMaximum(5) - this.m_cal.get(5), this.m_cal.get(6), this.m_cal.get(3), (12 + this.m_cal.get(2) - 0) % 12 + 1, this.m_cal.get(1));
    }
}

