/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.bookmark;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.services.common.bookmark.AbstractBookmarkStorageService;
import org.eclipse.scout.rt.shared.security.PublishUserBookmarkPermission;
import org.eclipse.scout.rt.shared.security.UpdateUserBookmarkPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.shared.services.common.security.ACCESS;
import org.eclipse.scout.service.SERVICES;

@Priority(value=-1.0f)
public class FileSystemBookmarkStorageService
extends AbstractBookmarkStorageService
implements IBookmarkStorageService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(FileSystemBookmarkStorageService.class);
    public static final String GLOBAL_FILE_NAME = "all_users";

    @Override
    public void publishBookmarkData(BookmarkFolder publishFolder, Map<String, Object> targetGroup) throws ProcessingException {
        Object userId2;
        if (!ACCESS.check((Permission)new PublishUserBookmarkPermission())) {
            throw new ProcessingException("Function denied", (Throwable)new SecurityException("Function denied"));
        }
        HashSet<Object> set = new HashSet<Object>();
        Collection userIdList = (Collection)targetGroup.get("userIdList");
        if (userIdList != null) {
            for (Object userId : userIdList) {
                set.add(userId);
            }
        }
        if ((userId2 = targetGroup.get("userId")) != null) {
            set.add(userId2);
        }
        for (Object e : set) {
            this.publishBookmarkDataToUser(publishFolder, e);
        }
    }

    @Override
    protected Object getCurrentUserId() {
        return ServerJob.getCurrentSession().getUserId();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected BookmarkFolder readUserFolder(Object userId) throws ProcessingException {
        BookmarkFolder folder;
        String filename = userId + ".ser";
        RemoteFile spec = new RemoteFile("bookmarks", filename, 0L);
        RemoteFile f = ((IRemoteFileService)SERVICES.getService(IRemoteFileService.class)).getRemoteFile(spec);
        if (!f.exists()) return null;
        ObjectInputStream oin = null;
        byte[] bytes = f.extractData();
        oin = new ObjectInputStream(new ByteArrayInputStream(bytes));
        BookmarkFolder bookmarkFolder = folder = (BookmarkFolder)oin.readObject();
        if (oin == null) return bookmarkFolder;
        try {
            oin.close();
            return bookmarkFolder;
        }
        catch (Throwable throwable) {}
        return bookmarkFolder;
        catch (Throwable t) {
            try {
                LOG.error(null, t);
                if (oin == null) return null;
            }
            catch (Throwable throwable) {
                if (oin == null) throw throwable;
                try {
                    oin.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                oin.close();
                return null;
            }
            catch (Throwable throwable) {}
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected BookmarkFolder readGlobalFolder() throws ProcessingException {
        BookmarkFolder folder;
        String filename = "all_users.ser";
        RemoteFile spec = new RemoteFile("bookmarks", filename, 0L);
        RemoteFile f = ((IRemoteFileService)SERVICES.getService(IRemoteFileService.class)).getRemoteFile(spec);
        if (!f.exists()) return null;
        ObjectInputStream oin = null;
        byte[] bytes = f.extractData();
        oin = new ObjectInputStream(new ByteArrayInputStream(bytes));
        BookmarkFolder bookmarkFolder = folder = (BookmarkFolder)oin.readObject();
        if (oin == null) return bookmarkFolder;
        try {
            oin.close();
            return bookmarkFolder;
        }
        catch (Throwable throwable) {}
        return bookmarkFolder;
        catch (Throwable t) {
            try {
                LOG.error(null, t);
                if (oin == null) return null;
            }
            catch (Throwable throwable) {
                if (oin == null) throw throwable;
                try {
                    oin.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                oin.close();
                return null;
            }
            catch (Throwable throwable) {}
            return null;
        }
    }

    @Override
    protected void writeUserFolder(BookmarkFolder folder, Object userId) throws ProcessingException {
        ObjectOutputStream oout = null;
        try {
            try {
                if (ACCESS.check((Permission)new UpdateUserBookmarkPermission())) {
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    oout = new ObjectOutputStream(b);
                    oout.writeObject(folder);
                    oout.close();
                    oout = null;
                    byte[] bytes = b.toByteArray();
                    String filename = userId + ".ser";
                    RemoteFile spec = new RemoteFile("bookmarks", filename, 0L);
                    spec.readData((InputStream)new ByteArrayInputStream(bytes));
                    ((IRemoteFileService)SERVICES.getService(IRemoteFileService.class)).putRemoteFile(spec);
                }
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ProcessingException("", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (oout != null) {
            try {
                oout.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    protected void writeGlobalFolder(BookmarkFolder folder) throws ProcessingException {
        ObjectOutputStream oout = null;
        try {
            try {
                if (ACCESS.check((Permission)new UpdateUserBookmarkPermission())) {
                    ByteArrayOutputStream b = new ByteArrayOutputStream();
                    oout = new ObjectOutputStream(b);
                    oout.writeObject(folder);
                    oout.close();
                    oout = null;
                    byte[] bytes = b.toByteArray();
                    String filename = "all_users.ser";
                    RemoteFile spec = new RemoteFile("bookmarks", filename, 0L);
                    spec.readData((InputStream)new ByteArrayInputStream(bytes));
                    ((IRemoteFileService)SERVICES.getService(IRemoteFileService.class)).putRemoteFile(spec);
                }
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ProcessingException("", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (oout != null) {
            try {
                oout.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

