/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.builder;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.SQL;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.legacy.LegacyStatementBuilder;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.common.jdbc.TokenBasedSearchFilter;

public class TokenBasedStatementBuilder {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TokenBasedStatementBuilder.class);
    private final ISqlStyle m_sqlStyle;
    private final HashMap<Integer, String> m_tokenMappings = new HashMap();
    private final AtomicLong m_bindSeq = new AtomicLong();
    private final HashMap<String, Object> m_binds = new HashMap();
    private final StringBuffer m_where = new StringBuffer("");
    private TokenBasedStatementBuilder m_staticBuilder;

    public TokenBasedStatementBuilder() {
        this(null);
    }

    public TokenBasedStatementBuilder(ISqlStyle sqlStyle) {
        this.m_sqlStyle = sqlStyle != null ? sqlStyle : SQL.getSqlStyle();
    }

    public void setStaticBuilder(TokenBasedStatementBuilder staticBuilder) {
        this.m_staticBuilder = staticBuilder;
    }

    public TokenBasedStatementBuilder getStaticBuilder() {
        return this.m_staticBuilder;
    }

    public ISqlStyle getSqlStyle() {
        return this.m_sqlStyle;
    }

    public void build(SearchFilter filter) {
        if (!(filter instanceof TokenBasedSearchFilter)) {
            LOG.warn("unexpected filter type", (Throwable)new IllegalArgumentException("expected search filter of type " + TokenBasedSearchFilter.class.getSimpleName()));
            return;
        }
        TokenBasedSearchFilter tokenFilter = (TokenBasedSearchFilter)filter;
        for (TokenBasedSearchFilter.ValueToken t : tokenFilter.getValueTokens()) {
            this.checkValueTypes(t.getValues());
            this.buildToken(t.getTokenId(), t.getValues());
        }
        for (TokenBasedSearchFilter.ValueToken t : tokenFilter.getWildcardStringTokens()) {
            if (t.getValue() == null) continue;
            String s = this.m_sqlStyle.toLikePattern(t.getValue());
            this.buildToken(t.getTokenId(), new Object[]{s});
        }
        for (TokenBasedSearchFilter.AndNodeToken root : tokenFilter.getTreeTokens()) {
            this.buildTree(root);
        }
    }

    public void addTokenMapping(int key, String sql) {
        if (this.m_tokenMappings.put(key, sql) != null) {
            throw new IllegalArgumentException("duplicate token key: " + key);
        }
    }

    public String getTokenMapping(int key) {
        String s = this.m_tokenMappings.get(key);
        if (s != null) {
            return s;
        }
        if (this.m_staticBuilder != null) {
            return this.m_staticBuilder.getTokenMapping(key);
        }
        return null;
    }

    public boolean hasTokenMapping(int key) {
        boolean b = this.m_tokenMappings.containsKey(key);
        if (b) {
            return b;
        }
        if (this.m_staticBuilder != null) {
            return this.m_staticBuilder.hasTokenMapping(key);
        }
        return false;
    }

    public void checkValueTypes(Object[] args) {
        if (args != null) {
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.checkValueType(o);
                ++n2;
            }
        }
    }

    public void checkValueType(Object o) {
        if (o == null) {
            return;
        }
        Class<?> c = o.getClass();
        while (c != null && c.isArray()) {
            c = c.getComponentType();
        }
        if (c == null) {
            return;
        }
        if (c.isPrimitive()) {
            return;
        }
        if (Number.class.isAssignableFrom(c) || String.class.isAssignableFrom(c) || Date.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || Character.class.isAssignableFrom(c) || Byte.class.isAssignableFrom(c)) {
            return;
        }
        throw new IllegalArgumentException("unexpected and therefore illegal parameter type: " + c.getName());
    }

    public void addWhereToken(String sql) {
        if (sql != null) {
            this.m_where.append(" AND ");
            this.addWhere(sql);
        }
    }

    public void addWhereToken(String sql, Object sValue) {
        if (sql != null) {
            String bindName = "__" + this.m_bindSeq.incrementAndGet();
            String sOld = sql;
            sql = sql.replaceAll(":S([^a-zA-Z0-9_])", ":" + bindName + "$1");
            sql = sql.replaceAll(":S$", ":" + bindName);
            sql = sql.replaceAll("#S#", "#" + bindName + "#");
            this.m_where.append(" AND ");
            this.m_where.append(sql);
            if (!sOld.equals(sql)) {
                this.m_binds.put(bindName, sValue);
            }
        }
    }

    public String prepareWhereToken(String sql, Object sValue) {
        if (sql == null) {
            return null;
        }
        String bindName = "__" + this.m_bindSeq.incrementAndGet();
        String oldSql = sql;
        sql = sql.replaceAll(":S([^a-zA-Z0-9_])", ":" + bindName + "$1");
        sql = sql.replaceAll(":S$", ":" + bindName);
        if (!oldSql.equals(sql = sql.replaceAll("#S#", "#" + bindName + "#"))) {
            this.m_binds.put(bindName, sValue);
        }
        return sql;
    }

    public void addWhere(String sql) {
        if (sql != null) {
            this.m_where.append(sql);
        }
    }

    public String getWhere() {
        return this.m_where.toString();
    }

    public Map<String, Object> getBinds() {
        return this.m_binds;
    }

    protected void buildToken(int key, Object[] args) {
        String s = this.getTokenMapping(key);
        if (s == null && !this.hasTokenMapping(key)) {
            LOG.warn("null BsiCrmFieldMapping for key " + key);
        }
        if (s != null && s.length() > 0 && !"1=1".equals(s)) {
            Object sValue = args != null && args.length > 0 ? args[0] : null;
            this.addWhereToken(s, sValue);
        }
    }

    protected void buildTree(TokenBasedSearchFilter.AndNodeToken root) {
        String s = this.buildAndNodes(root.getChildren(), false);
        if (s != null) {
            this.addWhereToken(s);
        }
    }

    protected String buildNode(TokenBasedSearchFilter.TreeNodeToken node) {
        String s = null;
        if (node instanceof TokenBasedSearchFilter.EntityNodeToken) {
            s = this.buildEntityNode((TokenBasedSearchFilter.EntityNodeToken)node);
        } else if (node instanceof TokenBasedSearchFilter.AttributeNodeToken) {
            s = this.buildAttributeNode((TokenBasedSearchFilter.AttributeNodeToken)node);
        } else if (node instanceof TokenBasedSearchFilter.AndNodeToken) {
            s = this.buildAndNodes(node.getChildren(), true);
        } else if (node instanceof TokenBasedSearchFilter.OrNodeToken) {
            s = this.buildOrNodes(node.getChildren(), true);
        }
        if (s == null) {
            return null;
        }
        if (node.isNegative()) {
            return "NOT (" + s + ")";
        }
        return s;
    }

    protected String buildAndNodes(List<TokenBasedSearchFilter.TreeNodeToken> nodes, boolean bracket) {
        StringBuilder buf = new StringBuilder();
        int count = 0;
        for (TokenBasedSearchFilter.TreeNodeToken node : nodes) {
            String s = this.buildNode(node);
            if (s == null) continue;
            if (count > 0) {
                buf.append(" AND ");
            }
            buf.append(s);
            ++count;
        }
        if (count == 0) {
            return null;
        }
        if (bracket) {
            return "(" + buf.toString() + ")";
        }
        return buf.toString();
    }

    protected String buildOrNodes(List<TokenBasedSearchFilter.TreeNodeToken> nodes, boolean bracket) {
        StringBuilder buf = new StringBuilder();
        int count = 0;
        for (TokenBasedSearchFilter.TreeNodeToken node : nodes) {
            String s = this.buildNode(node);
            if (s == null) continue;
            if (count > 0) {
                buf.append(" OR ");
            }
            buf.append(s);
            ++count;
        }
        if (count == 0) {
            return null;
        }
        if (bracket) {
            return "(" + buf.toString() + ")";
        }
        return buf.toString();
    }

    protected String buildEntityNode(TokenBasedSearchFilter.EntityNodeToken eNode) {
        String stm = this.getTokenMapping(eNode.getTokenId());
        if (stm == null) {
            LOG.warn("no token defined for entity " + eNode.getTokenId());
            return null;
        }
        String ch = this.buildAndNodes(eNode.getChildren(), true);
        ch = ch != null ? " AND " + ch : "";
        if (stm.indexOf("<attributes/>") >= 0) {
            stm = StringUtility.replace((String)stm, (String)"<attributes/>", (String)ch);
        } else if (stm.indexOf("#W#") >= 0) {
            stm = StringUtility.replace((String)stm, (String)"#W#", (String)ch);
        } else if (ch.length() > 0) {
            stm = String.valueOf(stm) + ch;
        }
        if (stm.length() > 0) {
            return stm;
        }
        return null;
    }

    protected String buildAttributeNode(final TokenBasedSearchFilter.AttributeNodeToken aNode) {
        String baseStatement = this.getTokenMapping(aNode.getTokenId());
        if (baseStatement == null) {
            LOG.warn("no token defined for attribute " + aNode.getTokenId());
            return null;
        }
        Object[] args = aNode.getValues();
        final Object sValue = args != null && args.length > 0 ? args[0] : null;
        String sql = this.prepareWhereToken(baseStatement, sValue);
        if (!sql.equals(baseStatement)) {
            return sql;
        }
        if (sql.indexOf("<attribute>") < 0) {
            sql = "<attribute>" + sql + "</attribute>";
        }
        StringUtility.ITagProcessor processor = new StringUtility.ITagProcessor(){

            public String processTag(String tagName, String attribute) {
                return TokenBasedStatementBuilder.this.buildAttributeOpValue(attribute, aNode.getOp(), sValue);
            }
        };
        return StringUtility.replaceTags((String)sql, (String)"attribute", (StringUtility.ITagProcessor)processor);
    }

    protected String buildAttributeOpValue(String att, int op, Object value) {
        LegacyStatementBuilder b = new LegacyStatementBuilder(this.getSqlStyle());
        String attOpValue = b.resolveComposerAttribute(op, att, "S", value);
        String sql = this.prepareWhereToken(attOpValue, value);
        return sql;
    }
}

