/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.dict;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.SequenceDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.TableDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.ViewDesc;

public class DataDictionary
implements Serializable {
    private static final long serialVersionUID = -485573072845041815L;
    private transient boolean m_valid = true;
    private int m_sourceType = 100;
    private String m_schema;
    private HashMap<String, TableDesc> m_tables;
    private HashMap<String, ViewDesc> m_views;
    private HashMap<String, SequenceDesc> m_sequences;

    private DataDictionary() {
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public void invalidate() {
        this.m_valid = false;
    }

    public DataDictionary(String schema) {
        this.m_schema = schema.toUpperCase();
        this.m_tables = new HashMap();
        this.m_views = new HashMap();
        this.m_sequences = new HashMap();
    }

    public void setSourceType(int t) {
        this.m_sourceType = t;
    }

    public int getSourceType() {
        return this.m_sourceType;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public List<TableDesc> getTables() {
        return new ArrayList<TableDesc>(this.m_tables.values());
    }

    public void addTable(TableDesc td) {
        this.m_tables.put(td.getName(), td);
    }

    public void removeTable(String name) {
        this.m_tables.remove(name);
    }

    public TableDesc getTable(String name) {
        if (name.startsWith(String.valueOf(this.getSchema()) + ".")) {
            name = name.substring(this.getSchema().length() + 1);
        }
        TableDesc td = this.m_tables.get(name);
        return td;
    }

    public List<ViewDesc> getViews() {
        return new ArrayList<ViewDesc>(this.m_views.values());
    }

    public void addView(ViewDesc vd) {
        this.m_views.put(vd.getName(), vd);
    }

    public ViewDesc getView(String name) {
        return this.m_views.get(name);
    }

    public List<SequenceDesc> getSequences() {
        return new ArrayList<SequenceDesc>(this.m_sequences.values());
    }

    public void addSequence(SequenceDesc sd) {
        this.m_sequences.put(sd.getName(), sd);
    }

    public SequenceDesc getSequence(String name) {
        return this.m_sequences.get(name);
    }

    public String toXml() {
        StringBuffer buf = new StringBuffer();
        buf.append("<datadictionary schema=\"" + this.m_schema + "\">\n");
        buf.append("<tables>\n");
        for (TableDesc td : this.m_tables.values()) {
            buf.append(String.valueOf(td.toXml()) + "\n");
        }
        buf.append("</tables>\n");
        buf.append("<views>\n");
        for (ViewDesc vd : this.m_views.values()) {
            buf.append(String.valueOf(vd.toXml()) + "\n");
        }
        buf.append("</views>\n");
        buf.append("<sequences>\n");
        for (SequenceDesc sd : this.m_sequences.values()) {
            buf.append(String.valueOf(sd.toXml()) + "\n");
        }
        buf.append("</sequences>\n");
        buf.append("</datadictionary>\n");
        return buf.toString();
    }
}

