/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.dict;

import java.io.Serializable;
import java.math.BigDecimal;

public class SequenceDesc
implements Serializable {
    private static final long serialVersionUID = -4529107990427422020L;
    private String m_name;
    private long m_min;
    private long m_max;
    private long m_increment;

    private SequenceDesc() {
    }

    public SequenceDesc(String name, BigDecimal min, BigDecimal max, BigDecimal increment) {
        this.m_name = name;
        this.m_min = this.checkLongRange(min);
        this.m_max = this.checkLongRange(max);
        this.m_increment = this.checkLongRange(increment);
    }

    public SequenceDesc(String name, long min, long max, long increment) {
        this.m_name = name;
        this.m_min = min;
        this.m_max = max;
        this.m_increment = increment;
    }

    public String getName() {
        return this.m_name;
    }

    public long getMin() {
        return this.m_min;
    }

    public long getMax() {
        return this.m_max;
    }

    public long getIncrement() {
        return this.m_increment;
    }

    public String toXml() {
        StringBuffer buf = new StringBuffer();
        buf.append("<sequence");
        buf.append(" name=\"" + this.m_name + "\"");
        if (this.m_min != 0L) {
            buf.append(" min=\"" + this.m_min + "\"");
        }
        if (this.m_max != 0L) {
            buf.append(" max=\"" + this.m_max + "\"");
        }
        if (this.m_increment != 0L) {
            buf.append(" increment=\"" + this.m_increment + "\"");
        }
        buf.append("/>\n");
        return buf.toString();
    }

    private long checkLongRange(BigDecimal d) {
        if (d != null && d.compareTo(BigDecimal.valueOf(0L)) >= 0 && d.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) <= 0) {
            return d.longValue();
        }
        return 0L;
    }
}

