/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.security;

import java.lang.reflect.Modifier;
import java.security.Permission;
import java.util.HashSet;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleClassDescriptor;
import org.eclipse.scout.commons.runtime.BundleBrowser;
import org.eclipse.scout.rt.server.internal.Activator;
import org.eclipse.scout.rt.shared.services.common.security.IPermissionService;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.Bundle;

@Priority(value=-1.0f)
public class PermissionService
extends AbstractService
implements IPermissionService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PermissionService.class);
    private Object m_permissionClassesLock = new Object();
    private BundleClassDescriptor[] m_permissionClasses;

    public BundleClassDescriptor[] getAllPermissionClasses() {
        this.checkCache();
        return this.m_permissionClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCache() {
        Object object = this.m_permissionClassesLock;
        synchronized (object) {
            if (this.m_permissionClasses == null) {
                HashSet<BundleClassDescriptor> discoveredPermissions = new HashSet<BundleClassDescriptor>();
                Bundle[] bundleArray = Activator.getDefault().getBundle().getBundleContext().getBundles();
                int n = bundleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle bundle = bundleArray[n2];
                    String[] classNames = null;
                    try {
                        BundleBrowser bundleBrowser = new BundleBrowser(bundle.getSymbolicName(), bundle.getSymbolicName());
                        classNames = bundleBrowser.getClasses(false, true);
                    }
                    catch (Exception e1) {
                        LOG.warn(null, (Throwable)e1);
                    }
                    if (classNames != null) {
                        String[] stringArray = classNames;
                        int n3 = classNames.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String className = stringArray[n4];
                            if (this.isCandidate(className)) {
                                try {
                                    int flags;
                                    Class c = null;
                                    c = bundle.loadClass(className);
                                    if (Permission.class.isAssignableFrom(c) && !c.isInterface() && Modifier.isPublic(flags = c.getModifiers()) && !Modifier.isAbstract(flags)) {
                                        discoveredPermissions.add(new BundleClassDescriptor(bundle.getSymbolicName(), c.getName()));
                                    }
                                }
                                catch (Throwable throwable) {}
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                this.m_permissionClasses = discoveredPermissions.toArray(new BundleClassDescriptor[discoveredPermissions.size()]);
            }
        }
    }

    protected boolean isCandidate(String className) {
        return className.indexOf("Permission") >= 0 && className.indexOf(".security.") >= 0;
    }
}

