/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.calendar;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.rt.shared.services.common.calendar.AbstractCalendarItem;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarTask;

public class CalendarTask
extends AbstractCalendarItem
implements ICalendarTask,
Serializable {
    private static final long serialVersionUID = 0L;
    private Long m_responsibleId;
    private Date m_start;
    private Date m_due;
    private Date m_complete;

    public CalendarTask() {
    }

    public CalendarTask(long id, Long responsibleId, Date startDate, Date dueDate, Date completeDate, String subject, String body, String color) {
        this.setId(id);
        this.setResponsibleId(id);
        this.setStart(startDate);
        this.setDue(dueDate);
        this.setComplete(completeDate);
        this.setSubject(subject);
        this.setBody(body);
        this.setColor(color);
    }

    public CalendarTask(Object[] data) {
        if (data != null) {
            int i = 0;
            while (i < data.length) {
                if (data[i] != null) {
                    switch (i) {
                        case 0: {
                            this.setId(((Number)data[i]).longValue());
                            break;
                        }
                        case 1: {
                            this.setResponsibleId(((Number)data[i]).longValue());
                            break;
                        }
                        case 2: {
                            this.setStart((Date)data[i]);
                            break;
                        }
                        case 3: {
                            this.setDue((Date)data[i]);
                            break;
                        }
                        case 4: {
                            this.setComplete((Date)data[i]);
                            break;
                        }
                        case 5: {
                            this.setSubject((String)data[i]);
                            break;
                        }
                        case 6: {
                            this.setBody((String)data[i]);
                            break;
                        }
                        case 7: {
                            this.setColor((String)data[i]);
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isIntersecting(Date minDate, Date maxDate) {
        Date d = this.m_due;
        if (d == null) {
            d = this.m_complete;
        }
        return DateUtility.intersects((Date)this.m_start, (Date)d, (Date)minDate, (Date)maxDate);
    }

    @Override
    public Long getResponsibleId() {
        return this.m_responsibleId;
    }

    @Override
    public void setResponsibleId(Long n) {
        this.m_responsibleId = n;
    }

    @Override
    public Date getStart() {
        return this.m_start;
    }

    @Override
    public void setStart(Date a) {
        this.m_start = a;
    }

    @Override
    public Date getDue() {
        return this.m_due;
    }

    @Override
    public void setDue(Date a) {
        this.m_due = a;
    }

    @Override
    public Date getComplete() {
        return this.m_complete;
    }

    @Override
    public void setComplete(Date a) {
        this.m_complete = a;
    }

    @Override
    public ICalendarItem copy() {
        CalendarTask t = (CalendarTask)super.copy();
        t.m_responsibleId = this.m_responsibleId;
        t.m_start = this.m_start;
        t.m_due = this.m_due;
        t.m_complete = this.m_complete;
        return t;
    }

    @Override
    protected void dumpState(Map<String, Object> attributes) {
        super.dumpState(attributes);
        if (this.m_start != null) {
            attributes.put("start", CalendarTask.getDumpDateFormat().format(this.m_start));
        }
        if (this.m_due != null) {
            attributes.put("due", CalendarTask.getDumpDateFormat().format(this.m_due));
        }
        if (this.m_complete != null) {
            attributes.put("complete", CalendarTask.getDumpDateFormat().format(this.m_complete));
        }
    }
}

