/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.services.common.session.ISessionService;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.service.SERVICES;

public final class UserAgentUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(UserAgentUtility.class);

    private UserAgentUtility() {
    }

    public static boolean isMobileDevice() {
        return UiDeviceType.MOBILE.equals(UserAgentUtility.getCurrentUiDeviceType());
    }

    public static boolean isTabletDevice() {
        return UiDeviceType.TABLET.equals(UserAgentUtility.getCurrentUiDeviceType());
    }

    public static boolean isDesktopDevice() {
        return UiDeviceType.DESKTOP.equals(UserAgentUtility.getCurrentUiDeviceType());
    }

    public static boolean isTouchDevice() {
        return UserAgentUtility.getCurrentUiDeviceType().isTouchDevice();
    }

    public static boolean isWebClient() {
        return UserAgentUtility.getCurrentUiLayer().isWebUi();
    }

    public static boolean isRichClient() {
        return !UserAgentUtility.isWebClient();
    }

    public static boolean isSwingUi() {
        return UiLayer.SWING.equals(UserAgentUtility.getCurrentUiLayer());
    }

    public static boolean isSwtUi() {
        return UiLayer.SWT.equals(UserAgentUtility.getCurrentUiLayer());
    }

    public static boolean isRapUi() {
        return UiLayer.RAP.equals(UserAgentUtility.getCurrentUiLayer());
    }

    public static IUiDeviceType getCurrentUiDeviceType() {
        return UserAgentUtility.getCurrentUserAgent().getUiDeviceType();
    }

    public static IUiLayer getCurrentUiLayer() {
        return UserAgentUtility.getCurrentUserAgent().getUiLayer();
    }

    public static UserAgent getCurrentUserAgent() {
        ISessionService service = (ISessionService)SERVICES.getService(ISessionService.class);
        if (service == null) {
            LOG.warn("No session service found! Returning default user agent object.");
            return UserAgent.createDefault();
        }
        ISession session = service.getCurrentSession();
        if (service.getCurrentSession() == null) {
            LOG.warn("No session found! Returning default user agent object.");
            return UserAgent.createDefault();
        }
        return session.getUserAgent();
    }

    public static String getFontSizeUnit() {
        if (UserAgentUtility.isWebClient()) {
            return "px";
        }
        return "pt";
    }
}

