/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.MatrixUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.IntegerHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.code.AbstractCode;
import org.eclipse.scout.rt.shared.services.common.code.CodeRow;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.rt.shared.services.common.code.MutableCode;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractCodeType<T>
implements ICodeType<T>,
Serializable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCodeType.class);
    private static final long serialVersionUID = 1L;
    private String m_text;
    private String m_iconId;
    private boolean m_hierarchy;
    private int m_maxLevel;
    private transient HashMap<Object, ICode> m_rootCodeMap = new HashMap();
    private ArrayList<ICode> m_rootCodeList = new ArrayList();

    public AbstractCodeType() {
        this.initConfig();
    }

    public AbstractCodeType(String label, boolean hierarchy) {
        this.m_text = label;
        this.m_hierarchy = hierarchy;
    }

    private Class<? extends ICode>[] getConfiguredCodes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, ICode.class);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredIsHierarchy() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=30.0)
    @ConfigPropertyValue(value="Integer.MAX_VALUE")
    protected int getConfiguredMaxLevel() {
        return Integer.MAX_VALUE;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=40.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="DOC")
    @Order(value=110.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDoc() {
        return null;
    }

    @ConfigOperation
    @Order(value=1.0)
    protected List<ICode<?>> execCreateCodes() throws ProcessingException {
        Class<ICode>[] a = this.getConfiguredCodes();
        if (a == null || a.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(a.length);
        int i = 0;
        while (i < a.length) {
            try {
                ICode code = (ICode)ConfigurationUtility.newInnerInstance((Object)this, a[i]);
                list.add(code);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
            ++i;
        }
        return list;
    }

    @ConfigOperation
    @Order(value=2.0)
    protected ICode<?> execCreateCode(CodeRow newRow) throws ProcessingException {
        MutableCode code = new MutableCode(newRow);
        return code;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected CodeRow[] execLoadCodes() throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execOverwriteCode(CodeRow oldCode, CodeRow newCode) throws ProcessingException {
        if (newCode.getBackgroundColor() == null) {
            newCode.setBackgroundColor(oldCode.getBackgroundColor());
        }
        if (newCode.getFont() == null) {
            newCode.setFont(oldCode.getFont());
        }
        if (newCode.getForegroundColor() == null) {
            newCode.setForegroundColor(oldCode.getForegroundColor());
        }
        if (newCode.getIconId() == null) {
            newCode.setIconId(oldCode.getIconId());
        }
        if (newCode.getExtKey() == null) {
            newCode.setExtKey(oldCode.getExtKey());
        }
        if (newCode.getValue() == null) {
            newCode.setValue(oldCode.getValue());
        }
    }

    protected void initConfig() {
        this.m_text = this.getConfiguredText();
        this.m_iconId = this.getConfiguredIconId();
        this.m_hierarchy = this.getConfiguredIsHierarchy();
        this.m_maxLevel = this.getConfiguredMaxLevel();
        try {
            this.loadCodes();
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get("CodeTypeInit", new String[0])) + " " + this.m_text);
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    public static void sortData(Object[][] data, int ... sortColumns) {
        MatrixUtility.sort((Object[][])data, (int[])sortColumns);
    }

    public static CodeRow[] createCodeRowArray(Object[][] data) {
        return AbstractCodeType.createCodeRowArray(data, data != null && data.length > 0 ? data[0].length : 0);
    }

    public static CodeRow[] createCodeRowArray(Object[][] data, int maxColumnIndex) {
        if (data == null || data.length == 0) {
            return new CodeRow[0];
        }
        CodeRow[] a = new CodeRow[data.length];
        int i = 0;
        while (i < data.length) {
            a[i] = new CodeRow(data[i], maxColumnIndex);
            ++i;
        }
        return a;
    }

    @Override
    public abstract T getId();

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public boolean isHierarchy() {
        return this.m_hierarchy;
    }

    @Override
    public int getMaxLevel() {
        return this.m_maxLevel;
    }

    @Override
    public ICode getCode(Object id) {
        ICode c = this.m_rootCodeMap.get(id);
        if (c == null) {
            for (ICode childCode : this.m_rootCodeList) {
                c = childCode.getChildCode(id);
                if (c == null) continue;
                return c;
            }
        }
        return c;
    }

    @Override
    public ICode getCodeByExtKey(Object extKey) {
        ICode c = null;
        for (ICode childCode : this.m_rootCodeList) {
            c = extKey.equals(childCode.getExtKey()) ? childCode : childCode.getChildCodeByExtKey(extKey);
            if (c == null) continue;
            return c;
        }
        return c;
    }

    @Override
    public int getCodeIndex(final Object id) {
        final IntegerHolder result = new IntegerHolder(Integer.valueOf(-1));
        ICodeVisitor v = new ICodeVisitor(){
            private int index = 0;

            @Override
            public boolean visit(ICode code, int treeLevel) {
                if (CompareUtility.equals(code.getId(), (Object)id)) {
                    result.setValue((Object)this.index);
                } else {
                    ++this.index;
                }
                return (Integer)result.getValue() < 0;
            }
        };
        this.visit(v, false);
        return (Integer)result.getValue();
    }

    @Override
    public int getCodeIndex(final ICode c) {
        final IntegerHolder result = new IntegerHolder(Integer.valueOf(-1));
        ICodeVisitor v = new ICodeVisitor(){
            private int index = 0;

            @Override
            public boolean visit(ICode code, int treeLevel) {
                if (code == c) {
                    result.setValue((Object)this.index);
                } else {
                    ++this.index;
                }
                return (Integer)result.getValue() < 0;
            }
        };
        this.visit(v, false);
        return (Integer)result.getValue();
    }

    @Override
    public ICode[] getCodes() {
        return this.getCodes(true);
    }

    @Override
    public ICode[] getCodes(boolean activeOnly) {
        ArrayList<ICode> list = new ArrayList<ICode>(this.m_rootCodeList);
        if (activeOnly) {
            Iterator<ICode> it = list.iterator();
            while (it.hasNext()) {
                ICode code = it.next();
                if (code.isActive()) continue;
                it.remove();
            }
        }
        return list.toArray(new ICode[0]);
    }

    private void loadCodes() throws ProcessingException {
        CodeRow[] result;
        this.m_rootCodeMap = new HashMap();
        this.m_rootCodeList = new ArrayList();
        ArrayList<ICode> allCodesOrdered = new ArrayList<ICode>();
        HashMap codeToParentCodeMap = new HashMap();
        HashMap idToCodeMap = new HashMap();
        List<ICode<?>> createdList = this.execCreateCodes();
        if (createdList != null) {
            for (ICode<?> code : createdList) {
                allCodesOrdered.add(code);
                idToCodeMap.put(code.getId(), code);
                codeToParentCodeMap.put(code, null);
            }
        }
        if ((result = this.execLoadCodes()) != null && result.length > 0) {
            HashMap codeToParentIdMap = new HashMap();
            int i = 0;
            while (i < result.length) {
                ICode<?> newCode;
                CodeRow newRow = result[i];
                ICode existingCode = (ICode)idToCodeMap.get(newRow.getKey());
                if (existingCode != null) {
                    this.execOverwriteCode(existingCode.toCodeRow(), newRow);
                }
                if ((newCode = this.execCreateCode(newRow)) != null) {
                    if (existingCode != null) {
                        allCodesOrdered.remove(existingCode);
                        idToCodeMap.remove(existingCode.getId());
                        codeToParentCodeMap.remove(existingCode);
                    }
                    allCodesOrdered.add(newCode);
                    idToCodeMap.put(newCode.getId(), newCode);
                    Object parentId = newRow.getParentKey();
                    codeToParentIdMap.put(newCode, parentId);
                } else if (existingCode != null) {
                    allCodesOrdered.remove(existingCode);
                    allCodesOrdered.add(existingCode);
                }
                ++i;
            }
            for (Map.Entry e : codeToParentIdMap.entrySet()) {
                AbstractCode code = (AbstractCode)e.getKey();
                Object parentId = e.getValue();
                AbstractCode parentCode = null;
                if (parentId != null && (parentCode = (AbstractCode)idToCodeMap.get(parentId)) == null) {
                    LOG.warn("parent code for " + code + " not found: id=" + parentId);
                }
                codeToParentCodeMap.put(code, parentCode);
            }
        }
        for (ICode code : allCodesOrdered) {
            ICode parentCode = (ICode)codeToParentCodeMap.get(code);
            if (parentCode != null) {
                parentCode.addChildCodeInternal(code);
                continue;
            }
            this.addChildCodeInternal(code);
        }
        this.visit(new ICodeVisitor(){

            @Override
            public boolean visit(ICode code, int treeLevel) {
                if (code.getParentCode() != null && !code.getParentCode().isActive() && code.isActive() && code instanceof AbstractCode) {
                    ((AbstractCode)code).setActiveInternal(false);
                }
                return true;
            }
        }, false);
    }

    private void addChildCodeInternal(ICode code) {
        code.setCodeTypeInternal(this);
        code.setParentCodeInternal(null);
        this.m_rootCodeMap.put(code.getId(), code);
        this.m_rootCodeList.add(code);
    }

    public String toString() {
        return "CodeType[id=" + this.getId() + ", label=" + this.getText() + "]";
    }

    @Override
    public boolean visit(ICodeVisitor visitor) {
        return this.visit(visitor, true);
    }

    @Override
    public boolean visit(ICodeVisitor visitor, boolean activeOnly) {
        ICode[] a = this.getCodes(activeOnly);
        int i = 0;
        while (i < a.length) {
            ICode code = a[i];
            if (!visitor.visit(code, 0)) {
                return false;
            }
            if (!code.visit(visitor, 1, activeOnly)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.m_rootCodeMap = new HashMap();
        if (this.m_rootCodeList == null) {
            this.m_rootCodeList = new ArrayList();
        } else {
            for (ICode code : this.m_rootCodeList) {
                this.m_rootCodeMap.put(code.getId(), code);
                code.setParentCodeInternal(null);
                code.setCodeTypeInternal(this);
            }
        }
        return this;
    }
}

