/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.IRwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class RwtScoutComposite<T extends IPropertyObserver>
implements IRwtScoutComposite<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutComposite.class);
    protected static final String CLIENT_PROP_INITIAL_OPAQUE = "scoutInitialOpaque";
    protected static final String CLIENT_PROP_INITIAL_FONT = "scoutInitialFont";
    protected static final String CLIENT_PROP_INITIAL_BACKGROUND = "scoutInitialBackground";
    protected static final String CLIENT_PROP_INITIAL_FOREGROUND = "scoutInitialForeground";
    private Composite m_uiContainer;
    private Control m_uiField;
    private final OptimisticLock m_updateUiFromScoutLock = new OptimisticLock();
    private final Set<String> m_ignoredScoutEvents = new HashSet<String>();
    private T m_scoutObject;
    private P_ScoutPropertyChangeListener m_scoutPropertyListener;
    private IRwtEnvironment m_uiEnvironment;
    private boolean m_created;

    public static void registerCompositeOnWidget(Widget comp, IRwtScoutComposite ui) {
        if (comp != null) {
            comp.setData("IRwtScoutComposite", new WeakReference<IRwtScoutComposite>(ui));
        }
    }

    public static IRwtScoutComposite getCompositeOnWidget(Widget comp) {
        if (comp instanceof Widget) {
            WeakReference ref = (WeakReference)comp.getData("IRwtScoutComposite");
            return ref != null ? (IRwtScoutComposite)ref.get() : null;
        }
        return null;
    }

    public static IPropertyObserver getScoutModelOnWidget(Widget comp) {
        IRwtScoutComposite ui = RwtScoutComposite.getCompositeOnWidget(comp);
        if (ui != null) {
            return ui.getScoutObject();
        }
        return null;
    }

    public OptimisticLock getUpdateUiFromScoutLock() {
        return this.m_updateUiFromScoutLock;
    }

    public void addIgnoredScoutEvent(Class eventType, String name) {
        this.m_ignoredScoutEvents.add(String.valueOf(eventType.getSimpleName()) + ":" + name);
    }

    public void removeIgnoredScoutEvent(Class eventType, String name) {
        this.m_ignoredScoutEvents.remove(String.valueOf(eventType.getSimpleName()) + ":" + name);
    }

    public boolean isIgnoredScoutEvent(Class eventType, String name) {
        if (this.m_ignoredScoutEvents.isEmpty()) {
            return false;
        }
        boolean b = this.m_ignoredScoutEvents.contains(String.valueOf(eventType.getSimpleName()) + ":" + name);
        return b;
    }

    @Override
    public final void createUiField(Composite parent, T scoutObject, IRwtEnvironment uiEnvironment) {
        if (this.m_created) {
            return;
        }
        this.m_scoutObject = scoutObject;
        this.m_uiEnvironment = uiEnvironment;
        try {
            try {
                this.initializeUi(parent);
                if (this.getUiContainer() != null && RwtScoutComposite.getCompositeOnWidget((Widget)this.getUiContainer()) == null) {
                    RwtScoutComposite.registerCompositeOnWidget((Widget)this.getUiContainer(), this);
                }
                if (this.getUiField() != null && RwtScoutComposite.getCompositeOnWidget((Widget)this.getUiField()) == null) {
                    RwtScoutComposite.registerCompositeOnWidget((Widget)this.getUiField(), this);
                }
                try {
                    this.getUpdateUiFromScoutLock().acquire();
                    this.attachScout();
                }
                finally {
                    this.getUpdateUiFromScoutLock().release();
                }
            }
            catch (Exception e) {
                LOG.error("could not initialize component '" + this.getScoutObject().getClass().getName() + "' to '" + this.getClass().getName() + "'.", (Throwable)e);
                this.m_created = true;
            }
        }
        finally {
            this.m_created = true;
        }
    }

    @Override
    public boolean isCreated() {
        return this.m_created;
    }

    @Override
    public Composite getUiContainer() {
        return this.m_uiContainer;
    }

    protected void setUiContainer(Composite uiContainer) {
        this.m_uiContainer = uiContainer;
        if (this.m_uiContainer != null) {
            P_RwtContainerListener listener = new P_RwtContainerListener();
            this.m_uiContainer.addListener(12, (Listener)listener);
        }
    }

    protected void initializeUi(Composite parent) {
    }

    @Override
    public Control getUiField() {
        return this.m_uiField;
    }

    protected void setUiField(Control uiField) {
        this.m_uiField = uiField;
        if (this.m_uiField != null) {
            if (this.getScoutObject() instanceof IFormField && this.m_uiField.getLayoutData() == null) {
                this.m_uiField.setLayoutData((Object)LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
            }
            IRwtKeyStroke[] iRwtKeyStrokeArray = this.getUiKeyStrokes();
            int n = iRwtKeyStrokeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRwtKeyStroke stroke = iRwtKeyStrokeArray[n2];
                this.getUiEnvironment().addKeyStroke(uiField, stroke, true);
                ++n2;
            }
            P_RwtFieldListener listener = new P_RwtFieldListener();
            this.m_uiField.addListener(15, (Listener)listener);
            this.m_uiField.addListener(16, (Listener)listener);
            this.m_uiField.addListener(31, (Listener)listener);
            this.m_uiField.addListener(25, (Listener)listener);
            this.m_uiField.addListener(12, (Listener)listener);
        }
    }

    @Override
    public boolean isUiDisposed() {
        if (this.getUiContainer() == null) {
            return this.getUiField() == null || this.getUiField().isDisposed();
        }
        return this.getUiContainer().isDisposed();
    }

    protected IRwtKeyStroke[] getUiKeyStrokes() {
        return new IRwtKeyStroke[]{new RwtKeyStroke(13){

            @Override
            public void handleUiAction(Event e) {
                RwtScoutComposite.this.handleUiInputVerifier(e.doit);
            }
        }};
    }

    @Override
    public T getScoutObject() {
        return this.m_scoutObject;
    }

    @Override
    public final void dispose() {
        if (!this.m_created) {
            return;
        }
        if (this.getUiField() != null && !this.getUiField().isDisposed()) {
            this.getUiField().dispose();
        }
        if (this.getUiContainer() != null && !this.getUiContainer().isDisposed()) {
            this.getUiContainer().dispose();
        }
        this.disposeImpl();
    }

    protected void disposeImpl() {
    }

    protected void attachScout() {
        if (this.m_scoutObject != null) {
            if (this.m_uiContainer != null) {
                this.m_uiContainer.setData("org.eclipse.scout.rt.object", this.m_scoutObject);
            }
            if (this.m_scoutPropertyListener == null) {
                this.m_scoutPropertyListener = new P_ScoutPropertyChangeListener();
                this.m_scoutObject.addPropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
            }
        }
    }

    protected void detachScout() {
        if (this.m_scoutObject != null && this.m_scoutPropertyListener != null) {
            this.m_scoutObject.removePropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
            this.m_scoutPropertyListener = null;
        }
    }

    protected boolean isHandleScoutPropertyChange(String name, Object newValue) {
        return true;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
    }

    protected void handleUiFocusGained() {
    }

    protected void handleUiFocusLost() {
    }

    protected void handleUiInputVerifier(boolean doit) {
    }

    protected void handleUiDispose() {
        if (!this.m_created) {
            return;
        }
        try {
            this.getUpdateUiFromScoutLock().acquire();
            this.getUiEnvironment().removeKeyStrokes(this.getUiField());
            this.getUiEnvironment().removeKeyStrokes((Control)this.getUiContainer());
            this.detachScout();
        }
        finally {
            this.m_created = false;
            this.getUpdateUiFromScoutLock().release();
        }
    }

    @Override
    public IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    protected void debugHandlePropertyChanged(PropertyChangeEvent e) {
    }

    private class P_RwtContainerListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_RwtContainerListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 12: {
                    RwtScoutComposite.this.handleUiDispose();
                }
            }
        }
    }

    private class P_RwtFieldListener
    implements Listener {
        private static final long serialVersionUID = 1L;
        private long m_timestamp;

        private P_RwtFieldListener() {
        }

        public void handleEvent(Event event) {
            if (!event.doit) {
                return;
            }
            switch (event.type) {
                case 25: {
                    if (!event.text.equals("\t")) break;
                    event.doit = false;
                    break;
                }
                case 31: {
                    switch (event.keyCode) {
                        case 13: 
                        case 27: 
                        case 0x1000001: 
                        case 0x1000002: 
                        case 0x1000003: 
                        case 0x1000004: 
                        case 0x1000005: 
                        case 0x1000006: 
                        case 0x1000007: 
                        case 0x1000008: {
                            return;
                        }
                    }
                    this.m_timestamp = event.time;
                    RwtScoutComposite.this.handleUiInputVerifier(event.doit);
                    break;
                }
                case 15: {
                    RwtScoutComposite.this.handleUiFocusGained();
                    break;
                }
                case 16: {
                    if (RwtScoutComposite.this.getUiField() != null && RwtScoutComposite.this.getUiField().getDisplay().getActiveShell() != null && RwtScoutComposite.this.getUiField().getShell() != RwtScoutComposite.this.getUiField().getDisplay().getActiveShell()) {
                        return;
                    }
                    RwtScoutComposite.this.handleUiInputVerifier(true);
                    RwtScoutComposite.this.handleUiFocusLost();
                    break;
                }
                case 12: {
                    if (RwtScoutComposite.this.m_uiContainer != null) break;
                    RwtScoutComposite.this.handleUiDispose();
                    break;
                }
            }
        }
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            RwtScoutComposite.this.debugHandlePropertyChanged(e);
            if (RwtScoutComposite.this.isIgnoredScoutEvent(PropertyChangeEvent.class, e.getPropertyName())) {
                return;
            }
            if (RwtScoutComposite.this.isHandleScoutPropertyChange(e.getPropertyName(), e.getNewValue()) && RwtScoutComposite.this.getUiEnvironment().getDisplay() != null && !RwtScoutComposite.this.getUiEnvironment().getDisplay().isDisposed()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (!RwtScoutComposite.this.isUiDisposed()) {
                            try {
                                RwtScoutComposite.this.getUpdateUiFromScoutLock().acquire();
                                RwtScoutComposite.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                            }
                            finally {
                                RwtScoutComposite.this.getUpdateUiFromScoutLock().release();
                            }
                        }
                    }
                };
                RwtScoutComposite.this.getUiEnvironment().invokeUiLater(t);
            }
        }
    }
}

