/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.rap.ext.table.TableEx;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractTableKeyboardNavigationSupport {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTableKeyboardNavigationSupport.class);
    private final long m_delay;
    private long m_timeoutTimestamp;
    private String m_filterText = "";
    private Object navigationLock = new Object();
    private P_NavigationJob m_navigationJob;
    private final TableEx m_uiTable;
    private Listener m_uiTableListener;
    private int m_contextColumnIndex;
    private DisposeListener m_disposeListener = new DisposeListener(){
        private static final long serialVersionUID = 1L;

        public void widgetDisposed(DisposeEvent e) {
            AbstractTableKeyboardNavigationSupport.this.detachListeners();
        }
    };

    public AbstractTableKeyboardNavigationSupport(TableEx uiTable) {
        this(uiTable, 500L);
    }

    public AbstractTableKeyboardNavigationSupport(TableEx uiTable, long delay) {
        this.m_delay = delay;
        this.m_navigationJob = new P_NavigationJob();
        this.m_uiTable = uiTable;
        this.attachListeners();
    }

    public void dispose() {
        this.detachListeners();
    }

    public void resetContextColumnIndex() {
        this.m_contextColumnIndex = -1;
    }

    private void attachListeners() {
        if (this.m_uiTableListener == null) {
            this.m_uiTableListener = new P_TableListener();
            this.m_uiTable.addListener(3, this.m_uiTableListener);
        }
        this.m_uiTable.addDisposeListener(this.m_disposeListener);
    }

    private void detachListeners() {
        if (this.m_uiTableListener != null) {
            if (!this.m_uiTable.isDisposed()) {
                this.m_uiTable.removeListener(3, this.m_uiTableListener);
            }
            this.m_uiTableListener = null;
        }
        if (!this.m_uiTable.isDisposed()) {
            this.m_uiTable.removeDisposeListener(this.m_disposeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChar(char c) {
        Object object = this.navigationLock;
        synchronized (object) {
            if (Character.isLetter(c)) {
                if (System.currentTimeMillis() > this.m_timeoutTimestamp) {
                    this.m_filterText = "";
                }
                String newText = "" + Character.toLowerCase(c);
                this.m_filterText = String.valueOf(this.m_filterText) + newText;
                if (this.m_navigationJob != null) {
                    this.m_navigationJob.cancel();
                } else {
                    this.m_navigationJob = new P_NavigationJob();
                }
                UICallBack.activate((String)(String.valueOf(((Object)((Object)this.m_uiTable)).getClass().getName()) + ((Object)((Object)this.m_uiTable)).hashCode()));
                this.m_navigationJob.schedule(300L);
                this.m_timeoutTimestamp = System.currentTimeMillis() + this.m_delay;
            }
        }
    }

    void handleSearchPattern(final String regex) {
        this.m_uiTable.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int column = AbstractTableKeyboardNavigationSupport.this.m_contextColumnIndex;
                if (column < 0) {
                    int i = 0;
                    while (i < AbstractTableKeyboardNavigationSupport.this.m_uiTable.getColumnCount()) {
                        if (AbstractTableKeyboardNavigationSupport.this.m_uiTable.getSortColumn() == AbstractTableKeyboardNavigationSupport.this.m_uiTable.getColumn(i)) {
                            column = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (column < 0 && AbstractTableKeyboardNavigationSupport.this.m_uiTable.getColumnCount() > 0) {
                    column = 0;
                }
                if (column < 0) {
                    return;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("finding regex:" + regex + " in column " + AbstractTableKeyboardNavigationSupport.this.m_uiTable.getColumn(column).getText());
                }
                int startIndex = 0;
                startIndex = AbstractTableKeyboardNavigationSupport.this.m_uiTable.getSelectionIndex() < 0 ? 0 : AbstractTableKeyboardNavigationSupport.this.m_uiTable.getSelectionIndex() + 1;
                int itemCount = AbstractTableKeyboardNavigationSupport.this.m_uiTable.getItemCount();
                int i = 0;
                while (i < itemCount) {
                    TableItem tableItem = AbstractTableKeyboardNavigationSupport.this.m_uiTable.getItem((startIndex + i) % itemCount);
                    String itemText = tableItem.getText(column);
                    if (itemText != null && itemText.toLowerCase().matches(regex)) {
                        AbstractTableKeyboardNavigationSupport.this.handleKeyboardNavigation(tableItem);
                        break;
                    }
                    ++i;
                }
                UICallBack.deactivate((String)(String.valueOf(((Object)((Object)AbstractTableKeyboardNavigationSupport.this.m_uiTable)).getClass().getName()) + ((Object)((Object)AbstractTableKeyboardNavigationSupport.this.m_uiTable)).hashCode()));
            }
        });
    }

    public abstract void handleKeyboardNavigation(TableItem var1);

    private class P_NavigationJob
    extends Job {
        public P_NavigationJob() {
            super("");
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            String pattern;
            Object object = AbstractTableKeyboardNavigationSupport.this.navigationLock;
            synchronized (object) {
                if (monitor.isCanceled() || StringUtility.isNullOrEmpty((String)AbstractTableKeyboardNavigationSupport.this.m_filterText)) {
                    return Status.CANCEL_STATUS;
                }
                pattern = StringUtility.toRegExPattern((String)AbstractTableKeyboardNavigationSupport.this.m_filterText.toLowerCase());
                pattern = String.valueOf(pattern) + ".*";
            }
            AbstractTableKeyboardNavigationSupport.this.handleSearchPattern(pattern);
            return Status.OK_STATUS;
        }
    }

    private class P_TableListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_TableListener() {
        }

        public void handleEvent(Event event) {
            if (event.doit) {
                block0 : switch (event.type) {
                    case 3: {
                        Point p = new Point(event.x, event.y);
                        TableItem item = AbstractTableKeyboardNavigationSupport.this.m_uiTable.getItem(p);
                        if (item == null) break;
                        int i = 0;
                        while (i < AbstractTableKeyboardNavigationSupport.this.m_uiTable.getColumnCount()) {
                            Rectangle rect = item.getBounds(i);
                            if (rect.contains(p)) {
                                AbstractTableKeyboardNavigationSupport.this.m_contextColumnIndex = i;
                                break block0;
                            }
                            ++i;
                        }
                        break;
                    }
                }
            }
        }
    }
}

