/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table;

import java.util.HashMap;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.ui.rap.basic.table.IRwtScoutTableModelForPatch;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTable;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTableEvent;
import org.eclipse.scout.rt.ui.rap.basic.table.TableColumnManager;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.util.HtmlTextUtility;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class RwtScoutTableModel
implements IRwtScoutTableModelForPatch {
    private static final long serialVersionUID = 1L;
    private transient ListenerList listenerList = null;
    private final ITable m_scoutTable;
    private HashMap<ITableRow, HashMap<IColumn<?>, ICell>> m_cachedCells;
    private final RwtScoutTable m_uiTable;
    private final TableColumnManager m_columnManager;
    private Image m_imgCheckboxFalse;
    private Image m_imgCheckboxTrue;
    private Color m_disabledForegroundColor;
    private boolean m_multiline;

    public RwtScoutTableModel(ITable scoutTable, RwtScoutTable uiTable, TableColumnManager columnManager) {
        this.m_scoutTable = scoutTable;
        this.m_uiTable = uiTable;
        this.m_columnManager = columnManager;
        this.m_imgCheckboxTrue = this.m_uiTable.getUiEnvironment().getIcon("checkbox_yes");
        this.m_imgCheckboxFalse = this.m_uiTable.getUiEnvironment().getIcon("checkbox_no");
        this.m_disabledForegroundColor = this.m_uiTable.getUiEnvironment().getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
        this.rebuildCache();
    }

    @Override
    public void setMultiline(boolean multiline) {
        this.m_multiline = multiline;
    }

    @Override
    public boolean isMultiline() {
        return this.m_multiline;
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_scoutTable != null) {
            return this.m_scoutTable.getFilteredRows();
        }
        return new Object[0];
    }

    public Color getBackground(Object element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.m_uiTable.getUiEnvironment().getColor(cell.getBackgroundColor());
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (columnIndex > 0) {
            ITableRow scoutRow = (ITableRow)element;
            ICell cell = this.getCell(element, columnIndex);
            if (cell != null) {
                Color col = this.m_uiTable.getUiEnvironment().getColor(cell.getForegroundColor());
                if (!(col != null || scoutRow.isEnabled() && cell.isEnabled())) {
                    col = this.m_disabledForegroundColor;
                }
                return col;
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        int[] columnOrder = this.m_uiTable.getUiField().getColumnOrder();
        if (columnOrder.length <= 1) {
            return null;
        }
        IColumn<?> col = this.m_columnManager.getColumnByModelIndex(columnIndex - 1);
        ICell cell = this.getCell(element, columnIndex);
        Image checkBoxImage = null;
        if (columnOrder[1] == columnIndex && this.m_uiTable.getScoutObject() != null && ((ITable)this.m_uiTable.getScoutObject()).isCheckable()) {
            checkBoxImage = ((ITableRow)element).isChecked() ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
        } else if (!(col == null || cell == null || col.getDataType() != Boolean.class || col instanceof ISmartColumn && ((ISmartColumn)col).getLookupCall() != null)) {
            Boolean b = (Boolean)cell.getValue();
            checkBoxImage = b != null && b != false ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
        }
        String iconId = null;
        if (cell != null && cell.getIconId() != null) {
            iconId = cell.getIconId();
        } else if (columnOrder[1] == columnIndex) {
            ITableRow row = (ITableRow)element;
            iconId = row.getIconId();
        }
        Image decoImage = this.m_uiTable.getUiEnvironment().getIcon(iconId);
        if (checkBoxImage != null && decoImage != null) {
            return checkBoxImage;
        }
        if (checkBoxImage != null) {
            return checkBoxImage;
        }
        if (decoImage != null) {
            return decoImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            String text = cell.getText();
            if (text == null) {
                text = "";
            }
            if (HtmlTextUtility.isTextWithHtmlMarkup(text)) {
                text = this.m_uiTable.getUiEnvironment().adaptHtmlCell(this.m_uiTable, text);
                text = this.m_uiTable.getUiEnvironment().convertLinksWithLocalUrlsInHtmlCell(this.m_uiTable, text);
            } else if (text.indexOf("\n") >= 0) {
                if (this.isMultiline()) {
                    text = "<html>" + HtmlTextUtility.transformPlainTextToHtml(text) + "</html>";
                    text = this.m_uiTable.getUiEnvironment().adaptHtmlCell(this.m_uiTable, text);
                } else {
                    text = StringUtility.replace((String)text, (String)"\n", (String)" ");
                }
            }
            return text;
        }
        return "";
    }

    public Font getFont(Object element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.m_uiTable.getUiEnvironment().getFont(cell.getFont(), this.m_uiTable.getUiField().getFont());
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)listener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    private Object[] getListeners() {
        ListenerList list = this.listenerList;
        if (list == null) {
            return new Object[0];
        }
        return list.getListeners();
    }

    public void dispose() {
        if (this.listenerList != null) {
            this.listenerList.clear();
        }
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){
                private static final long serialVersionUID = 1L;

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public void consumeTableModelEvent(RwtScoutTableEvent uiTableEvent) {
        this.rebuildCache();
    }

    protected ICell getCell(Object row, int colIndex) {
        IColumn<?> column = this.m_columnManager.getColumnByModelIndex(colIndex - 1);
        if (column != null) {
            if (this.m_cachedCells.get(row) == null) {
                this.rebuildCache();
            }
            return this.m_cachedCells.get(row).get(column);
        }
        return null;
    }

    private void rebuildCache() {
        this.m_cachedCells = new HashMap();
        if (this.m_scoutTable != null) {
            ITableRow[] iTableRowArray = this.m_scoutTable.getRows();
            int n = iTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITableRow scoutRow = iTableRowArray[n2];
                HashMap<IColumn, ICell> cells = new HashMap<IColumn, ICell>();
                IColumn[] iColumnArray = this.m_scoutTable.getColumnSet().getVisibleColumns();
                int n3 = iColumnArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IColumn col = iColumnArray[n4];
                    cells.put(col, this.m_scoutTable.getCell(scoutRow, col));
                    ++n4;
                }
                this.m_cachedCells.put(scoutRow, cells);
                ++n2;
            }
        }
    }

    @Override
    public RwtScoutTable getRwtScoutTable() {
        return this.m_uiTable;
    }
}

