/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.extension;

import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.rap.extension.ILookAndFeelDecorations;
import org.eclipse.scout.rt.ui.rap.extension.ILookAndFeelProperties;
import org.eclipse.scout.rt.ui.rap.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.rap.extension.internal.LookAndFeelDecorations;
import org.eclipse.scout.rt.ui.rap.extension.internal.LookAndFeelProperties;
import org.eclipse.scout.rt.ui.rap.extension.internal.UiDecoration;

public final class UiDecorationExtensionPoint {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(UiDecorationExtensionPoint.class);
    private static final UiDecoration LOOK_AND_FEEL = new UiDecoration();
    public static final int SCOPE_DEFAULT = 1;
    public static final int SCOPE_GLOBAL = 2;

    static {
        ArrayList<ILookAndFeelProperties> propertyExtensions = new ArrayList<ILookAndFeelProperties>();
        ArrayList<ILookAndFeelDecorations> decorationExtensions = new ArrayList<ILookAndFeelDecorations>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.rt.ui.rap", "lookAndFeel");
        IExtension[] extensions = xp.getExtensions();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("properties".equals(element.getName())) {
                    propertyExtensions.add(UiDecorationExtensionPoint.parseProperties(element));
                } else if ("decorations".equals(element.getName())) {
                    decorationExtensions.add(UiDecorationExtensionPoint.parseDecorations(element));
                }
                ++n4;
            }
            ++n2;
        }
        TreeMap<Integer, ILookAndFeelDecorations> decorations = new TreeMap<Integer, ILookAndFeelDecorations>();
        for (ILookAndFeelDecorations dec : decorationExtensions) {
            int scope = dec.getScope();
            if (decorations.get(scope) != null) {
                LOG.warn("multiple look and feel extension found with scope '" + scope + "'");
                continue;
            }
            decorations.put(scope, dec);
        }
        if (decorations.size() > 0) {
            ILookAndFeelDecorations dec = (ILookAndFeelDecorations)decorations.get(decorations.lastKey());
            if (dec.getMandatoryFieldBackgroundColor() != null) {
                LOOK_AND_FEEL.setMandatoryFieldBackgroundColor(dec.getMandatoryFieldBackgroundColor());
            }
            if (dec.getMandatoryLabelFont() != null) {
                LOOK_AND_FEEL.setMandatoryLabelFont(dec.getMandatoryLabelFont());
            }
            if (dec.getMandatoryLabelTextColor() != null) {
                LOOK_AND_FEEL.setMandatoryLabelTextColor(dec.getMandatoryLabelTextColor());
            }
            if (dec.getStarMarkerPosition() != 0) {
                LOOK_AND_FEEL.setMandatoryStarMarkerPosition(dec.getStarMarkerPosition());
            }
        }
        TreeMap<Integer, ILookAndFeelProperties> properties = new TreeMap<Integer, ILookAndFeelProperties>();
        for (ILookAndFeelProperties props : propertyExtensions) {
            int scope = props.getScope();
            if (properties.get(scope) != null) {
                LOG.warn("multiple look and feel extension found with scope '" + scope + "'");
                continue;
            }
            properties.put(scope, props);
        }
        for (ILookAndFeelProperties props : properties.values()) {
            if (props.getPropertyInt("dialog.minHeight") != 0) {
                LOOK_AND_FEEL.setDialogMinHeight(props.getPropertyInt("dialog.minHeight"));
            }
            if (props.getPropertyInt("dialog.minWidth") != 0) {
                LOOK_AND_FEEL.setDialogMinWidth(props.getPropertyInt("dialog.minWidth"));
            }
            if (props.existsProperty("formMainBoxBorder.visible")) {
                LOOK_AND_FEEL.setFormMainBoxBorderVisible(props.getPropertyBool("formMainBoxBorder.visible"));
            }
            if (props.getPropertyInt("formfield.activationButton.height") != 0) {
                LOOK_AND_FEEL.setFormFieldActivationButtonHeight(props.getPropertyInt("formfield.activationButton.height"));
            }
            if (props.getPropertyInt("formfield.activationButton.width") != 0) {
                LOOK_AND_FEEL.setFormFieldActivationButtonWidth(props.getPropertyInt("formfield.activationButton.width"));
            }
            if (props.getPropertyInt("formfield.activationButtonWithMenu.width") != 0) {
                LOOK_AND_FEEL.setFormFieldActivationButtonWithMenuWidth(props.getPropertyInt("formfield.activationButtonWithMenu.width"));
            }
            if (props.getPropertyInt("formFieldLabel.width") != 0) {
                LOOK_AND_FEEL.setFormFieldLabelWidth(props.getPropertyInt("formFieldLabel.width"));
            }
            if (props.getPropertyString("formFieldLabel.alignment") != null) {
                String extFormFieldAlignment = props.getPropertyString("formFieldLabel.alignment");
                if ("center".equalsIgnoreCase(extFormFieldAlignment)) {
                    LOOK_AND_FEEL.setFormFieldLabelAlignment(0x1000000);
                } else if ("left".equalsIgnoreCase(extFormFieldAlignment)) {
                    LOOK_AND_FEEL.setFormFieldLabelAlignment(16384);
                } else if ("right".equalsIgnoreCase(extFormFieldAlignment)) {
                    LOOK_AND_FEEL.setFormFieldLabelAlignment(131072);
                } else {
                    LOG.warn("the value '" + extFormFieldAlignment + "' is not valid for the property '" + "formFieldLabel.alignment" + "'. Expected values are[right,left,center]");
                }
            }
            if (props.getPropertyInt("logicalGridLayout.defaultColumnWidth") != 0) {
                LOOK_AND_FEEL.setLogicalGridLayoutDefaultColumnWidth(props.getPropertyInt("logicalGridLayout.defaultColumnWidth"));
            }
            if (props.getPropertyInt("logicalGridLayout.defaultPopupWidth") != 0) {
                LOOK_AND_FEEL.setLogicalGridLayoutDefaultPopupWidth(props.getPropertyInt("logicalGridLayout.defaultPopupWidth"));
            }
            if (props.getPropertyInt("logicalGridLayout.horizontalGap") != 0) {
                LOOK_AND_FEEL.setLogicalGridLayoutHorizontalGap(props.getPropertyInt("logicalGridLayout.horizontalGap"));
            }
            if (props.getPropertyInt("logicalGridLayout.rowHeight") != 0) {
                LOOK_AND_FEEL.setLogicalGridLayoutRowHeight(props.getPropertyInt("logicalGridLayout.rowHeight"));
            }
            if (props.getPropertyInt("logicalGridLayout.verticalGap") != 0) {
                LOOK_AND_FEEL.setLogicalGridLayoutVerticalGap(props.getPropertyInt("logicalGridLayout.verticalGap"));
            }
            if (props.getPropertyInt("processButton.height") != 0) {
                LOOK_AND_FEEL.setProcessButtonHeight(props.getPropertyInt("processButton.height"));
            }
            if (props.getPropertyInt("processButton.maxWidth") != 0) {
                LOOK_AND_FEEL.setProcessButtonMaxWidth(props.getPropertyInt("processButton.maxWidth"));
            }
            if (props.getPropertyInt("processButton.minWidth") != 0) {
                LOOK_AND_FEEL.setProcessButtonMinWidth(props.getPropertyInt("processButton.minWidth"));
            }
            if (props.getPropertyString("color.forground.disabled") != null) {
                LOOK_AND_FEEL.setColorForegroundDisabled(props.getPropertyString("color.forground.disabled"));
            }
            if (props.getPropertyString("messageBox.minWidth") != null) {
                LOOK_AND_FEEL.setMessageBoxMinWidth(props.getPropertyInt("messageBox.minWidth"));
            }
            if (props.getPropertyString("messageBox.minHeight") == null) continue;
            LOOK_AND_FEEL.setMessageBoxMinHeight(props.getPropertyInt("messageBox.minHeight"));
        }
    }

    private UiDecorationExtensionPoint() {
    }

    public static IUiDecoration getLookAndFeel() {
        return LOOK_AND_FEEL;
    }

    private static ILookAndFeelDecorations parseDecorations(IConfigurationElement decorationsElement) {
        LookAndFeelDecorations decorations = new LookAndFeelDecorations();
        decorations.setScope(UiDecorationExtensionPoint.getScopePriority(decorationsElement.getAttribute("scope")));
        IConfigurationElement[] mandatoryElement = decorationsElement.getChildren("mandatory");
        if (mandatoryElement.length > 0) {
            IConfigurationElement[] starMarker;
            IConfigurationElement[] labelFont;
            IConfigurationElement[] labelTextColor;
            IConfigurationElement[] fieldBackground = mandatoryElement[0].getChildren("fieldBackground");
            if (fieldBackground.length > 0) {
                decorations.setMandatoryFieldBackgroundColor(fieldBackground[0].getAttribute("color"));
            }
            if ((labelTextColor = mandatoryElement[0].getChildren("labelTextColor")).length > 0) {
                decorations.setMandatoryLabelTextColor(labelTextColor[0].getAttribute("color"));
            }
            if ((labelFont = mandatoryElement[0].getChildren("labelFont")).length > 0) {
                FontSpec spec = FontSpec.parse((String)labelFont[0].getAttribute("font"));
                decorations.setMandatoryLabelFont(spec);
            }
            if ((starMarker = mandatoryElement[0].getChildren("starMarker")).length > 0) {
                decorations.setStarMarkerPosition(UiDecorationExtensionPoint.parseStarMarkerPosition(starMarker[0].getAttribute("placement")));
            }
        }
        return decorations;
    }

    private static ILookAndFeelProperties parseProperties(IConfigurationElement propertiesElement) {
        IConfigurationElement[] properties;
        LookAndFeelProperties props = new LookAndFeelProperties();
        props.setScope(UiDecorationExtensionPoint.getScopePriority(propertiesElement.getAttribute("scope")));
        IConfigurationElement[] iConfigurationElementArray = properties = propertiesElement.getChildren("property");
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement prop = iConfigurationElementArray[n2];
            String propName = null;
            String propValue = null;
            try {
                propName = prop.getAttribute("name");
                propValue = prop.getAttribute("value");
                if ("color.forground.disabled".equals(propName) || "formFieldLabel.alignment".equals(propName)) {
                    props.setPropertyString(propName, propValue);
                } else if ("formMainBoxBorder.visible".equals(propName)) {
                    props.setPropertyBool(propName, Boolean.parseBoolean(propValue));
                } else {
                    props.setPropertyInt(propName, Integer.valueOf(propValue));
                }
            }
            catch (Exception exception) {
                LOG.error("could not parse extension look and feel of contributor '" + propertiesElement.getContributor().getName() + "' property name='" + propName + "' value='" + propValue + "'");
            }
            ++n2;
        }
        return props;
    }

    private static int getScopePriority(String scope) {
        int prio = 1;
        if (StringUtility.isNullOrEmpty((String)scope) || scope.equalsIgnoreCase("default")) {
            prio = 1;
        } else if (scope.equalsIgnoreCase("global")) {
            prio = 2;
        }
        return prio;
    }

    private static int parseStarMarkerPosition(String value) {
        int pos = 0;
        if (StringUtility.isNullOrEmpty((String)value) || value.equalsIgnoreCase("afterLabel")) {
            pos = 2;
        } else if (value.equalsIgnoreCase("beforeLabel")) {
            pos = 1;
        }
        return pos;
    }
}

