/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields;

import java.util.ArrayList;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.OnFieldLabelDecorator;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class RwtScoutFieldComposite<T extends IFormField>
extends RwtScoutComposite<T>
implements IRwtScoutFormField<T> {
    private ILabelComposite m_label;
    private IRwtKeyStroke[] m_keyStrokes;
    private Color m_mandatoryFieldBackgroundColor;
    private OnFieldLabelDecorator m_onFieldLabelDecorator;

    @Override
    public ILabelComposite getUiLabel() {
        return this.m_label;
    }

    public OnFieldLabelDecorator getOnFieldLabelDecorator() {
        return this.m_onFieldLabelDecorator;
    }

    protected void setUiLabel(ILabelComposite label) {
        this.m_label = label;
        if (this.m_label != null && label.getLayoutData() == null) {
            LogicalGridData statusLabelGridData = null;
            statusLabelGridData = ((IFormField)this.getScoutObject()).getLabelPosition() == 4 ? LogicalGridDataBuilder.createLabelOnTop(((IFormField)this.getScoutObject()).getGridData()) : LogicalGridDataBuilder.createLabel(((IFormField)this.getScoutObject()).getGridData());
            this.m_label.setLayoutData(statusLabelGridData);
        }
    }

    public Color getMandatoryFieldBackgroundColor() {
        return this.m_mandatoryFieldBackgroundColor;
    }

    protected void setErrorStatusFromScout(IProcessingStatus s) {
        if (this.getUiLabel() != null) {
            this.getUiLabel().setStatus(s);
            this.getUiContainer().layout(true, true);
        }
    }

    public void setMandatoryFieldBackgroundColor(Color mandatoryFieldBackgroundColor) {
        this.m_mandatoryFieldBackgroundColor = mandatoryFieldBackgroundColor;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.getScoutObject() != null) {
            this.setBackgroundFromScout(((IFormField)this.getScoutObject()).getBackgroundColor());
            this.setForegroundFromScout(((IFormField)this.getScoutObject()).getForegroundColor());
            this.setVisibleFromScout(((IFormField)this.getScoutObject()).isVisible());
            this.setEnabledFromScout(((IFormField)this.getScoutObject()).isEnabled());
            if (!(this.getScoutObject() instanceof ISequenceBox)) {
                this.setMandatoryFromScout(((IFormField)this.getScoutObject()).isMandatory());
            }
            this.setErrorStatusFromScout(((IFormField)this.getScoutObject()).getErrorStatus());
            this.setLabelFromScout(((IFormField)this.getScoutObject()).getLabel());
            this.setLabelWidthInPixelFromScout();
            this.setLabelVisibleFromScout();
            this.setLabelPositionFromScout();
            this.setLabelHorizontalAlignmentFromScout();
            this.setTooltipTextFromScout(((IFormField)this.getScoutObject()).getTooltipText());
            if (((IFormField)this.getScoutObject()).getLabelPosition() == 2 && ((IFormField)this.getScoutObject()).getLabel() != null && ((IFormField)this.getScoutObject()).getTooltipText() == null) {
                this.setTooltipTextFromScout(((IFormField)this.getScoutObject()).getLabel());
            }
            this.setFontFromScout(((IFormField)this.getScoutObject()).getFont());
            this.setSaveNeededFromScout(((IFormField)this.getScoutObject()).isSaveNeeded());
            this.setFocusableFromScout(((IFormField)this.getScoutObject()).isFocusable());
            this.updateKeyStrokesFromScout();
        }
    }

    protected void setVisibleFromScout(boolean b) {
        boolean updateLayout = false;
        if (this.getUiContainer() != null && this.getUiContainer().getVisible() != b) {
            updateLayout = true;
            this.getUiContainer().setVisible(b);
        } else if (this.getUiField() != null && this.getUiField().getVisible() != b) {
            updateLayout = true;
            this.getUiField().setVisible(b);
        }
        if (updateLayout && this.isCreated()) {
            RwtLayoutUtility.invalidateLayout(this.getUiEnvironment(), (Control)this.getUiContainer());
        }
    }

    protected void setEnabledFromScout(boolean b) {
        boolean updateLayout = false;
        Control field = this.getUiField();
        if (field != null) {
            updateLayout = true;
            this.setFieldEnabled(field, b);
            if (b) {
                this.setForegroundFromScout(((IFormField)this.getScoutObject()).getForegroundColor());
            } else {
                this.setForegroundFromScout(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
            }
        }
        if (this.getUiLabel() != null && this.getUiLabel().getEnabled() != b) {
            updateLayout = true;
            this.getUiLabel().setEnabled(b);
        }
        if (updateLayout && this.isCreated()) {
            RwtLayoutUtility.invalidateLayout(this.getUiEnvironment(), (Control)this.getUiContainer());
        }
    }

    protected void setFieldEnabled(Control field, boolean enabled) {
        field.setEnabled(enabled);
    }

    protected void setMandatoryFromScout(boolean b) {
        String fieldBackgroundColorString = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryFieldBackgroundColor();
        if (fieldBackgroundColorString != null) {
            Color color = null;
            color = b ? this.getUiEnvironment().getColor(fieldBackgroundColorString) : null;
            if (this.getMandatoryFieldBackgroundColor() != color) {
                this.setMandatoryFieldBackgroundColor(color);
                this.setBackgroundFromScout(((IFormField)this.getScoutObject()).getBackgroundColor());
            }
        }
        if (this.getUiLabel() != null) {
            if (this.getUiLabel().setMandatory(b) && this.isCreated()) {
                RwtLayoutUtility.invalidateLayout(this.getUiEnvironment(), (Control)this.getUiContainer());
            }
            this.setLabelVisibleFromScout();
        }
    }

    protected void setLabelPositionFromScout() {
        if (this.getUiField() != null) {
            if (((IFormField)this.getScoutObject()).getLabelPosition() == 2) {
                if (this.m_onFieldLabelDecorator == null) {
                    this.m_onFieldLabelDecorator = new OnFieldLabelDecorator(this.getUiField(), ((IFormField)this.getScoutObject()).isMandatory(), this);
                    this.m_onFieldLabelDecorator.setLabel(((IFormField)this.getScoutObject()).getLabel());
                }
                this.m_onFieldLabelDecorator.attach(this.getUiField());
            } else if (this.m_onFieldLabelDecorator != null) {
                this.m_onFieldLabelDecorator.detach(this.getUiField());
            }
            this.getUiField().redraw();
        }
        this.setLabelVisibleFromScout();
        this.setLabelFromScout(((IFormField)this.getScoutObject()).getLabel());
    }

    protected void setLabelWidthInPixelFromScout() {
        if (this.getUiLabel() == null) {
            return;
        }
        int w = ((IFormField)this.getScoutObject()).getLabelWidthInPixel();
        if (w > 0) {
            this.getUiLabel().setLayoutWidthHint(w);
        } else if (w == 0) {
            this.getUiLabel().setLayoutWidthHint(UiDecorationExtensionPoint.getLookAndFeel().getFormFieldLabelWidth());
        } else if (w == -1) {
            this.getUiLabel().setLayoutWidthHint(0);
        }
    }

    protected void setLabelHorizontalAlignmentFromScout() {
    }

    protected void setLabelFromScout(String s) {
        if (this.m_onFieldLabelDecorator != null) {
            this.m_onFieldLabelDecorator.setLabel(s);
        } else if (this.m_label != null && s != null) {
            this.m_label.setText(s);
        }
    }

    protected void setLabelVisibleFromScout() {
        if (this.m_label == null) {
            return;
        }
        boolean visible = ((IFormField)this.getScoutObject()).isLabelVisible();
        if (((IFormField)this.getScoutObject()).getLabelPosition() == 2) {
            this.m_label.setText(null);
            this.m_label.setLayoutWidthHint(0);
            if (!((IFormField)this.getScoutObject()).isMandatory()) {
                visible = false;
            }
        }
        this.m_label.setVisible(visible);
        if (this.getUiContainer() != null) {
            this.getUiContainer().layout(true, true);
        }
    }

    protected void setTooltipTextFromScout(String s) {
        if (this.getUiField() != null) {
            this.getUiField().setToolTipText(s);
        }
    }

    protected void setBackgroundFromScout(String scoutColor) {
        if (this.getUiField() != null) {
            Control fld = this.getUiField();
            if (fld.getData("scoutInitialBackground") == null) {
                fld.setData("scoutInitialBackground", (Object)fld.getBackground());
            }
            Color initCol = (Color)fld.getData("scoutInitialBackground");
            Color c = this.getUiEnvironment().getColor(scoutColor);
            if (this.getMandatoryFieldBackgroundColor() != null) {
                c = this.getMandatoryFieldBackgroundColor();
            }
            if (c == null) {
                c = initCol;
            }
            fld.setBackground(c);
        }
    }

    protected void setForegroundFromScout(String scoutColor) {
        if (this.getUiField() != null) {
            Control fld = this.getUiField();
            if (fld.getData("scoutInitialForeground") == null) {
                fld.setData("scoutInitialForeground", (Object)fld.getForeground());
            }
            Color initCol = (Color)fld.getData("scoutInitialForeground");
            Color c = this.getUiEnvironment().getColor(scoutColor);
            if (c == null) {
                c = initCol;
            }
            fld.setForeground(c);
        }
    }

    protected void setFontFromScout(FontSpec scoutFont) {
        if (this.getUiField() != null) {
            Control fld = this.getUiField();
            Font currentFont = fld.getFont();
            if (fld.getData("scoutInitialFont") == null) {
                fld.setData("scoutInitialFont", (Object)currentFont);
            }
            Font initFont = (Font)fld.getData("scoutInitialFont");
            Font f = this.getUiEnvironment().getFont(scoutFont, initFont);
            if (f == null) {
                f = initFont;
            }
            if (currentFont == null || !currentFont.equals((Object)f)) {
                fld.setFont(f);
            }
        }
        if (this.isCreated()) {
            RwtLayoutUtility.invalidateLayout(this.getUiEnvironment(), (Control)this.getUiContainer());
        }
    }

    protected void setSaveNeededFromScout(boolean b) {
    }

    protected void setFocusableFromScout(boolean b) {
    }

    protected void updateEmptyFromScout() {
    }

    protected void updateKeyStrokesFromScout() {
        Composite widget = this.getUiContainer();
        if (widget == null) {
            widget = this.getUiField();
        }
        if (widget != null) {
            IKeyStroke[] scoutKeyStrokes;
            if (this.m_keyStrokes != null) {
                IRwtKeyStroke[] iRwtKeyStrokeArray = this.m_keyStrokes;
                int n = this.m_keyStrokes.length;
                int n2 = 0;
                while (n2 < n) {
                    IRwtKeyStroke uiKeyStroke = iRwtKeyStrokeArray[n2];
                    this.getUiEnvironment().removeKeyStroke((Control)widget, uiKeyStroke);
                    ++n2;
                }
            }
            ArrayList<IRwtKeyStroke> newUiKeyStrokes = new ArrayList<IRwtKeyStroke>();
            IKeyStroke[] iKeyStrokeArray = scoutKeyStrokes = ((IFormField)this.getScoutObject()).getKeyStrokes();
            int n = scoutKeyStrokes.length;
            int n3 = 0;
            while (n3 < n) {
                IRwtKeyStroke[] uiStrokes;
                IKeyStroke scoutKeyStroke = iKeyStrokeArray[n3];
                IRwtKeyStroke[] iRwtKeyStrokeArray = uiStrokes = RwtUtility.getKeyStrokes(scoutKeyStroke, this.getUiEnvironment());
                int n4 = uiStrokes.length;
                int n5 = 0;
                while (n5 < n4) {
                    IRwtKeyStroke uiStroke = iRwtKeyStrokeArray[n5];
                    this.getUiEnvironment().addKeyStroke((Control)widget, uiStroke, false);
                    newUiKeyStrokes.add(uiStroke);
                    ++n5;
                }
                ++n3;
            }
            this.m_keyStrokes = newUiKeyStrokes.toArray(new IRwtKeyStroke[newUiKeyStrokes.size()]);
        }
    }

    @Override
    protected boolean isHandleScoutPropertyChange(final String name, final Object newValue) {
        if (name.equals("enabled") || name.equals("visible")) {
            this.getUiEnvironment().postImmediateUiJob(new Runnable(){

                @Override
                public void run() {
                    RwtScoutFieldComposite.this.handleScoutPropertyChange(name, newValue);
                }
            });
        }
        return super.isHandleScoutPropertyChange(name, newValue);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("enabled")) {
            this.setEnabledFromScout((Boolean)newValue);
        } else if (name.equals("focusable")) {
            this.setFocusableFromScout((Boolean)newValue);
        } else if (name.equals("label")) {
            this.setLabelFromScout((String)newValue);
        } else if (name.equals("labelVisible")) {
            this.setLabelVisibleFromScout();
        } else if (name.equals("tooltipText")) {
            this.setTooltipTextFromScout((String)newValue);
        } else if (name.equals("visible")) {
            this.setVisibleFromScout((Boolean)newValue);
        } else if (name.equals("mandatory")) {
            this.setMandatoryFromScout((Boolean)newValue);
        } else if (name.equals("errorStatus")) {
            this.setErrorStatusFromScout((IProcessingStatus)newValue);
        } else if (name.equals("foregroundColor")) {
            this.setForegroundFromScout((String)newValue);
        } else if (name.equals("backgroundColor")) {
            this.setBackgroundFromScout((String)newValue);
        } else if (name.equals("font")) {
            this.setFontFromScout((FontSpec)newValue);
        } else if (name.equals("saveNeeded")) {
            this.setSaveNeededFromScout((Boolean)newValue);
        } else if (name.equals("empty")) {
            this.updateEmptyFromScout();
        } else if (name.equals("keyStrokes")) {
            this.updateKeyStrokesFromScout();
        }
    }
}

