/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.button;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.WeakEventListener;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonEvent;
import org.eclipse.scout.rt.client.ui.form.fields.button.ButtonListener;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.basic.comp.HyperlinkEx;
import org.eclipse.scout.rt.ui.rap.ext.ButtonEx;
import org.eclipse.scout.rt.ui.rap.ext.MenuAdapterEx;
import org.eclipse.scout.rt.ui.rap.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.button.IRwtScoutButton;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class RwtScoutButton
extends RwtScoutFieldComposite<IButton>
implements IRwtScoutButton {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutButton.class);
    private ButtonListener m_scoutButtonListener;
    private OptimisticLock m_selectionLock = new OptimisticLock();
    private boolean m_handleActionPending;
    private Menu m_contextMenu;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        this.setUiContainer(container);
        ButtonEx uiFieldAsButton = null;
        HyperlinkEx uiFieldAsLink = null;
        switch (((IButton)this.getScoutObject()).getDisplayStyle()) {
            case 2: {
                ButtonEx uiButton;
                uiFieldAsButton = uiButton = this.getUiEnvironment().getFormToolkit().createButtonEx(container, 16400);
                break;
            }
            case 1: {
                ButtonEx uiButton;
                uiFieldAsButton = uiButton = this.getUiEnvironment().getFormToolkit().createButtonEx(container, 0x1000002);
                break;
            }
            case 3: {
                HyperlinkEx uiLink;
                HyperlinkGroup linkGroup = this.getUiEnvironment().getFormToolkit().getHyperlinkGroup();
                linkGroup.setHyperlinkUnderlineMode(2);
                int style = 0x1000000;
                uiFieldAsLink = uiLink = this.getUiEnvironment().getFormToolkit().createHyperlink(container, "", style);
                break;
            }
            default: {
                int style = 0x1000008;
                if (((IButton)this.getScoutObject()).hasMenus()) {
                    style |= 4;
                }
                ButtonEx uiButton = this.getUiEnvironment().getFormToolkit().createButtonEx(container, style);
                uiButton.setDropDownEnabled(true);
                uiFieldAsButton = uiButton;
            }
        }
        this.setUiLabel(null);
        if (uiFieldAsButton != null) {
            this.m_contextMenu = new Menu((Decorations)uiFieldAsButton.getShell(), 8);
            this.m_contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener((Control)uiFieldAsButton, (Control)uiFieldAsButton.getParent()));
            uiFieldAsButton.setMenu(this.m_contextMenu);
            uiFieldAsButton.addListener(44, new P_RwtSelectionListener());
            this.setUiField((Control)uiFieldAsButton);
            LogicalGridData gd = (LogicalGridData)this.getUiField().getLayoutData();
            this.adaptButtonLayoutData(gd);
        } else if (uiFieldAsLink != null) {
            uiFieldAsLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    RwtScoutButton.this.handleUiAction();
                }
            });
            this.setUiField((Control)uiFieldAsLink);
            this.getUiContainer().setTabList(new Control[]{uiFieldAsLink});
        }
        this.getUiContainer().setLayout((Layout)new LogicalGridLayout(0, 0));
    }

    protected void adaptButtonLayoutData(LogicalGridData gd) {
        if (!((IButton)this.getScoutObject()).isProcessButton() || gd.useUiHeight) {
            return;
        }
        gd.useUiHeight = true;
        IUiDecoration deco = UiDecorationExtensionPoint.getLookAndFeel();
        gd.heightHint = deco.getProcessButtonHeight();
    }

    @Override
    protected void setBackgroundFromScout(String scoutColor) {
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IButton b = (IButton)this.getScoutObject();
        b.hasMenus();
        this.setIconIdFromScout(b.getIconId());
        this.setImageFromScout(b.getImage());
        this.setSelectionFromScout(b.isSelected());
        this.setLabelFromScout(b.getLabel());
        if (this.m_scoutButtonListener == null) {
            this.m_scoutButtonListener = new P_ScoutButtonListener();
            ((IButton)this.getScoutObject()).addButtonListener(this.m_scoutButtonListener);
        }
    }

    @Override
    protected void detachScout() {
        if (this.m_scoutButtonListener != null) {
            ((IButton)this.getScoutObject()).removeButtonListener(this.m_scoutButtonListener);
            this.m_scoutButtonListener = null;
        }
        super.detachScout();
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        if (((IButton)this.getScoutObject()).getDisplayStyle() == 3 && scoutColor == null) {
            scoutColor = "67A8CE";
        }
        super.setForegroundFromScout(scoutColor);
    }

    protected void setIconIdFromScout(String s) {
        if (s != null) {
            Image icon = this.getUiEnvironment().getIcon(s);
            Control comp = this.getUiField();
            if (comp instanceof Button) {
                Button b = (Button)comp;
                b.setImage(icon);
            } else {
                boolean cfr_ignored_0 = comp instanceof Hyperlink;
            }
        }
    }

    @Override
    protected void setLabelFromScout(String s) {
        Control comp = this.getUiField();
        if (comp instanceof Button) {
            Button b = (Button)comp;
            String label = s;
            b.setText(label == null ? "" : label);
        } else if (comp instanceof Hyperlink) {
            Hyperlink t = (Hyperlink)comp;
            String label = StringUtility.removeMnemonic((String)s);
            t.setText(label == null ? "" : label);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setSelectionFromScout(boolean b) {
        try {
            if (!this.m_selectionLock.acquire()) return;
            switch (((IButton)this.getScoutObject()).getDisplayStyle()) {
                case 1: 
                case 2: {
                    Button but;
                    Control comp = this.getUiField();
                    if (!(comp instanceof Button) || b == (but = (Button)comp).getSelection()) return;
                    but.setSelection(b);
                }
                default: {
                    return;
                }
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    protected void setSelectionFromUi(final boolean b) {
        try {
            if (this.m_selectionLock.acquire()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (((IButton)RwtScoutButton.this.getScoutObject()).isSelected() != b) {
                            ((IButton)RwtScoutButton.this.getScoutObject()).getUIFacade().setSelectedFromUI(b);
                        }
                        ((IButton)RwtScoutButton.this.getScoutObject()).getUIFacade().fireButtonClickedFromUI();
                    }
                };
                this.getUiEnvironment().invokeScoutLater(t, 0L);
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    protected void handleUiAction() {
        if (!this.m_handleActionPending) {
            this.m_handleActionPending = true;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        ((IButton)RwtScoutButton.this.getScoutObject()).getUIFacade().fireButtonClickedFromUI();
                    }
                    finally {
                        RwtScoutButton.this.m_handleActionPending = false;
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void setImageFromScout(Object img) {
        if (img instanceof Image) {
            Control comp = this.getUiField();
            if (comp instanceof Button) {
                Button b = (Button)comp;
                b.setImage((Image)img);
            } else {
                boolean cfr_ignored_0 = comp instanceof Hyperlink;
            }
        }
    }

    protected void disarmButtonFromScout() {
    }

    protected void requestPopupFromScout() {
        if (this.m_contextMenu != null) {
            this.m_contextMenu.setVisible(true);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("iconId")) {
            this.setIconIdFromScout((String)newValue);
        } else if (name.equals("image")) {
            this.setImageFromScout(newValue);
        } else if (name.equals("selected")) {
            this.setSelectionFromScout((Boolean)newValue);
        }
    }

    private class P_ContextMenuListener
    extends MenuAdapterEx {
        private static final long serialVersionUID = 1L;

        public P_ContextMenuListener(Control menuControl, Control keyStrokeWidget) {
            super(menuControl, keyStrokeWidget);
        }

        @Override
        protected Menu getContextMenu() {
            return RwtScoutButton.this.m_contextMenu;
        }

        @Override
        protected void setContextMenu(Menu contextMenu) {
            RwtScoutButton.this.m_contextMenu = contextMenu;
        }

        @Override
        public void menuShown(MenuEvent e) {
            super.menuShown(e);
            final AtomicReference scoutMenusRef = new AtomicReference();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IMenu[] scoutMenus = ((IButton)RwtScoutButton.this.getScoutObject()).getUIFacade().fireButtonPopupFromUI();
                    scoutMenusRef.set(scoutMenus);
                }
            };
            JobEx job = RwtScoutButton.this.getUiEnvironment().invokeScoutLater(t, 1200L);
            try {
                job.join(1200L);
            }
            catch (InterruptedException interruptedException) {}
            if (scoutMenusRef.get() != null) {
                RwtMenuUtility.fillContextMenu((IMenu[])scoutMenusRef.get(), RwtScoutButton.this.getUiEnvironment(), RwtScoutButton.this.m_contextMenu);
            }
        }
    }

    private class P_RwtSelectionListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_RwtSelectionListener() {
        }

        public void handleEvent(Event event) {
            block0 : switch (event.type) {
                case 44: {
                    switch (((IButton)RwtScoutButton.this.getScoutObject()).getDisplayStyle()) {
                        case 1: 
                        case 2: {
                            RwtScoutButton.this.setSelectionFromUi(((Button)RwtScoutButton.this.getUiField()).getSelection());
                            break block0;
                        }
                    }
                    RwtScoutButton.this.handleUiAction();
                }
            }
        }
    }

    private class P_ScoutButtonListener
    implements ButtonListener,
    WeakEventListener {
        private P_ScoutButtonListener() {
        }

        public void buttonChanged(ButtonEvent e) {
            switch (e.getType()) {
                case 3: {
                    RwtScoutButton.this.getUiEnvironment().invokeUiLater(new Runnable(){

                        @Override
                        public void run() {
                            RwtScoutButton.this.disarmButtonFromScout();
                        }
                    });
                    break;
                }
                case 4: {
                    RwtScoutButton.this.getUiEnvironment().invokeUiLater(new Runnable(){

                        @Override
                        public void run() {
                            RwtScoutButton.this.requestPopupFromScout();
                        }
                    });
                }
            }
        }
    }
}

