/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.groupbox;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.rap.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.ScrolledFormEx;
import org.eclipse.scout.rt.ui.rap.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.rap.form.fields.groupbox.IRwtScoutGroupBox;
import org.eclipse.scout.rt.ui.rap.form.fields.groupbox.RwtScoutGroupBoxButtonbar;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class RwtScoutGroupBox
extends RwtScoutFieldComposite<IGroupBox>
implements IRwtScoutGroupBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutGroupBox.class);
    static final String VARIANT_GROUP_BOX_WITH_LINE_FRAME = "groupBoxWithLineFrame";
    static final String VARIANT_LABEL = "GroupBoxLabel";
    static final String VARIANT_LINE = "GroupBoxLine";
    private ScrolledFormEx m_scrolledForm;
    private Section m_section;
    private Group m_group;
    private Label m_label;
    private Label m_line;
    private Composite m_bodyPart;
    private RwtScoutGroupBoxButtonbar m_buttonbar;
    private BorderDecoration m_borderDecoration;
    private String m_containerLabel;
    private String m_containerImage;

    @Override
    protected void initializeUi(Composite parent) {
        IFormField[] scoutFields;
        GridData bodyData;
        this.m_borderDecoration = this.resolveBorderDecoration();
        Composite rootPane = this.createContainer(parent);
        if (((IGroupBox)this.getScoutObject()).isScrollable()) {
            this.m_scrolledForm = this.getUiEnvironment().getFormToolkit().createScrolledFormEx(rootPane, 512);
            bodyData = new GridData(1808);
            bodyData.horizontalIndent = 0;
            bodyData.verticalIndent = 0;
            this.m_scrolledForm.setLayoutData(bodyData);
            this.m_bodyPart = this.m_scrolledForm.getBody();
        } else {
            this.m_bodyPart = this.getUiEnvironment().getFormToolkit().createComposite(rootPane);
            bodyData = new GridData(1808);
            bodyData.horizontalIndent = 0;
            bodyData.verticalIndent = 0;
            this.m_bodyPart.setLayoutData((Object)bodyData);
        }
        this.m_bodyPart.setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot(this.m_bodyPart){

            @Override
            public void validate() {
                super.validate();
                if (RwtScoutGroupBox.this.m_scrolledForm != null && !RwtScoutGroupBox.this.m_scrolledForm.isDisposed()) {
                    RwtScoutGroupBox.this.m_scrolledForm.reflow(true);
                }
            }
        });
        if (((IGroupBox)this.getScoutObject()).getCustomProcessButtonCount() + ((IGroupBox)this.getScoutObject()).getSystemProcessButtonCount() > 0) {
            this.createButtonbar(rootPane);
        }
        IUiDecoration deco = UiDecorationExtensionPoint.getLookAndFeel();
        LogicalGridLayout bodyLayout = new LogicalGridLayout(deco.getLogicalGridLayoutHorizontalGap(), deco.getLogicalGridLayoutVerticalGap());
        this.m_bodyPart.setLayout((Layout)bodyLayout);
        this.installUiContainerBorder();
        IFormField[] iFormFieldArray = scoutFields = ((IGroupBox)this.getScoutObject()).getControlFields();
        int n = scoutFields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField field = iFormFieldArray[n2];
            IRwtScoutFormField uiScoutComposite = this.getUiEnvironment().createFormField(this.m_bodyPart, field);
            RwtScoutFormFieldGridData layoutData = new RwtScoutFormFieldGridData(field);
            uiScoutComposite.getUiContainer().setLayoutData((Object)layoutData);
            ++n2;
        }
    }

    protected Composite createButtonbar(Composite parent) {
        this.m_buttonbar = new RwtScoutGroupBoxButtonbar();
        this.m_buttonbar.createUiField(parent, (IGroupBox)this.getScoutObject(), this.getUiEnvironment());
        GridData data = new GridData(768);
        this.m_buttonbar.getUiContainer().setLayoutData((Object)data);
        return this.m_buttonbar.getUiContainer();
    }

    protected BorderDecoration resolveBorderDecoration() {
        IGroupBox box = (IGroupBox)this.getScoutObject();
        BorderDecoration deco = new BorderDecoration();
        deco.visible = box.isBorderVisible();
        deco.decoration = "empty";
        if ("section".equals(box.getBorderDecoration())) {
            deco.decoration = "section";
            return deco;
        }
        if ("line".equals(box.getBorderDecoration())) {
            deco.decoration = "line";
            return deco;
        }
        if ("empty".equals(box.getBorderDecoration())) {
            deco.decoration = "empty";
            return deco;
        }
        if (!"auto".equals(box.getBorderDecoration())) {
            deco.decoration = "empty";
            return deco;
        }
        if (box.isExpandable()) {
            deco.decoration = "section";
            return deco;
        }
        if (box.isMainBox()) {
            if (UiDecorationExtensionPoint.getLookAndFeel().isFormMainBoxBorderVisible()) {
                deco.decoration = "empty";
                return deco;
            }
            deco.visible = false;
            return deco;
        }
        if (box.getParentField() instanceof ITabBox) {
            deco.decoration = "empty";
            return deco;
        }
        deco.decoration = "line";
        return deco;
    }

    protected Composite createContainer(Composite parent) {
        Composite rootPane;
        GridLayout layout = new GridLayout(1, true);
        this.setUiLabel(null);
        if (this.m_borderDecoration.visible) {
            if ("section".equals(this.m_borderDecoration.decoration)) {
                int style = (((IGroupBox)this.getScoutObject()).isExpanded() ? 64 : 0) | 0x100;
                if (((IGroupBox)this.getScoutObject()).isExpandable()) {
                    style |= 2;
                }
                this.m_section = this.getUiEnvironment().getFormToolkit().createSection(parent, style);
                String label = ((IGroupBox)this.getScoutObject()).getLabel();
                if (label == null) {
                    label = "";
                }
                this.m_section.setText(label);
                this.m_section.addExpansionListener((IExpansionListener)new P_ExpansionListener());
                this.setUiContainer((Composite)this.m_section);
                rootPane = this.getUiEnvironment().getFormToolkit().createSectionClient((Composite)this.m_section);
                this.m_section.setClient((Control)rootPane);
                layout.horizontalSpacing = 0;
                layout.verticalSpacing = 0;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.marginTop = 5;
                layout.marginRight = 7;
                layout.marginBottom = 5;
                layout.marginLeft = 5;
                rootPane.setLayout((Layout)layout);
            } else if ("line".equals(this.m_borderDecoration.decoration)) {
                Composite groupComp = this.getUiEnvironment().getFormToolkit().createComposite(parent, 0);
                this.m_label = this.getUiEnvironment().getFormToolkit().createLabel(groupComp, "", 0);
                this.m_label.setData("org.eclipse.rwt.themeVariant", (Object)VARIANT_LABEL);
                this.m_line = this.getUiEnvironment().getFormToolkit().createLabel(groupComp, "", 0);
                this.m_line.setData("org.eclipse.rwt.themeVariant", (Object)VARIANT_LINE);
                rootPane = this.getUiEnvironment().getFormToolkit().createComposite(groupComp, 0);
                rootPane.setData("org.eclipse.rwt.themeVariant", (Object)VARIANT_GROUP_BOX_WITH_LINE_FRAME);
                this.setUiContainer(groupComp);
                GridLayout groupCompLayout = new GridLayout(1, false);
                groupCompLayout.horizontalSpacing = 0;
                groupCompLayout.marginHeight = 0;
                groupCompLayout.marginWidth = 0;
                groupCompLayout.verticalSpacing = 0;
                groupComp.setLayout((Layout)groupCompLayout);
                GridData labelLayoutData = new GridData();
                labelLayoutData.horizontalIndent = 14;
                this.m_label.setLayoutData((Object)labelLayoutData);
                GridData lineLayoutData = new GridData(768);
                lineLayoutData.heightHint = 1;
                this.m_line.setLayoutData((Object)lineLayoutData);
                GridData groupLayoutData = new GridData(1808);
                rootPane.setLayoutData((Object)groupLayoutData);
                layout.horizontalSpacing = 0;
                layout.verticalSpacing = 0;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                rootPane.setLayout((Layout)layout);
            } else {
                Group emptyGroup = this.getUiEnvironment().getFormToolkit().createGroup(parent, 0);
                rootPane = emptyGroup;
                rootPane.setData("org.eclipse.rwt.themeVariant", (Object)"empty");
                this.setUiContainer(rootPane);
                layout.horizontalSpacing = 0;
                layout.verticalSpacing = 0;
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                rootPane.setLayout((Layout)layout);
            }
        } else {
            rootPane = this.getUiEnvironment().getFormToolkit().createComposite(parent);
            this.setUiContainer(rootPane);
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            rootPane.setLayout((Layout)layout);
        }
        return rootPane;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.updateBackgroundImageFromScout();
        this.updateBackgroundImageHorizontalAlignFromScout();
        this.updateBackgroundImageVerticalAlignFromScout();
        this.setExpandedFromScout();
    }

    protected void setExpandedFromScout() {
        if (((IGroupBox)this.getScoutObject()).isExpandable() && this.m_section != null && this.m_section.isExpanded() != ((IGroupBox)this.getScoutObject()).isExpanded()) {
            this.m_section.setExpanded(((IGroupBox)this.getScoutObject()).isExpanded());
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
    }

    @Override
    protected void setLabelFromScout(String s) {
        if (s == null) {
            s = "";
        }
        if (this.m_section != null) {
            this.m_section.setText(s);
            this.m_section.layout(true, true);
        }
        if (this.m_group != null) {
            this.m_group.setText(s);
        }
        if (this.m_label != null && this.m_line != null) {
            this.m_label.setText(s);
            if (StringUtility.hasText((String)s)) {
                ((GridData)this.m_label.getLayoutData()).exclude = false;
                this.m_label.setVisible(true);
                ((GridData)this.m_line.getLayoutData()).exclude = false;
                this.m_line.setVisible(true);
            } else {
                ((GridData)this.m_label.getLayoutData()).exclude = true;
                this.m_label.setVisible(false);
                ((GridData)this.m_line.getLayoutData()).exclude = true;
                this.m_line.setVisible(false);
            }
        }
    }

    protected void updateBackgroundImageFromScout() {
        String imageName = ((IGroupBox)this.getScoutObject()).getBackgroundImageName();
        if (!(imageName == this.m_containerImage || imageName != null && imageName.equals(this.m_containerImage))) {
            this.m_containerImage = imageName;
            this.installUiContainerBorder();
        }
    }

    protected void updateBackgroundImageHorizontalAlignFromScout() {
    }

    protected void updateBackgroundImageVerticalAlignFromScout() {
    }

    private void installUiContainerBorder() {
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("expanded")) {
            this.setExpandedFromScout();
        } else if (name.equals("backgroundImageName")) {
            this.updateBackgroundImageFromScout();
        } else if (name.equals("backgroundImageHorizontalAlignment")) {
            this.updateBackgroundImageHorizontalAlignFromScout();
        } else if (name.equals("backgroundImageVerticalAlignment")) {
            this.updateBackgroundImageVerticalAlignFromScout();
        }
    }

    protected void handleUiGroupBoxExpanded(final boolean expanded) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IGroupBox)RwtScoutGroupBox.this.getScoutObject()).getUIFacade().setExpandedFromUI(expanded);
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    public static class BorderDecoration {
        public boolean visible;
        public String decoration;
    }

    private class P_ExpansionListener
    extends ExpansionAdapter {
        private P_ExpansionListener() {
        }

        public void expansionStateChanged(ExpansionEvent e) {
            RwtScoutGroupBox.this.handleUiGroupBoxExpanded(e.getState());
        }
    }
}

