/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.util;

import java.util.Locale;
import org.osgi.framework.Version;

public class BrowserInfo {
    private String m_userAgent = "";
    private final Type m_type;
    private Version m_version;
    private boolean m_isWebkit = false;
    private boolean m_isGecko = false;
    private boolean m_isMshtml = false;
    private boolean m_isOpera = false;
    private boolean m_isMobile = false;
    private boolean m_isTablet = false;
    private System m_system;
    private Locale m_locale = null;

    BrowserInfo(Type type, Version version) {
        this(type, version, System.UNKNOWN);
    }

    BrowserInfo(Type type, Version version, System system) {
        this.m_type = type;
        this.m_version = version;
        this.m_system = system;
    }

    public String getUserAgent() {
        return this.m_userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.m_userAgent = userAgent;
    }

    public boolean isWebkit() {
        return this.m_isWebkit;
    }

    public void setWebkit(boolean isWebkit) {
        this.m_isWebkit = isWebkit;
    }

    public boolean isGecko() {
        return this.m_isGecko;
    }

    public void setGecko(boolean isGecko) {
        this.m_isGecko = isGecko;
    }

    public boolean isMshtml() {
        return this.m_isMshtml;
    }

    public void setMshtml(boolean isMshtml) {
        this.m_isMshtml = isMshtml;
    }

    public boolean isOpera() {
        return this.m_isOpera;
    }

    public void setOpera(boolean isOpera) {
        this.m_isOpera = isOpera;
    }

    public boolean isMobile() {
        return this.m_isMobile;
    }

    public void setMobile(boolean isMobile) {
        this.m_isMobile = isMobile;
    }

    public boolean isTablet() {
        return this.m_isTablet;
    }

    public void setTablet(boolean isTablet) {
        this.m_isTablet = isTablet;
    }

    public Type getType() {
        return this.m_type;
    }

    public System getSystem() {
        return this.m_system;
    }

    public void setSystem(System system) {
        this.m_system = system;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public boolean isInternetExplorer() {
        return this.m_type == Type.IE;
    }

    public boolean isMozillaFirefox() {
        return this.m_type == Type.MOZILLA_FIREFOX;
    }

    public boolean isGoogleChrome() {
        return this.m_type == Type.GOOGLE_CHROME;
    }

    public boolean isAppleSafari() {
        return this.m_type == Type.APPLE_SAFARI;
    }

    public boolean isUnknown() {
        return this.m_type == Type.UNKNOWN;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public boolean isDesktop() {
        return !this.isTablet() && !this.isMobile();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("System: ").append((Object)this.getSystem());
        if (this.isWebkit()) {
            sb.append("/ isWebkit");
        } else if (this.isGecko()) {
            sb.append("/ isGecko");
        } else if (this.isMshtml()) {
            sb.append("/ isMshtml");
        }
        sb.append("/ Browser: ").append((Object)this.getType());
        sb.append("/ EngineVersion: ").append(this.getVersion());
        sb.append("\nUserAgent: ").append(this.m_userAgent);
        return sb.toString();
    }

    public static enum System {
        WINDOWS,
        UNIX,
        OSX,
        IOS,
        IPHONE,
        IPOD,
        ANDROID,
        UNKNOWN;

    }

    public static enum Type {
        GOOGLE_CHROME,
        APPLE_SAFARI,
        OMNI_WEB,
        SHIRA,
        BLACKPIXEL_NETNEWSWIRE,
        REALNETWORKS_REALPLAYER,
        MOZILLA_FIREFOX,
        MOZILLA_CAMINO,
        GNOME_GALOEN,
        IE,
        OPERA,
        KONQUEROR,
        UNKNOWN;

    }
}

