/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop.navigation;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rwt.IBrowserHistory;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.events.BrowserHistoryEvent;
import org.eclipse.rwt.events.BrowserHistoryListener;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.desktop.navigation.INavigationHistoryService;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryEvent;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryListener;
import org.eclipse.scout.rt.shared.services.common.bookmark.AbstractPageState;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.service.SERVICES;

public class RwtScoutNavigationSupport {
    private final IRwtEnvironment m_uiEnvironment;
    private IBrowserHistory m_uiHistory;
    private INavigationHistoryService m_historyService;
    private P_NavigationHistoryListener m_scoutListener;
    private BrowserHistoryListener m_uiListener = new BrowserHistoryListener(){
        private static final long serialVersionUID = 1L;

        public void navigated(BrowserHistoryEvent event) {
            RwtScoutNavigationSupport.this.handleNavigationFromUi(event.entryId);
        }
    };

    public RwtScoutNavigationSupport(IRwtEnvironment uiEnvironment) {
        this.m_uiEnvironment = uiEnvironment;
    }

    public void install() {
        if (this.m_uiHistory == null) {
            this.m_uiHistory = RWT.getBrowserHistory();
            this.m_uiHistory.addBrowserHistoryListener(this.m_uiListener);
        }
        new ClientSyncJob("", this.getUiEnvironment().getClientSession()){

            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                RwtScoutNavigationSupport.this.m_historyService = (INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class);
                if (RwtScoutNavigationSupport.this.m_scoutListener == null) {
                    RwtScoutNavigationSupport.this.m_scoutListener = new P_NavigationHistoryListener();
                    RwtScoutNavigationSupport.this.m_historyService.addNavigationHistoryListener((NavigationHistoryListener)RwtScoutNavigationSupport.this.m_scoutListener);
                }
            }
        }.schedule();
    }

    public void uninstall() {
        if (this.m_historyService != null && this.m_scoutListener != null) {
            this.m_historyService.removeNavigationHistoryListener((NavigationHistoryListener)this.m_scoutListener);
        }
        if (this.m_uiHistory != null) {
            this.m_uiHistory.removeBrowserHistoryListener(this.m_uiListener);
        }
    }

    protected void handleNavigationFromUi(final String entryId) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    for (Bookmark b : RwtScoutNavigationSupport.this.m_historyService.getBookmarks()) {
                        if (!RwtScoutNavigationSupport.this.getId(b).equals(entryId)) continue;
                        RwtScoutNavigationSupport.this.m_historyService.stepTo(b);
                        break;
                    }
                }
                catch (ProcessingException processingException) {}
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    private IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    protected void handleBookmarkAddedFromScout(Bookmark bookmark) {
        String id = this.getId(bookmark);
        StringBuilder textBuilder = new StringBuilder(String.valueOf(this.getUiEnvironment().getClientSession().getDesktop().getTitle()) + " - ");
        textBuilder.append(this.cleanNl(bookmark.getText()));
        this.m_uiHistory.createEntry(id, textBuilder.toString());
    }

    private String cleanNl(String s) {
        s = s.replaceAll("(\r\n)|(\n\r)|(\n)|(\r)", " -");
        return s;
    }

    private String cleanBrowserSpecialChars(String s) {
        s = s.replaceAll("\\s*\\-\\s*", "-");
        s = s.replaceAll("\\s+", "-");
        s = s.replaceAll(",", "");
        return s;
    }

    private String getId(Bookmark b) {
        List path;
        StringBuilder key = new StringBuilder();
        if (!StringUtility.isNullOrEmpty((String)b.getOutlineClassName())) {
            key.append(b.getOutlineClassName());
        }
        if (!(path = b.getPath()).isEmpty()) {
            int i = 0;
            while (i < path.size()) {
                if (!StringUtility.isNullOrEmpty((String)((AbstractPageState)path.get(i)).getLabel())) {
                    key.append("-" + ((AbstractPageState)path.get(i)).getLabel());
                }
                ++i;
            }
        }
        return this.cleanBrowserSpecialChars(this.cleanNl(key.toString()));
    }

    private class P_NavigationHistoryListener
    implements NavigationHistoryListener {
        private P_NavigationHistoryListener() {
        }

        public void navigationChanged(NavigationHistoryEvent e) {
            if (e.getType() == 20) {
                final Bookmark bookmark = e.getBookmark();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutNavigationSupport.this.handleBookmarkAddedFromScout(bookmark);
                    }
                };
                RwtScoutNavigationSupport.this.getUiEnvironment().invokeUiLater(r);
            }
        }
    }
}

