/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop.viewarea;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.rt.ui.rap.window.desktop.RwtScoutViewStack;
import org.eclipse.scout.rt.ui.rap.window.desktop.viewarea.ILayoutListener;
import org.eclipse.scout.rt.ui.rap.window.desktop.viewarea.ViewArea;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

public class ViewAreaLayout
extends Layout {
    private static final long serialVersionUID = 1L;
    private static int SASH_WIDTH = 3;
    private static int MIN_SIZE = 30;
    Rectangle boundsLeft;
    Rectangle boundsSashLeft;
    Rectangle boundsCenter;
    Rectangle boundsSashRight;
    Rectangle boundsRight;
    private EventListenerList m_eventListeners;
    private WeakHashMap<Control, Rectangle> m_bounds = new WeakHashMap();

    public ViewAreaLayout() {
        this.m_eventListeners = new EventListenerList();
    }

    public void addLayoutListener(ILayoutListener listener) {
        this.m_eventListeners.add(ILayoutListener.class, (EventListener)listener);
    }

    public void removeLayoutListener(ILayoutListener listener) {
        this.m_eventListeners.remove(ILayoutListener.class, (EventListener)listener);
    }

    private void fireCompositeLayouted() {
        ILayoutListener[] iLayoutListenerArray = (ILayoutListener[])this.m_eventListeners.getListeners(ILayoutListener.class);
        int n = iLayoutListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILayoutListener l = iLayoutListenerArray[n2];
            l.handleCompositeLayouted();
            ++n2;
        }
    }

    protected void layout(Composite composite, boolean flushCache) {
        Sash verticalRight;
        Assert.isTrue((boolean)(composite instanceof ViewArea));
        ViewArea viewArea = (ViewArea)composite;
        Rectangle clientArea = viewArea.getClientArea();
        this.cache(viewArea, clientArea.x, clientArea.y, clientArea.width, clientArea.height, flushCache);
        int x = 0;
        while (x < 3) {
            int y = 0;
            while (y < 3) {
                RwtScoutViewStack view = viewArea.m_viewStacks[x][y];
                if (view.getVisible()) {
                    view.setBounds(this.m_bounds.get(view));
                }
                ++y;
            }
            ++x;
        }
        ArrayList<ViewArea.SashKey> keys = new ArrayList<ViewArea.SashKey>(Arrays.asList(ViewArea.SashKey.values()));
        keys.remove((Object)ViewArea.SashKey.VERTICAL_LEFT);
        keys.remove((Object)ViewArea.SashKey.VERTICAL_RIGHT);
        for (ViewArea.SashKey k : keys) {
            Sash s = viewArea.getSash(k);
            if (!s.getVisible()) continue;
            Rectangle bounds = this.m_bounds.get(s);
            s.setBounds(bounds);
        }
        Sash verticalLeft = viewArea.getSash(ViewArea.SashKey.VERTICAL_LEFT);
        if (verticalLeft.getVisible()) {
            Rectangle bounds = new Rectangle(this.boundsSashLeft.x, this.boundsSashLeft.y, this.boundsSashLeft.width, this.boundsSashLeft.height);
            bounds.height = clientArea.height;
            verticalLeft.setBounds(bounds);
        }
        if ((verticalRight = viewArea.getSash(ViewArea.SashKey.VERTICAL_RIGHT)).getVisible()) {
            Rectangle bounds = new Rectangle(this.boundsSashRight.x, this.boundsSashRight.y, this.boundsSashRight.width, this.boundsSashRight.height);
            bounds.height = clientArea.height;
            verticalRight.setBounds(bounds);
        }
        this.fireCompositeLayouted();
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Assert.isTrue((boolean)(composite instanceof ViewArea));
        ViewArea viewArea = (ViewArea)composite;
        Point minSize = new Point(0, 0);
        Point prefSize = new Point(0, 0);
        int x = 0;
        while (x < 3) {
            int height = 0;
            int minHeight = 0;
            int width = 0;
            int minWidth = 0;
            int y = 0;
            while (y < 3) {
                RwtScoutViewStack view = viewArea.m_viewStacks[x][y];
                if (view.getVisible()) {
                    if (minHeight > 0) {
                        minHeight += SASH_WIDTH;
                    }
                    minHeight += MIN_SIZE;
                    Point computedSize = view.computeSize(-1, -1);
                    if (height > 0) {
                        height += SASH_WIDTH;
                    }
                    height += computedSize.y;
                    minWidth = Math.max(minWidth, MIN_SIZE);
                    width = Math.max(width, computedSize.x);
                }
                ++y;
            }
            minSize.y = Math.max(minSize.y, minHeight);
            prefSize.y = Math.max(prefSize.y, height);
            if (minSize.x > 0) {
                minSize.x += SASH_WIDTH;
            }
            minSize.x += minWidth;
            if (prefSize.x > 0) {
                prefSize.x += SASH_WIDTH;
            }
            prefSize.x += width;
            ++x;
        }
        int w = prefSize.x;
        if (wHint >= 0) {
            w = Math.max(minSize.x, wHint);
        }
        int h = prefSize.y;
        if (hHint >= 0) {
            h = Math.max(minSize.y, hHint);
        }
        return new Point(w, h);
    }

    private Rectangle getBounds(ViewArea viewArea, int x, int y) {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        switch (x) {
            case 0: {
                bounds.x = this.boundsLeft.x;
                bounds.y = this.boundsLeft.y;
                bounds.width = this.boundsLeft.width;
                break;
            }
            case 1: {
                bounds.x = this.boundsCenter.x;
                bounds.y = this.boundsCenter.y;
                bounds.width = this.boundsCenter.width;
                break;
            }
            case 2: {
                bounds.x = this.boundsRight.x;
                bounds.y = this.boundsRight.y;
                bounds.width = this.boundsRight.width;
            }
        }
        bounds.height = 300;
        return bounds;
    }

    private void cache(ViewArea viewArea, int x, int y, int width, int height, boolean flushCache) {
        try {
            int xLocal;
            int w;
            this.boundsLeft = new Rectangle(x, y, 0, 0);
            this.boundsLeft.width = w = this.computeWidth(viewArea.m_viewStacks[0]);
            this.boundsCenter = new Rectangle(x, y, 0, 0);
            this.boundsCenter.width = w = this.computeWidth(viewArea.m_viewStacks[1]);
            this.boundsRight = new Rectangle(x, y, 0, 0);
            this.boundsRight.width = w = this.computeWidth(viewArea.m_viewStacks[2]);
            Sash leftSash = viewArea.getSash(ViewArea.SashKey.VERTICAL_LEFT);
            Sash rightSash = viewArea.getSash(ViewArea.SashKey.VERTICAL_RIGHT);
            leftSash.setVisible(false);
            rightSash.setVisible(false);
            this.boundsSashLeft = new Rectangle(x, y, 0, 0);
            this.boundsSashRight = new Rectangle(x, y, 0, 0);
            if (this.boundsLeft.width > 0 && this.boundsCenter.width > 0 && this.boundsRight.width > 0) {
                leftSash.setVisible(true);
                rightSash.setVisible(true);
                this.boundsSashLeft.width = SASH_WIDTH;
                this.boundsSashRight.width = SASH_WIDTH;
            } else if (this.boundsLeft.width > 0 && this.boundsCenter.width > 0) {
                leftSash.setVisible(true);
                rightSash.setVisible(false);
                this.boundsSashLeft.width = SASH_WIDTH;
            } else if (this.boundsLeft.width > 0 && this.boundsRight.width > 0) {
                leftSash.setVisible(true);
                rightSash.setVisible(false);
                this.boundsSashLeft.width = SASH_WIDTH;
            } else if (this.boundsCenter.width > 0 && this.boundsRight.width > 0) {
                leftSash.setVisible(false);
                rightSash.setVisible(true);
                this.boundsSashRight.width = SASH_WIDTH;
            }
            int pos = viewArea.getSashPosition(ViewArea.SashKey.VERTICAL_LEFT);
            if (pos > 0) {
                this.boundsLeft.width = pos;
            }
            if ((pos = viewArea.getSashPosition(ViewArea.SashKey.VERTICAL_RIGHT)) > 0 && width > 0 && this.boundsRight.width > 0) {
                this.boundsRight.width = pos;
            }
            int totalSize = this.boundsLeft.width + this.boundsSashLeft.width + this.boundsCenter.width + this.boundsSashRight.width + this.boundsRight.width;
            if (width > 0 && width != totalSize) {
                int[] widths = new int[]{this.boundsLeft.width, this.boundsSashLeft.width, this.boundsCenter.width, this.boundsSashRight.width, this.boundsRight.width};
                int delta = this.adjust(width, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f}, widths, new int[]{-1, -1, -1, -1, -1});
                if (delta != 0) {
                    this.adjust(width, new float[]{(float)this.boundsLeft.width / (float)totalSize, 0.0f, 0.0f, 0.0f, (float)this.boundsRight.width / (float)totalSize}, widths, new int[]{-1, -1, -1, -1, -1});
                }
                this.boundsLeft.width = widths[0];
                this.boundsCenter.width = widths[2];
                this.boundsRight.width = widths[4];
            }
            this.boundsLeft.x = xLocal = x;
            this.boundsSashLeft.x = xLocal += this.boundsLeft.width;
            this.boundsCenter.x = xLocal += this.boundsSashLeft.width;
            this.boundsSashRight.x = xLocal += this.boundsCenter.width;
            this.boundsRight.x = xLocal += this.boundsSashRight.width;
            if (height > 0) {
                this.boundsLeft.height = height;
                this.boundsCenter.height = height;
                this.boundsRight.height = height;
                this.boundsSashLeft.height = height;
                this.boundsSashRight.height = height;
            }
            RwtScoutViewStack[] views = new RwtScoutViewStack[3];
            int i = 0;
            while (i < 3) {
                views[i] = viewArea.m_viewStacks[0][i];
                ++i;
            }
            this.layoutVertical(viewArea, views, this.boundsLeft, ViewArea.SashKey.HORIZONTAL_LEFT_TOP, ViewArea.SashKey.HORIZONTAL_LEFT_BOTTOM);
            views = new RwtScoutViewStack[3];
            i = 0;
            while (i < 3) {
                views[i] = viewArea.m_viewStacks[1][i];
                ++i;
            }
            this.layoutVertical(viewArea, views, this.boundsCenter, ViewArea.SashKey.HORIZONTAL_CENTER_TOP, ViewArea.SashKey.HORIZONTAL_CENTER_BOTTOM);
            views = new RwtScoutViewStack[3];
            i = 0;
            while (i < 3) {
                views[i] = viewArea.m_viewStacks[2][i];
                ++i;
            }
            this.layoutVertical(viewArea, views, this.boundsRight, ViewArea.SashKey.HORIZONTAL_RIGHT_TOP, ViewArea.SashKey.HORIZONTAL_RIGHT_BOTTOM);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutVertical(ViewArea viewArea, RwtScoutViewStack[] views, Rectangle clientArea, ViewArea.SashKey keyTop, ViewArea.SashKey keyBottom) {
        int y;
        Rectangle[] bounds = new Rectangle[3];
        int i = 0;
        while (i < 3) {
            bounds[i] = new Rectangle(clientArea.x, 0, clientArea.width, 0);
            if (views[i].getVisible()) {
                Point size = views[i].computeSize(bounds[i].width, -1);
                bounds[i].height = size.y;
            }
            ++i;
        }
        Rectangle sashTop = new Rectangle(clientArea.x, 0, clientArea.width, 0);
        Rectangle sashBottom = new Rectangle(clientArea.x, 0, clientArea.width, 0);
        int pos = viewArea.getSashPosition(keyTop);
        if (pos > 0 && bounds[0].height > 0) {
            bounds[0].height = pos - clientArea.y;
        }
        if ((pos = viewArea.getSashPosition(keyBottom)) > 0 && bounds[2].height > 0) {
            bounds[2].height = pos - clientArea.y;
        }
        if (bounds[0].height > 0 && bounds[1].height > 0 && bounds[2].height > 0) {
            sashTop.height = SASH_WIDTH;
            sashBottom.height = SASH_WIDTH;
        } else if (bounds[0].height > 0 && bounds[1].height > 0) {
            sashTop.height = SASH_WIDTH;
            sashBottom.height = 0;
        } else if (bounds[0].height > 0 && bounds[2].height > 0) {
            sashTop.height = SASH_WIDTH;
            sashBottom.height = 0;
        } else if (bounds[1].height > 0 && bounds[2].height > 0) {
            sashTop.height = 0;
            sashBottom.height = SASH_WIDTH;
        }
        int totalHeight = bounds[0].height + bounds[1].height + bounds[2].height + sashTop.height + sashBottom.height;
        if (clientArea.height > 0 && totalHeight != clientArea.height) {
            int[] heights = new int[]{bounds[0].height, sashTop.height, bounds[1].height, sashBottom.height, bounds[2].height};
            int[] nArray = new int[5];
            nArray[2] = Integer.MAX_VALUE;
            int delta = this.adjust(clientArea.height, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f}, heights, nArray);
            if (delta != 0) {
                int[] nArray2 = new int[5];
                nArray2[0] = Integer.MAX_VALUE;
                nArray2[4] = Integer.MAX_VALUE;
                this.adjust(clientArea.height, new float[]{(float)bounds[0].height / (float)totalHeight, 0.0f, 0.0f, 0.0f, (float)bounds[2].height / (float)totalHeight}, heights, nArray2);
            }
            bounds[0].height = heights[0];
            bounds[1].height = heights[2];
            bounds[2].height = heights[4];
        }
        bounds[0].y = y = clientArea.y;
        sashTop.y = y += bounds[0].height;
        bounds[1].y = y += sashTop.height;
        sashBottom.y = y += bounds[1].height;
        bounds[2].y = y += sashBottom.height;
        int i2 = 0;
        while (i2 < 3) {
            this.m_bounds.put((Control)views[i2], bounds[i2]);
            ++i2;
        }
        Sash sash = viewArea.getSash(keyTop);
        this.m_bounds.put((Control)sash, sashTop);
        this.m_bounds.put((Control)viewArea.getSash(keyBottom), sashBottom);
    }

    private int adjust(int target, float[] weights, int[] pixels, int[] maxWidth) {
        int i = 0;
        while (i < maxWidth.length) {
            if (maxWidth[i] < 0) {
                maxWidth[i] = Integer.MAX_VALUE;
            }
            ++i;
        }
        int delta = 0;
        int[] nArray = pixels;
        int n = pixels.length;
        int n2 = 0;
        while (n2 < n) {
            int pixel = nArray[n2];
            delta += pixel;
            ++n2;
        }
        delta = target - delta;
        float[] accWeight = new float[weights.length];
        boolean hasTargets = true;
        while (Math.abs(delta) > 0 && hasTargets) {
            hasTargets = false;
            int i2 = 0;
            while (i2 < pixels.length && Math.abs(delta) > 0) {
                if (weights[i2] > 0.0f && pixels[i2] > MIN_SIZE && pixels[i2] < maxWidth[i2]) {
                    hasTargets = true;
                    int n3 = i2;
                    accWeight[n3] = accWeight[n3] + Math.abs(weights[i2]);
                    if (accWeight[i2] >= 1.0f) {
                        int n4 = i2;
                        accWeight[n4] = accWeight[n4] - 1.0f;
                        int n5 = i2;
                        pixels[n5] = pixels[n5] + delta / Math.abs(delta);
                        delta -= delta / Math.abs(delta);
                    }
                }
                ++i2;
            }
        }
        return delta;
    }

    private int computeWidth(RwtScoutViewStack[] views) {
        int w = 0;
        RwtScoutViewStack[] rwtScoutViewStackArray = views;
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            RwtScoutViewStack v = rwtScoutViewStackArray[n2];
            if (v.getVisible()) {
                Point size = v.computeSize(-1, -1);
                w = Math.max(size.x, w);
            }
            ++n2;
        }
        return w;
    }
}

