/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.filedownloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.rap.window.filedownloader.RwtScoutDownloadDialog;
import org.eclipse.swt.widgets.Shell;

public class RwtScoutDownloadHandler
implements IServiceHandler {
    private File m_file;
    private URI m_bundleURI;
    private final String m_fileName;
    private final String m_contentType;
    private final String m_requestId;
    private RwtScoutDownloadDialog m_sdd;

    private RwtScoutDownloadHandler(String id, String contentType, String fileName) {
        this.m_requestId = id;
        this.m_fileName = fileName;
        this.m_contentType = contentType;
        RWT.getServiceManager().registerServiceHandler(this.m_requestId, (IServiceHandler)this);
    }

    public RwtScoutDownloadHandler(String id, File file, String contentType, String fileName) {
        this(id, contentType, fileName);
        this.m_file = file;
    }

    public RwtScoutDownloadHandler(String id, URI bundleURI, String contentType, String fileName) {
        this(id, contentType, fileName);
        this.m_bundleURI = bundleURI;
    }

    public void startDownload(Shell parentShell) {
        this.m_sdd = new RwtScoutDownloadDialog(parentShell, this.getURL());
        this.m_sdd.open();
    }

    public String getURL() {
        StringBuffer url = new StringBuffer();
        url.append(RWT.getRequest().getContextPath());
        url.append(RWT.getRequest().getServletPath());
        url.append("?");
        url.append("custom_service_handler");
        url.append("=");
        url.append(this.m_requestId);
        String encodedURL = RWT.getResponse().encodeURL(url.toString());
        return encodedURL;
    }

    public void service() throws IOException, ServletException {
        HttpServletResponse response = RWT.getResponse();
        if (StringUtility.hasText((String)this.m_contentType)) {
            response.setContentType(this.m_contentType);
        } else {
            response.setContentType("application/octet-stream");
        }
        String contentDisposition = "attachment; filename=\"" + this.m_fileName + "\"";
        response.setHeader("Content-Disposition", contentDisposition);
        ServletOutputStream outStream = response.getOutputStream();
        InputStream srcStream = null;
        if (this.m_file != null) {
            srcStream = new FileInputStream(this.m_file);
            if (this.m_file.length() < Integer.MAX_VALUE) {
                response.setContentLength((int)this.m_file.length());
            }
        } else if (this.m_bundleURI != null) {
            srcStream = this.m_bundleURI.toURL().openStream();
        }
        if (srcStream != null) {
            try {
                try {
                    byte[] content = new byte[1024];
                    int bytesRead = 0;
                    while ((bytesRead = srcStream.read(content)) > 0) {
                        outStream.write(content, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    srcStream.close();
                }
            }
            finally {
                srcStream.close();
            }
        }
    }

    public void dispose() {
        if (this.m_sdd != null) {
            this.m_sdd.close();
        }
        RWT.getServiceManager().unregisterServiceHandler(String.valueOf(this.m_requestId) + this.hashCode());
    }
}

