/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.servlet.http.HttpSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.widgets.JSExecutor;
import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.rwt.service.SessionStoreEvent;
import org.eclipse.rwt.service.SessionStoreListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.ListUtility;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.busy.IBusyHandler;
import org.eclipse.scout.rt.client.busy.IBusyManagerService;
import org.eclipse.scout.rt.client.services.common.exceptionhandler.ErrorHandler;
import org.eclipse.scout.rt.client.services.common.session.IClientSessionRegistryService;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.ui.rap.FormFieldFactory;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironmentListener;
import org.eclipse.scout.rt.ui.rap.LayoutValidateManager;
import org.eclipse.scout.rt.ui.rap.RwtEnvironmentEvent;
import org.eclipse.scout.rt.ui.rap.basic.IRwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.basic.WidgetPrinter;
import org.eclipse.scout.rt.ui.rap.busy.RwtBusyHandler;
import org.eclipse.scout.rt.ui.rap.concurrency.RwtScoutSynchronizer;
import org.eclipse.scout.rt.ui.rap.form.IRwtScoutForm;
import org.eclipse.scout.rt.ui.rap.form.RwtScoutForm;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.keystroke.KeyStrokeManager;
import org.eclipse.scout.rt.ui.rap.util.BrowserInfo;
import org.eclipse.scout.rt.ui.rap.util.ColorFactory;
import org.eclipse.scout.rt.ui.rap.util.DeviceUtility;
import org.eclipse.scout.rt.ui.rap.util.FontRegistry;
import org.eclipse.scout.rt.ui.rap.util.RwtIconLocator;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.util.ScoutFormToolkit;
import org.eclipse.scout.rt.ui.rap.window.BrowserWindowHandler;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.RwtScoutPartEvent;
import org.eclipse.scout.rt.ui.rap.window.RwtScoutPartListener;
import org.eclipse.scout.rt.ui.rap.window.desktop.navigation.RwtScoutNavigationSupport;
import org.eclipse.scout.rt.ui.rap.window.dialog.RwtScoutDialog;
import org.eclipse.scout.rt.ui.rap.window.filechooser.IRwtScoutFileChooser;
import org.eclipse.scout.rt.ui.rap.window.filechooser.IRwtScoutFileChooserService;
import org.eclipse.scout.rt.ui.rap.window.messagebox.RwtScoutMessageBoxDialog;
import org.eclipse.scout.rt.ui.rap.window.popup.RwtScoutPopup;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.Bundle;

public abstract class AbstractRwtEnvironment
implements IRwtEnvironment {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(AbstractRwtEnvironment.class);
    private Subject m_subject;
    private int m_status;
    private Bundle m_applicationBundle;
    private RwtScoutSynchronizer m_synchronizer;
    private SessionStoreListener m_sessionStoreListener;
    private final Object m_immediateUiJobsLock = new Object();
    private final List<Runnable> m_immediateUiJobs = new ArrayList<Runnable>();
    private ColorFactory m_colorFactory;
    private FontRegistry m_fontRegistry;
    private RwtIconLocator m_iconLocator;
    private List<IRwtKeyStroke> m_desktopKeyStrokes;
    private KeyStrokeManager m_keyStrokeManager;
    private Control m_popupOwner;
    private Rectangle m_popupOwnerBounds;
    private ScoutFormToolkit m_formToolkit;
    private FormFieldFactory m_formFieldFactory;
    private boolean m_startDesktopCalled;
    private boolean m_activateDesktopCalled;
    private EventListenerList m_environmentListeners;
    private HashMap<IForm, IRwtScoutPart> m_openForms;
    private P_ScoutDesktopListener m_scoutDesktopListener;
    private P_ScoutDesktopPropertyListener m_desktopPropertyListener;
    private final Class<? extends IClientSession> m_clientSessionClazz;
    private IClientSession m_clientSession;
    private RwtScoutNavigationSupport m_historySupport;
    private LayoutValidateManager m_layoutValidateManager;
    private static final Pattern tableTagPattern = Pattern.compile("<table([^>]*)>", 34);
    private static final Pattern styleAttributePattern = Pattern.compile("style\\s*=\\s*\"([^\"]*)\"", 34);
    private static final Pattern localLinkTagPattern = Pattern.compile("<a (href=\"http://local/[^>]*)>([^>]*)</a>", 34);
    private static Collection<Integer> fKeyList = Arrays.asList(0x100000A, 0x100000B, 0x100000C, 0x100000D, 0x100000E, 0x100000F, 0x1000010, 0x1000011, 0x1000012, 0x1000013, 0x1000014, 0x1000015);

    public AbstractRwtEnvironment(Bundle applicationBundle, Class<? extends IClientSession> clientSessionClazz) {
        this.m_applicationBundle = applicationBundle;
        this.m_clientSessionClazz = clientSessionClazz;
        this.m_sessionStoreListener = new P_SessionStoreListener();
        this.m_environmentListeners = new EventListenerList();
        this.m_openForms = new HashMap();
        this.m_status = 0;
        this.m_desktopKeyStrokes = new ArrayList<IRwtKeyStroke>();
        this.m_startDesktopCalled = false;
    }

    protected void setSubject(Subject subject) {
        this.m_subject = subject;
    }

    public Subject getSubject() {
        return this.m_subject;
    }

    public Bundle getApplicationBundle() {
        return this.m_applicationBundle;
    }

    protected IRwtScoutPart putPart(IForm form, IRwtScoutPart part) {
        return this.m_openForms.put(form, part);
    }

    protected IRwtScoutPart getPart(IForm form) {
        return this.m_openForms.get(form);
    }

    @Override
    public Collection<IRwtScoutPart> getOpenFormParts() {
        return new ArrayList<IRwtScoutPart>(this.m_openForms.values());
    }

    protected IRwtScoutPart removePart(IForm form) {
        return this.m_openForms.remove(form);
    }

    protected void stopScout() throws CoreException {
        try {
            if (this.m_historySupport != null) {
                this.m_historySupport.uninstall();
                this.m_historySupport = null;
            }
            if (this.m_desktopKeyStrokes != null) {
                for (IRwtKeyStroke uiKeyStroke : this.m_desktopKeyStrokes) {
                    this.removeGlobalKeyStroke(uiKeyStroke);
                }
                this.m_desktopKeyStrokes.clear();
            }
            if (this.m_iconLocator != null) {
                this.m_iconLocator.dispose();
                this.m_iconLocator = null;
            }
            if (this.m_colorFactory != null) {
                this.m_colorFactory.dispose();
                this.m_colorFactory = null;
            }
            this.m_keyStrokeManager = null;
            if (this.m_fontRegistry != null) {
                this.m_fontRegistry.dispose();
                this.m_fontRegistry = null;
            }
            if (this.m_formToolkit != null) {
                this.m_formToolkit.dispose();
                this.m_formToolkit = null;
            }
            this.detachScoutListeners();
            if (this.m_synchronizer != null) {
                this.m_synchronizer = null;
            }
            this.m_status = 8;
            this.fireEnvironmentChanged(new RwtEnvironmentEvent(this, 8));
        }
        finally {
            if (this.m_status != 8) {
                this.m_status = 2;
                this.fireEnvironmentChanged(new RwtEnvironmentEvent(this, 2));
            }
        }
    }

    @Override
    public String getLogoutLandingUrl() {
        String defaultUrl = MessageFormat.format("{0}://{1}:{2}{3}/", RWT.getRequest().getScheme(), RWT.getRequest().getLocalName(), Integer.toString(RWT.getRequest().getLocalPort()), RWT.getRequest().getContextPath());
        return defaultUrl;
    }

    public void logout() {
        RWT.getRequest().getSession().setMaxInactiveInterval(1);
        final HttpSession session = RWT.getSessionStore().getHttpSession();
        new Thread(){

            @Override
            public void run() {
                session.invalidate();
            }
        }.start();
        String logoutUrl = this.getLogoutLandingUrl();
        String browserText = MessageFormat.format("parent.window.location.href = \"{0}\";", logoutUrl);
        JSExecutor.executeJS((String)browserText);
    }

    @Override
    public boolean isInitialized() {
        return this.m_status == 2;
    }

    @Override
    public final void ensureInitialized() {
        if (this.m_status == 0 || this.m_status == 8) {
            try {
                this.init();
            }
            catch (Exception e) {
                LOG.error("could not initialize Environment", (Throwable)e);
            }
        }
    }

    protected synchronized void init() throws CoreException {
        if (this.m_status == 1 || this.m_status == 2 || this.m_status == 4) {
            return;
        }
        this.m_status = 0;
        if (Thread.currentThread() != this.getDisplay().getThread()) {
            throw new IllegalStateException("must be called in display thread");
        }
        try {
            this.m_status = 1;
            this.fireEnvironmentChanged(new RwtEnvironmentEvent(this, this.m_status));
            if (this.getSubject() == null) {
                throw new SecurityException("/rap request is not authenticated with a Subject");
            }
            UserAgent userAgent = this.initUserAgent();
            DeviceUtility.setCurrentDeviceType(userAgent.getUiDeviceType());
            final BooleanHolder newSession = new BooleanHolder(Boolean.valueOf(true));
            IClientSession tempClientSession = (IClientSession)RWT.getSessionStore().getAttribute(IClientSession.class.getName());
            if (tempClientSession == null || !tempClientSession.isActive()) {
                LocaleThreadLocal.set((Locale)RwtUtility.getBrowserInfo().getLocale());
                tempClientSession = ((IClientSessionRegistryService)SERVICES.getService(IClientSessionRegistryService.class)).newClientSession(this.m_clientSessionClazz, this.getSubject(), UUID.randomUUID().toString(), userAgent);
                RWT.getSessionStore().setAttribute(IClientSession.class.getName(), (Object)tempClientSession);
                RWT.getSessionStore().addSessionStoreListener(this.m_sessionStoreListener);
                newSession.setValue((Object)true);
            } else {
                newSession.setValue((Object)false);
            }
            if (!tempClientSession.isActive()) {
                this.showClientSessionLoadError(tempClientSession.getLoadError());
                LOG.error("ClientSession is not active, there must be a problem with loading or starting");
                this.m_status = 0;
                return;
            }
            this.m_clientSession = tempClientSession;
            if (this.m_synchronizer == null) {
                this.m_synchronizer = new RwtScoutSynchronizer(this);
            }
            this.m_clientSession.setData("ui.environment", (Object)this);
            RwtUtility.setNlsTextsOnDisplay(this.getDisplay(), this.m_clientSession.getTexts());
            this.m_iconLocator = this.createIconLocator();
            this.m_colorFactory = new ColorFactory(this.getDisplay());
            this.m_keyStrokeManager = new KeyStrokeManager(this);
            this.m_fontRegistry = new FontRegistry(this.getDisplay());
            this.m_historySupport = new RwtScoutNavigationSupport(this);
            this.m_historySupport.install();
            this.m_layoutValidateManager = new LayoutValidateManager();
            this.attachScoutListeners();
            IKeyStroke[] iKeyStrokeArray = this.getClientSession().getDesktop().getKeyStrokes();
            int n = iKeyStrokeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRwtKeyStroke[] uiStrokes;
                IKeyStroke scoutKeyStroke = iKeyStrokeArray[n2];
                IRwtKeyStroke[] iRwtKeyStrokeArray = uiStrokes = RwtUtility.getKeyStrokes(scoutKeyStroke, this);
                int n3 = uiStrokes.length;
                int n4 = 0;
                while (n4 < n3) {
                    IRwtKeyStroke uiStroke = iRwtKeyStrokeArray[n4];
                    this.m_desktopKeyStrokes.add(uiStroke);
                    this.addGlobalKeyStroke(uiStroke, false);
                    ++n4;
                }
                ++n2;
            }
            UICallBack.activate((String)(String.valueOf(AbstractRwtEnvironment.class.getName()) + this.hashCode()));
            new ClientSyncJob("Desktop opened", this.getClientSession()){

                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    if (((Boolean)newSession.getValue()).booleanValue()) {
                        AbstractRwtEnvironment.this.fireDesktopOpenedFromUIInternal();
                        AbstractRwtEnvironment.this.fireGuiAttachedFromUIInternal();
                    } else {
                        AbstractRwtEnvironment.this.fireGuiAttachedFromUIInternal();
                        AbstractRwtEnvironment.this.fireDesktopActivatedFromUIInternal();
                    }
                }
            }.schedule();
            this.m_status = 2;
            this.fireEnvironmentChanged(new RwtEnvironmentEvent(this, this.m_status));
            this.attachBusyHandler(this.m_clientSession);
        }
        finally {
            if (this.m_status == 1) {
                this.m_status = 8;
                this.fireEnvironmentChanged(new RwtEnvironmentEvent(this, this.m_status));
            }
        }
    }

    protected UserAgent initUserAgent() {
        return UserAgent.create((IUiLayer)UiLayer.RAP, (IUiDeviceType)UiDeviceType.DESKTOP, (String)RwtUtility.getBrowserInfo().getUserAgent());
    }

    protected RwtBusyHandler attachBusyHandler(IClientSession session) {
        IBusyManagerService service = (IBusyManagerService)SERVICES.getService(IBusyManagerService.class);
        if (service == null) {
            return null;
        }
        RwtBusyHandler handler = new RwtBusyHandler(session, this);
        service.register(session, (IBusyHandler)handler);
        return handler;
    }

    protected void showClientSessionLoadError(Throwable error) {
        ErrorHandler handler = new ErrorHandler(error);
        MessageBox mbox = new MessageBox(this.getParentShellIgnoringPopups(196608), 32);
        mbox.setText(handler.getTitle());
        mbox.setMessage(StringUtility.join((String)"\n\n", (String[])new String[]{handler.getText(), handler.getDetail()}));
        mbox.open();
    }

    protected void fireDesktopOpenedFromUIInternal() {
        if (this.getScoutDesktop() != null) {
            this.getScoutDesktop().getUIFacade().fireDesktopOpenedFromUI();
        }
    }

    protected void fireGuiAttachedFromUIInternal() {
        if (this.getScoutDesktop() != null) {
            this.getScoutDesktop().getUIFacade().fireGuiAttached();
        }
    }

    protected void fireGuiDetachedFromUIInternal() {
        if (this.getScoutDesktop() != null) {
            this.getScoutDesktop().getUIFacade().fireGuiDetached();
        }
    }

    protected void fireDesktopActivatedFromUIInternal() {
        if (this.getScoutDesktop() != null) {
            this.getScoutDesktop().ensureViewStackVisible();
        }
    }

    @Override
    public void setClipboardText(String text) {
    }

    @Override
    public final void addEnvironmentListener(IRwtEnvironmentListener listener) {
        this.m_environmentListeners.add(IRwtEnvironmentListener.class, (EventListener)listener);
    }

    @Override
    public final void removeEnvironmentListener(IRwtEnvironmentListener listener) {
        this.m_environmentListeners.remove(IRwtEnvironmentListener.class, (EventListener)listener);
    }

    private void fireEnvironmentChanged(RwtEnvironmentEvent event) {
        IRwtEnvironmentListener[] iRwtEnvironmentListenerArray = (IRwtEnvironmentListener[])this.m_environmentListeners.getListeners(IRwtEnvironmentListener.class);
        int n = iRwtEnvironmentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRwtEnvironmentListener l = iRwtEnvironmentListenerArray[n2];
            l.environmentChanged(event);
            ++n2;
        }
    }

    @Override
    public String adaptHtmlCell(IRwtScoutComposite<?> uiComposite, String rawHtml) {
        FontData[] fa;
        int size = 12;
        if (uiComposite.getUiField() != null && (fa = uiComposite.getUiField().getFont().getFontData()) != null && fa.length > 0 && fa[0].getHeight() > 0) {
            size = fa[0].getHeight();
        }
        String stylePrefix = "color:inherit;background-color:inherit;font-size:" + size + "px;";
        rawHtml = this.bugfixStyles(rawHtml, stylePrefix);
        return rawHtml;
    }

    private String bugfixStyles(String html, String stylePrefix) {
        Matcher m = tableTagPattern.matcher(html);
        StringBuilder buf = new StringBuilder();
        int lastPos = 0;
        while (m.find()) {
            buf.append(html.substring(lastPos, m.start()));
            String atts = m.group(1);
            Matcher m2 = styleAttributePattern.matcher(atts);
            if (m2.find()) {
                buf.append(html.substring(m.start(), m.start(1) + m2.start(1)));
                buf.append(stylePrefix);
                buf.append(html.substring(m.start(1) + m2.start(1), m.end()));
            } else {
                buf.append(html.substring(m.start(), m.start(1)));
                buf.append(" style=\"");
                buf.append(stylePrefix);
                buf.append("\" ");
                buf.append(html.substring(m.start(1), m.end()));
            }
            lastPos = m.end();
        }
        if (lastPos < html.length()) {
            buf.append(html.substring(lastPos));
        }
        return buf.toString();
    }

    @Override
    public String convertLinksWithLocalUrlsInHtmlCell(IRwtScoutComposite<?> uiComposite, String rawHtml) {
        Matcher m = localLinkTagPattern.matcher(rawHtml);
        StringBuilder buf = new StringBuilder();
        int lastPos = 0;
        while (m.find()) {
            buf.append(rawHtml.substring(lastPos, m.start()));
            buf.append("<span tabIndex=\"1\" ");
            buf.append("class=\"link\" ");
            buf.append("style=\"");
            buf.append("text-decoration:underline;cursor:pointer;\" ");
            buf.append(rawHtml.substring(m.start(1), m.end(1)));
            buf.append(">");
            buf.append(rawHtml.substring(m.start(2), m.end(2)));
            buf.append("</span>");
            lastPos = m.end();
        }
        if (lastPos < rawHtml.length()) {
            buf.append(rawHtml.substring(lastPos));
        }
        return buf.toString();
    }

    @Override
    public String styleHtmlText(IRwtScoutFormField<?> uiComposite, String rawHtml) {
        if (rawHtml == null) {
            rawHtml = "";
        }
        String cleanHtml = rawHtml;
        if (uiComposite.getScoutObject() instanceof IHtmlField) {
            IHtmlField htmlField = (IHtmlField)uiComposite.getScoutObject();
            if (htmlField.isHtmlEditor()) {
                if (!StringUtility.hasText((String)cleanHtml)) {
                    cleanHtml = "<html><head></head><body></body></html>";
                }
            } else {
                cleanHtml = HTMLUtility.cleanupHtml((String)cleanHtml, (boolean)true, (boolean)false, (HTMLUtility.DefaultFont)this.createDefaultFontSettings(uiComposite));
            }
        }
        return cleanHtml;
    }

    protected HTMLUtility.DefaultFont createDefaultFontSettings(IRwtScoutFormField<?> uiComposite) {
        HTMLUtility.DefaultFont defaultFont = new HTMLUtility.DefaultFont();
        defaultFont.setSize(12);
        defaultFont.setSizeUnit("px");
        defaultFont.setForegroundColor(0);
        defaultFont.setFamilies(new String[]{"sans-serif"});
        if (uiComposite != null && uiComposite.getUiField() != null) {
            Color color;
            FontData[] fontData = uiComposite.getUiField().getFont().getFontData();
            if (fontData == null || fontData.length <= 0) {
                Label label = new Label(uiComposite.getUiContainer(), 0);
                fontData = label.getFont().getFontData();
                label.dispose();
            }
            if (fontData != null && fontData.length > 0) {
                String fontFamily;
                int height = fontData[0].getHeight();
                if (height > 0) {
                    defaultFont.setSize(height);
                }
                if (StringUtility.hasText((String)(fontFamily = fontData[0].getName()))) {
                    defaultFont.setFamilies(new String[]{fontFamily, "sans-serif"});
                }
            }
            if ((color = uiComposite.getUiField().getForeground()) != null) {
                defaultFont.setForegroundColor(color.getRed() * 65536 + color.getGreen() * 256 + color.getBlue());
            }
        }
        return defaultFont;
    }

    @Override
    public Image getIcon(String name) {
        return this.m_iconLocator.getIcon(name);
    }

    @Override
    public ImageDescriptor getImageDescriptor(String iconId) {
        return this.m_iconLocator.getImageDescriptor(iconId);
    }

    @Override
    public Color getColor(String scoutColor) {
        return this.m_colorFactory.getColor(scoutColor);
    }

    @Override
    public Color getColor(RGB rgb) {
        return this.m_colorFactory.getColor(rgb);
    }

    @Override
    public void addGlobalKeyStroke(IRwtKeyStroke stroke, boolean exclusive) {
        boolean internalExclusive = exclusive;
        if (ListUtility.containsAny(fKeyList, (Object[])new Integer[]{stroke.getKeyCode()})) {
            internalExclusive = true;
        }
        this.m_keyStrokeManager.addGlobalKeyStroke(stroke, internalExclusive);
    }

    @Override
    public boolean removeGlobalKeyStroke(IRwtKeyStroke stroke) {
        return this.m_keyStrokeManager.removeGlobalKeyStroke(stroke);
    }

    @Override
    public void addKeyStroke(Control control, IRwtKeyStroke stoke, boolean exclusive) {
        this.m_keyStrokeManager.addKeyStroke(control, stoke, exclusive);
    }

    @Override
    public boolean removeKeyStroke(Control control, IRwtKeyStroke stoke) {
        if (this.m_keyStrokeManager == null) {
            return false;
        }
        return this.m_keyStrokeManager.removeKeyStroke(control, stoke);
    }

    @Override
    public boolean removeKeyStrokes(Control control) {
        if (this.m_keyStrokeManager == null) {
            return false;
        }
        return this.m_keyStrokeManager.removeKeyStrokes(control);
    }

    protected KeyStrokeManager getKeyStrokeManager() {
        return this.m_keyStrokeManager;
    }

    @Override
    public Font getFont(FontSpec scoutFont, Font templateFont) {
        return this.m_fontRegistry.getFont(scoutFont, templateFont);
    }

    @Override
    public Font getFont(Font templateFont, String newName, Integer newStyle, Integer newSize) {
        return this.m_fontRegistry.getFont(templateFont, newName, newStyle, newSize);
    }

    @Override
    public ScoutFormToolkit getFormToolkit() {
        if (this.m_formToolkit == null) {
            this.m_formToolkit = this.createScoutFormToolkit(this.getDisplay());
        }
        return this.m_formToolkit;
    }

    @Override
    public final IDesktop getScoutDesktop() {
        if (this.m_clientSession != null) {
            return this.m_clientSession.getDesktop();
        }
        return null;
    }

    protected void attachScoutListeners() {
        if (this.m_scoutDesktopListener == null) {
            this.m_scoutDesktopListener = new P_ScoutDesktopListener();
            this.getScoutDesktop().addDesktopListener((DesktopListener)this.m_scoutDesktopListener);
        }
        if (this.m_desktopPropertyListener == null) {
            this.m_desktopPropertyListener = new P_ScoutDesktopPropertyListener();
            this.getScoutDesktop().addPropertyChangeListener((PropertyChangeListener)this.m_desktopPropertyListener);
        }
    }

    protected void detachScoutListeners() {
        IDesktop desktop = this.getScoutDesktop();
        if (desktop != null) {
            if (this.m_scoutDesktopListener != null) {
                desktop.removeDesktopListener((DesktopListener)this.m_scoutDesktopListener);
                this.m_scoutDesktopListener = null;
            }
            if (this.m_desktopPropertyListener != null) {
                desktop.removePropertyChangeListener((PropertyChangeListener)this.m_desktopPropertyListener);
                this.m_desktopPropertyListener = null;
            }
        }
    }

    protected void applyScoutState() {
        IMessageBox[] messageBoxes;
        IForm[] dialogs;
        IDesktop desktop = this.getScoutDesktop();
        IForm[] iFormArray = desktop.getViewStack();
        int n = iFormArray.length;
        int n2 = 0;
        while (n2 < n) {
            IForm form = iFormArray[n2];
            if (form.isAutoAddRemoveOnDesktop()) {
                this.showFormPart(form);
            }
            ++n2;
        }
        IForm[] iFormArray2 = dialogs = desktop.getDialogStack();
        int n3 = dialogs.length;
        n = 0;
        while (n < n3) {
            IForm dialog = iFormArray2[n];
            this.showFormPart(dialog);
            ++n;
        }
        IMessageBox[] iMessageBoxArray = messageBoxes = desktop.getMessageBoxStack();
        int n4 = messageBoxes.length;
        n3 = 0;
        while (n3 < n4) {
            IMessageBox messageBoxe = iMessageBoxArray[n3];
            this.showMessageBoxFromScout(messageBoxe);
            ++n3;
        }
    }

    public IFormField findFocusOwnerField() {
        Control comp = this.getDisplay().getFocusControl();
        while (comp != null) {
            Object o = comp.getData("org.eclipse.scout.rt.object");
            if (o instanceof IFormField) {
                return (IFormField)o;
            }
            comp = comp.getParent();
        }
        return null;
    }

    @Override
    public void showFileChooserFromScout(IFileChooser fileChooser) {
        IRwtScoutFileChooserService rwtScoutFileChooserService = (IRwtScoutFileChooserService)SERVICES.getService(IRwtScoutFileChooserService.class);
        if (rwtScoutFileChooserService == null) {
            LOG.warn("Missing bundle: org.eclipse.scout.rt.ui.rap.incubator.filechooser. Please activate it in your Scout perspective under Technologies.");
            return;
        }
        IRwtScoutFileChooser sfc = rwtScoutFileChooserService.createFileChooser(this.getParentShellIgnoringPopups(196608), fileChooser);
        sfc.showFileChooser();
    }

    @Override
    public void openBrowserWindowFromScout(String path) {
        BrowserWindowHandler browserWindowHandler = this.createBrowserWindowHandler();
        if (browserWindowHandler == null) {
            return;
        }
        browserWindowHandler.openLink(path);
    }

    protected BrowserWindowHandler createBrowserWindowHandler() {
        return new BrowserWindowHandler();
    }

    @Override
    public void showMessageBoxFromScout(IMessageBox messageBox) {
        if (!messageBox.isOpen()) {
            return;
        }
        RwtScoutMessageBoxDialog box = new RwtScoutMessageBoxDialog(this.getParentShellIgnoringPopups(196608), messageBox, this);
        box.open();
    }

    @Override
    public void ensureFormPartVisible(IForm form) {
        IRwtScoutPart part = this.getPart(form);
        if (part != null) {
            part.activate();
        } else {
            this.showFormPart(form);
        }
    }

    protected IRwtScoutPart createUiScoutDialog(IForm form, Shell shell, int dialogStyle) {
        RwtScoutDialog ui = new RwtScoutDialog();
        ui.createPart(form, shell, dialogStyle, this);
        return ui;
    }

    protected IRwtScoutPart createUiScoutPopupDialog(IForm form, Shell shell, int dialogStyle) {
        Control owner = this.getPopupOwner();
        if (owner == null) {
            owner = this.getDisplay().getFocusControl();
        }
        if (owner == null) {
            return null;
        }
        Rectangle ownerBounds = this.getPopupOwnerBounds();
        if (ownerBounds == null) {
            ownerBounds = owner.getBounds();
            Point pDisp = owner.toDisplay(0, 0);
            ownerBounds.x = pDisp.x;
            ownerBounds.y = pDisp.y;
        }
        RwtScoutDialog dialog = new RwtScoutDialog();
        dialog.createPart(form, shell, dialogStyle, this);
        dialog.setUiInitialLocation(new Point(ownerBounds.x, ownerBounds.y + ownerBounds.height));
        return dialog;
    }

    protected IRwtScoutPart createUiScoutPopupWindow(IForm f) {
        Control owner = this.getPopupOwner();
        if (owner == null) {
            owner = this.getDisplay().getFocusControl();
        }
        if (owner == null) {
            return null;
        }
        Rectangle ownerBounds = this.getPopupOwnerBounds();
        if (ownerBounds == null) {
            ownerBounds = owner.getBounds();
            Point pDisp = owner.toDisplay(0, 0);
            ownerBounds.x = pDisp.x;
            ownerBounds.y = pDisp.y;
        }
        final RwtScoutPopup popup = new RwtScoutPopup();
        popup.setMaxHeightHint(280);
        popup.createPart(f, owner, ownerBounds, 16, this);
        popup.addRwtScoutPartListener(new RwtScoutPartListener(){

            @Override
            public void partChanged(RwtScoutPartEvent e) {
                switch (e.getType()) {
                    case 50: {
                        popup.closePart();
                        break;
                    }
                    case 40: {
                        popup.closePart();
                    }
                }
            }
        });
        owner.getShell().addShellListener((ShellListener)new ShellAdapter(){
            private static final long serialVersionUID = 1L;

            public void shellClosed(ShellEvent e) {
                ((Shell)e.getSource()).removeShellListener((ShellListener)this);
                popup.closePart();
            }

            public void shellActivated(ShellEvent e) {
                ((Shell)e.getSource()).removeShellListener((ShellListener)this);
                popup.closePart();
            }
        });
        return popup;
    }

    @Override
    public Control getPopupOwner() {
        return this.m_popupOwner;
    }

    @Override
    public Rectangle getPopupOwnerBounds() {
        return this.m_popupOwnerBounds != null ? new Rectangle(this.m_popupOwnerBounds.x, this.m_popupOwnerBounds.y, this.m_popupOwnerBounds.width, this.m_popupOwnerBounds.height) : null;
    }

    @Override
    public void setPopupOwner(Control owner, Rectangle ownerBounds) {
        this.m_popupOwner = owner;
        this.m_popupOwnerBounds = ownerBounds;
    }

    @Override
    public void showFormPart(IForm form) {
        if (form == null) {
            return;
        }
        IRwtScoutPart part = this.getPart(form);
        if (part != null) {
            return;
        }
        switch (form.getDisplayHint()) {
            case 0: {
                Shell parentShell = form.isModal() ? this.getParentShellIgnoringPopups(196608) : this.getParentShellIgnoringPopups(0);
                int dialogStyle = 0x870 | (form.isModal() ? 65536 : 128);
                part = this.createUiScoutDialog(form, parentShell, dialogStyle);
                break;
            }
            case 12: {
                Shell parentShell = form.isModal() ? this.getParentShellIgnoringPopups(196608) : this.getParentShellIgnoringPopups(0);
                int dialogStyle = 0x870 | (form.isModal() ? 65536 : 128);
                part = this.createUiScoutPopupDialog(form, parentShell, dialogStyle);
                if (part != null) break;
                LOG.error("showing popup for " + form + ", but there is neither a focus owner nor the property 'IRwtEnvironment.getPopupOwner()'");
                break;
            }
            case 20: {
                break;
            }
            case 10: {
                part = this.createUiScoutPopupWindow(form);
                if (part != null) break;
                LOG.error("showing popup for " + form + ", but there is neither a focus owner nor the property 'IRwtEnvironment.getPopupOwner()'");
            }
        }
        if (part != null) {
            try {
                this.putPart(form, part);
                part.showPart();
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
            }
        }
    }

    @Override
    public void hideFormPart(IForm form) {
        if (form == null) {
            return;
        }
        IRwtScoutPart part = this.removePart(form);
        if (part != null) {
            part.closePart();
        }
    }

    protected void handleDesktopPropertyChanged(String propertyName, Object oldVal, Object newValue) {
        if ("status".equals(propertyName)) {
            this.setStatusFromScout();
        }
    }

    protected void setStatusFromScout() {
        if (this.getScoutDesktop() == null) {
            return;
        }
        IProcessingStatus newValue = this.getScoutDesktop().getStatus();
        Object trayItem = null;
        if (trayItem != null) {
            // empty if block
        }
        String message = null;
        if (newValue != null) {
            message = newValue.getMessage();
        }
        this.setStatusLineMessage(null, message);
    }

    public void setStatusLineMessage(Image image, String message) {
        for (IRwtScoutPart part : this.m_openForms.values()) {
            if (!part.setStatusLineMessage(image, message)) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postImmediateUiJob(Runnable r) {
        Object object = this.m_immediateUiJobsLock;
        synchronized (object) {
            this.m_immediateUiJobs.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchImmediateUiJobs() {
        ArrayList<Runnable> list;
        Object object = this.m_immediateUiJobsLock;
        synchronized (object) {
            list = new ArrayList<Runnable>(this.m_immediateUiJobs);
            this.m_immediateUiJobs.clear();
        }
        for (Runnable r : list) {
            try {
                r.run();
            }
            catch (Throwable t) {
                LOG.warn("running " + r, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobEx invokeScoutLater(Runnable job, long cancelTimeout) {
        Object object = this.m_immediateUiJobsLock;
        synchronized (object) {
            this.m_immediateUiJobs.clear();
        }
        if (this.m_synchronizer != null) {
            return this.m_synchronizer.invokeScoutLater(job, cancelTimeout);
        }
        LOG.warn("synchronizer is null; session is closed");
        return null;
    }

    @Override
    public void invokeUiLater(Runnable job) {
        if (this.m_synchronizer != null) {
            this.m_synchronizer.invokeUiLater(job);
        } else {
            LOG.warn("synchronizer is null; session is closed");
        }
    }

    @Override
    public Shell getParentShellIgnoringPopups(int modalities) {
        return RwtUtility.getParentShellIgnoringPopups(modalities);
    }

    @Override
    public IClientSession getClientSession() {
        return this.m_clientSession;
    }

    @Override
    public LayoutValidateManager getLayoutValidateManager() {
        return this.m_layoutValidateManager;
    }

    protected RwtIconLocator createIconLocator() {
        return new RwtIconLocator(this.getClientSession().getIconLocator());
    }

    protected ScoutFormToolkit createScoutFormToolkit(Display display) {
        return new ScoutFormToolkit(new FormToolkit(display){

            public Form createForm(Composite parent) {
                Form f = super.createForm(parent);
                this.decorateFormHeading(f);
                return f;
            }
        });
    }

    @Override
    public IRwtScoutForm createForm(Composite parent, IForm scoutForm) {
        RwtScoutForm uiForm = new RwtScoutForm();
        uiForm.createUiField(parent, scoutForm, this);
        return uiForm;
    }

    @Override
    public IRwtScoutFormField createFormField(Composite parent, IFormField model) {
        if (this.m_formFieldFactory == null) {
            this.m_formFieldFactory = new FormFieldFactory(this.getApplicationBundle());
        }
        IRwtScoutFormField<IFormField> uiField = this.m_formFieldFactory.createUiFormField(parent, model, this);
        return uiField;
    }

    @Override
    public void checkThread() {
        if (this.getDisplay().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Must be called in rwt thread");
        }
    }

    protected void handleScoutPrintInRwt(DesktopEvent e) {
        WidgetPrinter wp = new WidgetPrinter((Control)this.getParentShellIgnoringPopups(196608));
        try {
            wp.print(e.getPrintDevice(), e.getPrintParameters());
        }
        catch (Throwable ex) {
            LOG.error(null, ex);
        }
    }

    protected String getDesktopOpenedTaskText() {
        return RwtUtility.getNlsText(Display.getCurrent(), "ScoutStarting", new String[0]);
    }

    protected String getDesktopClosedTaskText() {
        return RwtUtility.getNlsText(Display.getCurrent(), "ScoutStoping", new String[0]);
    }

    protected boolean isStartDesktopCalled() {
        return this.m_startDesktopCalled;
    }

    protected void setStartDesktopCalled(boolean startDesktopCalled) {
        this.m_startDesktopCalled = startDesktopCalled;
    }

    protected boolean isActivateDesktopCalled() {
        return this.m_activateDesktopCalled;
    }

    protected void setActivateDesktopCalled(boolean activateDesktopCalled) {
        this.m_activateDesktopCalled = activateDesktopCalled;
    }

    private class P_ScoutDesktopListener
    implements DesktopListener {
        private P_ScoutDesktopListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void desktopChanged(final DesktopEvent e) {
            if (AbstractRwtEnvironment.this.getDisplay().isDisposed()) {
                return;
            }
            switch (e.getType()) {
                case 600: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractRwtEnvironment.this.showFormPart(e.getForm());
                            AbstractRwtEnvironment.this.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    UICallBack.deactivate((String)(String.valueOf(AbstractRwtEnvironment.class.getName()) + AbstractRwtEnvironment.this.hashCode()));
                                }
                            });
                        }
                    };
                    AbstractRwtEnvironment.this.invokeUiLater(t);
                    break;
                }
                case 610: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractRwtEnvironment.this.hideFormPart(e.getForm());
                        }
                    };
                    AbstractRwtEnvironment.this.invokeUiLater(t);
                    break;
                }
                case 620: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractRwtEnvironment.this.ensureFormPartVisible(e.getForm());
                            AbstractRwtEnvironment.this.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    UICallBack.deactivate((String)(String.valueOf(AbstractRwtEnvironment.class.getName()) + AbstractRwtEnvironment.this.hashCode()));
                                }
                            });
                        }
                    };
                    AbstractRwtEnvironment.this.invokeUiLater(t);
                    break;
                }
                case 700: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractRwtEnvironment.this.showMessageBoxFromScout(e.getMessageBox());
                        }
                    };
                    AbstractRwtEnvironment.this.invokeUiLater(t);
                    break;
                }
                case 910: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractRwtEnvironment.this.showFileChooserFromScout(e.getFileChooser());
                        }
                    };
                    AbstractRwtEnvironment.this.invokeUiLater(t);
                    break;
                }
                case 920: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractRwtEnvironment.this.openBrowserWindowFromScout(e.getPath());
                        }
                    };
                    AbstractRwtEnvironment.this.invokeUiLater(t);
                    break;
                }
                case 100: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AbstractRwtEnvironment.this.stopScout();
                            }
                            catch (CoreException ex) {
                                LOG.error("desktop closed", (Throwable)ex);
                            }
                            AbstractRwtEnvironment.this.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractRwtEnvironment.this.logout();
                                }
                            });
                        }
                    };
                    AbstractRwtEnvironment.this.invokeUiLater(t);
                    break;
                }
                case 900: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractRwtEnvironment.this.handleScoutPrintInRwt(e);
                        }
                    };
                    AbstractRwtEnvironment.this.invokeUiLater(t);
                    break;
                }
                case 1000: {
                    final Object lock = new Object();
                    Runnable t = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                IFormField f = AbstractRwtEnvironment.this.findFocusOwnerField();
                                if (f != null) {
                                    e.setFocusedField(f);
                                }
                            }
                            catch (Throwable throwable) {
                                Object object = lock;
                                synchronized (object) {
                                    lock.notifyAll();
                                }
                                throw throwable;
                            }
                            Object object = lock;
                            synchronized (object) {
                                lock.notifyAll();
                            }
                        }
                    };
                    Object object = lock;
                    synchronized (object) {
                        AbstractRwtEnvironment.this.invokeUiLater(t);
                        try {
                            lock.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        break;
                    }
                }
            }
        }
    }

    private class P_ScoutDesktopPropertyListener
    implements PropertyChangeListener {
        private P_ScoutDesktopPropertyListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if (!AbstractRwtEnvironment.this.getDisplay().isDisposed()) {
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        AbstractRwtEnvironment.this.handleDesktopPropertyChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                    }
                };
                AbstractRwtEnvironment.this.invokeUiLater(job);
            }
        }
    }

    private static final class P_SessionStoreListener
    implements SessionStoreListener {
        private static final long serialVersionUID = 1L;

        private P_SessionStoreListener() {
        }

        public void beforeDestroy(SessionStoreEvent event) {
            ISessionStore sessionStore = event.getSessionStore();
            String userAgent = "";
            BrowserInfo browserInfo = (BrowserInfo)sessionStore.getAttribute("browser-Info");
            if (browserInfo != null) {
                userAgent = browserInfo.getUserAgent();
            }
            String msg = "Thread: {0} Session goes down...; UserAgent: {2}";
            LOG.warn(msg, new Object[]{Thread.currentThread().getId(), userAgent});
            IClientSession clientSession = (IClientSession)sessionStore.getAttribute(IClientSession.class.getName());
            if (clientSession != null) {
                new ClientAsyncJob("HTTP session inactivator", clientSession){

                    protected void runVoid(IProgressMonitor monitor) throws Throwable {
                        this.getClientSession().stopSession();
                    }
                }.runNow((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

