/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Locale;
import javax.security.auth.Subject;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.rwt.service.SettingStoreException;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.AbstractRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.IRwtStandaloneEnvironment;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.desktop.RwtScoutDesktop;
import org.eclipse.scout.rt.ui.rap.window.desktop.nonmodalFormBar.RwtScoutFormButtonBar;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public abstract class AbstractStandaloneRwtEnvironment
extends AbstractRwtEnvironment
implements IRwtStandaloneEnvironment {
    private Display m_display;
    private RwtScoutDesktop m_uiDesktop;
    private RwtScoutFormButtonBar m_uiButtonArea;

    public AbstractStandaloneRwtEnvironment(Bundle applicationBundle, Class<? extends IClientSession> clientSessionClazz) {
        super(applicationBundle, clientSessionClazz);
    }

    public int createUI() {
        if (this.getSubject() == null) {
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject == null) {
                throw new SecurityException("/rap request is not authenticated with a Subject");
            }
            this.setSubject(subject);
        }
        if (RwtUtility.getBrowserInfo().isDesktop()) {
            UICallBack.activate((String)(String.valueOf(this.getClass().getName()) + this.getClass().hashCode()));
        }
        this.m_display = Display.getDefault();
        if (this.m_display == null) {
            this.m_display = new Display();
        }
        this.m_display.setData(IRwtEnvironment.class.getName(), (Object)this);
        try {
            final IWorkbench wb = PlatformUI.getWorkbench();
            final Field f = wb.getClass().getDeclaredField("display");
            f.setAccessible(true);
            f.set(wb, this.m_display);
            this.m_display.addListener(12, new Listener(){
                private static final long serialVersionUID = 1L;

                public void handleEvent(Event event) {
                    try {
                        f.set(wb, null);
                    }
                    catch (Throwable throwable) {}
                }
            });
        }
        catch (Throwable throwable) {}
        try {
            RWT.getSettingStore().setAttribute("SessionID", RWT.getRequest().getSession().getId());
        }
        catch (SettingStoreException settingStoreException) {}
        Shell shell = new Shell(this.m_display, 8);
        this.createApplicationContent((Composite)shell);
        this.createNonmodalFormButtonArea((Composite)shell);
        GridLayout shellLayout = new GridLayout(1, true);
        shellLayout.horizontalSpacing = 0;
        shellLayout.marginHeight = 0;
        shellLayout.marginWidth = 0;
        shellLayout.verticalSpacing = 0;
        shell.setLayout((Layout)shellLayout);
        GridData desktopLayoutData = new GridData(4, 4, true, true);
        this.m_uiDesktop.getUiContainer().setLayoutData((Object)desktopLayoutData);
        GridData nonmodalFormsLayoutData = new GridData(4, 4, true, false);
        nonmodalFormsLayoutData.exclude = true;
        this.m_uiButtonArea.getUiContainer().setLayoutData((Object)nonmodalFormsLayoutData);
        shell.setMaximized(true);
        shell.open();
        shell.layout(true, true);
        shell.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent event) {
                String sessionID = RWT.getSettingStore().getAttribute("SessionID");
                if (StringUtility.isNullOrEmpty((String)sessionID) || !sessionID.equals(RWT.getRequest().getSession().getId())) {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            AbstractStandaloneRwtEnvironment.this.getScoutDesktop().getUIFacade().fireGuiDetached();
                            AbstractStandaloneRwtEnvironment.this.getScoutDesktop().getUIFacade().fireDesktopClosingFromUI();
                        }
                    };
                    AbstractStandaloneRwtEnvironment.this.invokeScoutLater(t, 0L);
                }
            }
        });
        while (!shell.isDisposed()) {
            if (this.getClientSession() != null) {
                LocaleThreadLocal.set((Locale)this.getClientSession().getLocale());
            }
            if (this.m_display.readAndDispatch()) continue;
            this.m_display.sleep();
        }
        this.m_display.dispose();
        return 0;
    }

    protected void createApplicationContent(Composite parent) {
        this.m_uiDesktop = this.createUiDesktop();
        this.ensureInitialized();
        if (!this.isInitialized()) {
            throw new SecurityException("Cannot initialize application");
        }
        this.getKeyStrokeManager().setGlobalKeyStrokesActivated(true);
        this.m_uiDesktop.createUiField(parent, this.getScoutDesktop(), this);
    }

    protected void createNonmodalFormButtonArea(Composite parent) {
        this.m_uiButtonArea = new RwtScoutFormButtonBar();
        this.m_uiButtonArea.createUiField(parent, (IDesktop)this.m_uiDesktop.getScoutObject(), this);
    }

    protected RwtScoutDesktop createUiDesktop() {
        return new RwtScoutDesktop();
    }

    @Override
    public RwtScoutDesktop getUiDesktop() {
        return this.m_uiDesktop;
    }

    @Override
    public Display getDisplay() {
        Display current = null;
        try {
            current = Display.getCurrent();
        }
        catch (Exception exception) {}
        if (current != null && this.m_display != current) {
            ScoutLogManager.getLogger(AbstractStandaloneRwtEnvironment.class).error("Different Display.\nm_display: {0}\ncur_displ: {1}", new Object[]{this.m_display, current});
        }
        Display defdisp = null;
        try {
            defdisp = Display.getDefault();
        }
        catch (Exception exception) {}
        if (defdisp != null && this.m_display != defdisp) {
            ScoutLogManager.getLogger(AbstractStandaloneRwtEnvironment.class).error("Different Display.\nm_display: {0}\ndefdisp  : {1}", new Object[]{this.m_display, defdisp});
        }
        return this.m_display;
    }

    @Override
    public void showFormPart(IForm form) {
        if (form == null) {
            return;
        }
        if (form.getDisplayHint() == 20) {
            IRwtScoutPart part = this.m_uiDesktop.addForm(form);
            this.putPart(form, part);
            part.showPart();
        }
        super.showFormPart(form);
        if (form.getDisplayHint() == 0 && !form.isModal()) {
            int buttonCount = this.m_uiButtonArea.getFormButtonBarCount();
            this.m_uiButtonArea.addFormButton(form);
            if (buttonCount != this.m_uiButtonArea.getFormButtonBarCount()) {
                this.m_uiButtonArea.getUiContainer().setVisible(true);
                ((GridData)this.m_uiButtonArea.getUiContainer().getLayoutData()).exclude = false;
                this.m_uiButtonArea.getUiContainer().getParent().layout(true, true);
            }
        }
    }

    @Override
    public void hideFormPart(IForm form) {
        super.hideFormPart(form);
        if (form.getDisplayHint() == 0 && !form.isModal()) {
            this.m_uiButtonArea.removeFormButton(form);
            if (this.m_uiButtonArea.getFormButtonBarCount() == 0) {
                this.m_uiButtonArea.getUiContainer().setVisible(false);
                ((GridData)this.m_uiButtonArea.getUiContainer().getLayoutData()).exclude = true;
                this.m_uiButtonArea.getUiContainer().getParent().layout(true, true);
            }
        }
    }
}

