/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.comp;

import org.eclipse.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class CLabelEx
extends CLabel {
    private static final long serialVersionUID = 1L;
    private static final int DRAW_FLAGS = 7;
    private static final String ELLIPSIS = "...";
    private boolean m_isFieldRangeLabel = false;
    private String m_originalText = "";

    public CLabelEx(Composite parent, int style) {
        super(parent, style | 0x80000);
    }

    public boolean isFieldRangeLabel() {
        return this.m_isFieldRangeLabel;
    }

    public void setFieldRangeLabel(boolean isFieldRangeLabel) {
        this.m_isFieldRangeLabel = isFieldRangeLabel;
    }

    public void setText(String text) {
        super.setText(text);
        this.m_originalText = text;
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        if (bounds.width > 0) {
            this.updateText(bounds.width);
        }
    }

    public void setSize(Point size) {
        super.setSize(size);
        if (size.x > 0) {
            this.updateText(size.x);
        }
    }

    private void updateText(int labelWidth) {
        Image image = this.getImage();
        int availableWidth = Math.max(0, labelWidth - (this.getLeftMargin() + this.getRightMargin()));
        Point extent = TextSizeUtil.stringExtent((Font)this.getFont(), (String)this.m_originalText);
        int imageWidth = 0;
        if (image != null) {
            Rectangle r = image.getBounds();
            imageWidth = r.width;
        }
        if (extent.x > availableWidth - imageWidth) {
            this.setImage(null);
            if (extent.x > availableWidth) {
                super.setText(this.shortenText(null, this.m_originalText, availableWidth));
                this.setToolTipText(this.m_originalText);
            } else {
                this.setToolTipText("");
            }
        }
    }

    public String shortenText(Object gc, String t, int width) {
        if (t == null) {
            return null;
        }
        String text = t;
        String rangeWord = "";
        if (this.m_isFieldRangeLabel) {
            text = t.substring(0, t.lastIndexOf(32));
            rangeWord = t.substring(t.lastIndexOf(32));
        }
        int textWidth = TextSizeUtil.stringExtent((Font)this.getFont(), (String)ELLIPSIS).x;
        int rangeWidth = TextSizeUtil.stringExtent((Font)this.getFont(), (String)rangeWord).x;
        int s = text.length();
        while (s >= 0) {
            String s1 = t.substring(0, s);
            int l1 = TextSizeUtil.stringExtent((Font)this.getFont(), (String)s1).x;
            if (l1 + textWidth + rangeWidth < width) {
                t = String.valueOf(s1) + ELLIPSIS + rangeWord;
                break;
            }
            --s;
        }
        return t;
    }
}

