/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.tree;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class RwtScoutTreeModel
extends LabelProvider
implements ITreeContentProvider,
IFontProvider,
IColorProvider {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutTreeModel.class);
    private final ITree m_tree;
    private final IRwtEnvironment m_uiEnvironment;
    private final TreeViewer m_treeViewer;
    private Image m_imgCheckboxTrue;
    private Image m_imgCheckboxFalse;
    private Color m_disabledForegroundColor;

    public RwtScoutTreeModel(ITree tree, IRwtEnvironment uiEnvironment, TreeViewer treeViewer) {
        this.m_tree = tree;
        this.m_uiEnvironment = uiEnvironment;
        this.m_treeViewer = treeViewer;
        this.m_imgCheckboxTrue = this.getUiEnvironment().getIcon("checkbox_yes");
        this.m_imgCheckboxFalse = this.getUiEnvironment().getIcon("checkbox_no");
        this.m_disabledForegroundColor = this.getUiEnvironment().getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
    }

    private IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    public Object[] getChildren(Object parentElement) {
        ITreeNode scoutNode = (ITreeNode)parentElement;
        return scoutNode.getFilteredChildNodes();
    }

    public Object getParent(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        return scoutNode.getParentNode();
    }

    public boolean hasChildren(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        return !scoutNode.isLeaf();
    }

    public Object[] getElements(Object inputElement) {
        if (this.m_tree != null) {
            if (this.m_tree.isRootNodeVisible()) {
                return new Object[]{this.m_tree.getRootNode()};
            }
            return this.m_tree.getRootNode().getFilteredChildNodes();
        }
        return new Object[0];
    }

    public Image getImage(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode == null) {
            return null;
        }
        Image checkBoxImage = null;
        if (this.m_tree.isCheckable()) {
            checkBoxImage = scoutNode.isChecked() ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
        }
        String iconId = scoutNode.getCell().getIconId();
        Image decoImage = null;
        decoImage = this.getUiEnvironment().getIcon(iconId);
        if (checkBoxImage != null && decoImage != null) {
            return checkBoxImage;
        }
        if (checkBoxImage != null) {
            return checkBoxImage;
        }
        if (decoImage != null) {
            return decoImage;
        }
        return null;
    }

    public String getText(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        return scoutNode.getCell().getText();
    }

    public Font getFont(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode.getCell().getFont() != null) {
            return this.getUiEnvironment().getFont(scoutNode.getCell().getFont(), this.m_treeViewer.getTree().getFont());
        }
        return null;
    }

    public Color getForeground(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        ICell scoutCell = scoutNode.getCell();
        Color col = this.getUiEnvironment().getColor(scoutCell.getForegroundColor());
        if (col == null && !scoutCell.isEnabled()) {
            col = this.m_disabledForegroundColor;
        }
        return col;
    }

    public Color getBackground(Object element) {
        ITreeNode scoutNode = (ITreeNode)element;
        if (scoutNode.getCell().getBackgroundColor() != null) {
            return this.getUiEnvironment().getColor(scoutNode.getCell().getBackgroundColor());
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

