/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext;

import java.util.ArrayList;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class ButtonEx
extends Button {
    private static final long serialVersionUID = 1L;
    public static final int SELECTION_ACTION = 44;
    public static final int SELECTION_MENU = 45;
    private boolean m_hasDropDown;
    private boolean m_dropDownEnabled;
    private Object m_listenerLock = new Object();
    private Listener[] m_actionSelectionListener;
    private Listener[] m_menuSelectionListener;

    public ButtonEx(Composite parent, int style) {
        super(parent, style);
        P_DelegateSelectionListener delegateListener = new P_DelegateSelectionListener();
        if ((style & 4) != 0) {
            this.m_hasDropDown = true;
            super.addListener(4, (Listener)delegateListener);
        }
        super.addListener(13, (Listener)delegateListener);
    }

    private IRwtEnvironment getUiEnvironment() {
        return (IRwtEnvironment)this.getDisplay().getData(IRwtEnvironment.class.getName());
    }

    public void addListener(int eventType, Listener listener) {
        switch (eventType) {
            case 44: {
                this.m_actionSelectionListener = this.addListenerToList(listener, this.m_actionSelectionListener);
                break;
            }
            case 45: {
                this.m_menuSelectionListener = this.addListenerToList(listener, this.m_menuSelectionListener);
                break;
            }
            default: {
                super.addListener(eventType, listener);
            }
        }
    }

    public void removeListener(int eventType, Listener listener) {
        switch (eventType) {
            case 44: {
                this.m_actionSelectionListener = this.removeListenerFromList(listener, this.m_actionSelectionListener);
                break;
            }
            case 45: {
                this.m_menuSelectionListener = this.removeListenerFromList(listener, this.m_menuSelectionListener);
                break;
            }
            default: {
                super.removeListener(eventType, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Listener[] addListenerToList(Listener l, Listener[] arr) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (arr == null) {
                arr = new Listener[]{l};
            } else {
                Listener[] newArr = new Listener[arr.length + 1];
                System.arraycopy(arr, 0, newArr, 0, arr.length);
                arr = newArr;
                arr[arr.length - 1] = l;
            }
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Listener[] removeListenerFromList(Listener l, Listener[] arr) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (arr == null) {
                return arr;
            }
            ArrayList<Listener> newList = new ArrayList<Listener>();
            Listener[] listenerArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                Listener ref = listenerArray[n2];
                if (!ref.equals(l)) {
                    newList.add(ref);
                }
                ++n2;
            }
            arr = newList.toArray(new Listener[newList.size()]);
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMenuSelection(Event e) {
        int backupedType = e.type;
        try {
            e.type = 45;
            Object object = this.m_listenerLock;
            synchronized (object) {
                if (this.m_menuSelectionListener != null) {
                    Listener[] listenerArray = this.m_menuSelectionListener;
                    int n = this.m_menuSelectionListener.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Listener l = listenerArray[n2];
                        l.handleEvent(e);
                        ++n2;
                    }
                }
            }
        }
        finally {
            e.type = backupedType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionSelection(Event e) {
        if (this.m_actionSelectionListener != null) {
            int backupedType = e.type;
            try {
                e.type = 44;
                Object object = this.m_listenerLock;
                synchronized (object) {
                    Listener[] listenerArray = this.m_actionSelectionListener;
                    int n = this.m_actionSelectionListener.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Listener l = listenerArray[n2];
                        l.handleEvent(e);
                        ++n2;
                    }
                }
            }
            finally {
                e.type = backupedType;
            }
        }
    }

    public void setDropDownEnabled(boolean enabled) {
        this.m_dropDownEnabled = enabled;
    }

    public boolean isDropDownEnabled() {
        return this.m_dropDownEnabled;
    }

    protected void checkSubclass() {
    }

    protected void handleButtonSelection(Event event) {
        this.fireActionSelection(event);
    }

    protected void handlePopupSelectionEvent(Event e) {
        Menu menu;
        if (this.m_dropDownEnabled && (menu = this.getMenu()) != null) {
            menu.setVisible(true);
        }
        this.fireMenuSelection(e);
    }

    private class P_DelegateSelectionListener
    implements Listener {
        private static final long serialVersionUID = 1L;
        private long timeLastEvent = 0L;

        private P_DelegateSelectionListener() {
        }

        public void handleEvent(Event event) {
            block0 : switch (event.type) {
                case 4: {
                    if (this.timeLastEvent != 0L && this.timeLastEvent == (long)event.time) {
                        return;
                    }
                    this.timeLastEvent = event.time;
                    switch (event.button) {
                        case 1: {
                            if (event.x > ButtonEx.this.getBounds().width - 12) {
                                ButtonEx.this.handlePopupSelectionEvent(event);
                                break block0;
                            }
                            ButtonEx.this.handleButtonSelection(event);
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                    break;
                }
                case 13: {
                    if (this.timeLastEvent != 0L && this.timeLastEvent == (long)event.time) {
                        return;
                    }
                    this.timeLastEvent = event.time;
                    ButtonEx.this.handleButtonSelection(event);
                    break;
                }
            }
        }
    }
}

