/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext;

import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class MenuAdapterEx
extends MenuAdapter {
    private static final long serialVersionUID = 1L;
    private final Control m_menuControl;
    private final Control m_keyStrokeWidget;

    public MenuAdapterEx(Control menuControl, Control keyStrokeWidget) {
        this.m_menuControl = menuControl;
        this.m_keyStrokeWidget = keyStrokeWidget;
    }

    public Control getMenuControl() {
        return this.m_menuControl;
    }

    public Control getKeyStrokeWidget() {
        return this.m_keyStrokeWidget;
    }

    protected abstract Menu getContextMenu();

    protected abstract void setContextMenu(Menu var1);

    public void menuShown(MenuEvent e) {
        final IRwtEnvironment uiEnvironment = RwtUtility.getUiEnvironment(e.display);
        RwtKeyStroke keyStroke = new RwtKeyStroke(RwtUtility.scoutToRwtKey("escape")){

            @Override
            public void handleUiAction(Event keyEvent) {
                if (MenuAdapterEx.this.getContextMenu() != null && !MenuAdapterEx.this.getContextMenu().isDisposed()) {
                    MenuItem[] menuItemArray = MenuAdapterEx.this.getContextMenu().getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        MenuAdapterEx.this.disposeMenuItem(item);
                        ++n2;
                    }
                    MenuAdapterEx.this.getContextMenu().dispose();
                }
                if (!(MenuAdapterEx.this.getContextMenu() != null && !MenuAdapterEx.this.getContextMenu().isDisposed() || MenuAdapterEx.this.getMenuControl().isDisposed() || MenuAdapterEx.this.getMenuControl().getShell().isDisposed())) {
                    MenuAdapterEx.this.setContextMenu(new Menu((Decorations)MenuAdapterEx.this.getMenuControl().getShell(), 8));
                    MenuAdapterEx.this.getContextMenu().addMenuListener((MenuListener)MenuAdapterEx.this);
                    MenuAdapterEx.this.getMenuControl().setMenu(MenuAdapterEx.this.getContextMenu());
                }
                uiEnvironment.removeKeyStroke(MenuAdapterEx.this.getKeyStrokeWidget(), this);
                keyEvent.doit = false;
            }
        };
        uiEnvironment.addKeyStroke(this.getKeyStrokeWidget(), keyStroke, true);
        if (this.getContextMenu() != null) {
            MenuItem[] menuItemArray = this.getContextMenu().getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                this.disposeMenuItem(item);
                ++n2;
            }
        }
    }

    protected void disposeMenuItem(MenuItem item) {
        Menu menu = item.getMenu();
        if (menu != null) {
            MenuItem[] menuItemArray = menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem childItem = menuItemArray[n2];
                this.disposeMenuItem(childItem);
                ++n2;
            }
            menu.dispose();
        }
        item.dispose();
    }
}

