/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext.browser;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;

public class BrowserExtension {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BrowserExtension.class);
    private static final Pattern LOCAL_URL_PATTERN = Pattern.compile("(['\"])(http://local[?/][^'\"]*)(['\"])", 34);
    private final Browser m_browser;
    private final HashMap<String, String> m_hyperlinkMap;
    private final String m_serviceHandlerId;
    private IServiceHandler m_serviceHandler;
    private HashSet<String> m_tempFileNames = new HashSet();

    public BrowserExtension(Browser b) {
        this.m_browser = b;
        this.m_hyperlinkMap = new HashMap();
        this.m_serviceHandlerId = UUID.randomUUID().toString();
    }

    public String getServiceHandlerId() {
        return this.m_serviceHandlerId;
    }

    public void attach() {
        if (this.m_serviceHandler == null) {
            this.m_serviceHandler = new IServiceHandler(){

                public void service() throws IOException, ServletException {
                    String localUrl = (String)BrowserExtension.this.m_hyperlinkMap.get(RWT.getRequest().getParameter("p"));
                    if (localUrl == null) {
                        return;
                    }
                    BrowserExtension.this.fireLocationChangedEvent(localUrl);
                }
            };
            RWT.getServiceManager().registerServiceHandler(this.m_serviceHandlerId, this.m_serviceHandler);
        }
    }

    public void detach() {
        this.clearLocalHyperlinkCache();
        this.clearResourceCache();
        if (this.m_serviceHandler != null) {
            this.m_serviceHandler = null;
            RWT.getServiceManager().unregisterServiceHandler(this.m_serviceHandlerId);
        }
    }

    public String addResource(String name, InputStream content) {
        if ((name = name.replaceAll("\\\\", "/")) == null || name.length() == 0) {
            return null;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        String uniqueName = String.valueOf(this.m_serviceHandlerId) + name;
        this.m_tempFileNames.add(uniqueName);
        IResourceManager resourceManager = RWT.getResourceManager();
        resourceManager.register(uniqueName, content);
        return resourceManager.getLocation(uniqueName);
    }

    public void clearResourceCache() {
        IResourceManager resourceManager = RWT.getResourceManager();
        try {
            for (String name : this.m_tempFileNames) {
                resourceManager.unregister(name);
            }
        }
        finally {
            this.m_tempFileNames.clear();
        }
    }

    public String adaptLocalHyperlinks(String html, int childDepth) {
        String p;
        if (childDepth <= 0) {
            p = "this";
        } else {
            p = "parent";
            int i = 1;
            while (i < childDepth) {
                p = "parent." + p;
                ++i;
            }
        }
        return BrowserExtension.rewriteLocalHyperlinks(html, p, this.m_serviceHandlerId, this.m_hyperlinkMap);
    }

    public void clearLocalHyperlinkCache() {
        this.m_hyperlinkMap.clear();
    }

    private void fireLocationChangedEvent(final String location) {
        this.m_browser.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Constructor c = LocationEvent.class.getDeclaredConstructor(Object.class, Integer.TYPE, String.class);
                    c.setAccessible(true);
                    LocationEvent event = (LocationEvent)c.newInstance(BrowserExtension.this.m_browser, 5011, location);
                    event.top = true;
                    event.processEvent();
                    event = (LocationEvent)c.newInstance(BrowserExtension.this.m_browser, 5012, location);
                    event.top = true;
                    event.processEvent();
                }
                catch (Throwable throwable) {}
            }
        });
    }

    private static String rewriteLocalHyperlinks(String html, String ajaxParentContext, String rwtServiceHandler, Map<String, String> generatedMappings) {
        if (html == null) {
            return html;
        }
        StringBuilder buf = new StringBuilder();
        Matcher m = LOCAL_URL_PATTERN.matcher(html);
        int nextFind = 0;
        while (m.find(nextFind)) {
            String localUrl = m.group(2);
            String externalKey = "" + generatedMappings.size();
            StringBuilder urlBuf = new StringBuilder();
            urlBuf.append(RWT.getRequest().getContextPath());
            urlBuf.append(RWT.getRequest().getServletPath());
            urlBuf.append("?");
            urlBuf.append("custom_service_handler");
            urlBuf.append("=");
            urlBuf.append(rwtServiceHandler);
            urlBuf.append("&amp;");
            urlBuf.append("p");
            urlBuf.append("=");
            urlBuf.append(externalKey);
            String encodedURL = RWT.getResponse().encodeURL(urlBuf.toString());
            String callableURL = "javascript:a=" + ajaxParentContext + ".qx.net.HttpRequest.create();a.open('GET','" + encodedURL + "',true);a.send(null);";
            buf.append(html.substring(nextFind, m.start()));
            buf.append(m.group(1));
            buf.append(callableURL);
            buf.append(m.group(3));
            generatedMappings.put(externalKey, localUrl);
            nextFind = m.end();
        }
        if (nextFind == 0) {
            return html;
        }
        if (nextFind < html.length()) {
            buf.append(html.substring(nextFind));
        }
        return buf.toString();
    }
}

