/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.rap.ext.custom.StyledText;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class OnFieldLabelDecorator
implements FocusListener {
    private static final long serialVersionUID = 1L;
    private String m_label;
    private String m_text;
    private boolean m_mandatory;
    private Control m_control;
    private RwtScoutFieldComposite m_rwtScoutFieldComposite;

    public OnFieldLabelDecorator(Control control, boolean mandatory, RwtScoutFieldComposite rwtScoutFieldComposite) {
        this.m_mandatory = mandatory;
        this.m_control = control;
        this.m_rwtScoutFieldComposite = rwtScoutFieldComposite;
    }

    public void setLabel(String s) {
        this.m_label = s;
        this.paintOnFieldLabel(false);
    }

    private Control getControl() {
        return this.m_control;
    }

    private void paintOnFieldLabel(boolean hasFocus) {
        if (this.getControl() instanceof StyledText && hasFocus) {
            if (this.getLabel().equalsIgnoreCase(((StyledText)this.getControl()).getText())) {
                ((StyledText)this.getControl()).setOnFieldLabel("");
                if (this.m_rwtScoutFieldComposite instanceof RwtScoutValueFieldComposite) {
                    ((RwtScoutValueFieldComposite)this.m_rwtScoutFieldComposite).setOnFieldLabelFromScout("", "");
                }
            }
            this.getControl().setData("org.eclipse.rwt.themeVariant", null);
            return;
        }
        if (this.getControl() instanceof Text && StringUtility.length((String)((Text)this.getControl()).getText()) > 0) {
            return;
        }
        if (this.getControl() instanceof StyledText && StringUtility.length((String)((StyledText)this.getControl()).getText()) > 0) {
            return;
        }
        if (this.getControl() instanceof StyledText && this.m_rwtScoutFieldComposite instanceof RwtScoutValueFieldComposite) {
            ((RwtScoutValueFieldComposite)this.m_rwtScoutFieldComposite).setOnFieldLabelFromScout("", this.getLabel());
            this.getControl().setData("org.eclipse.rwt.themeVariant", (Object)"onFieldLabel");
        }
    }

    public String getLabel() {
        return this.m_label;
    }

    public void attach(Control c) {
        if (c != null && !c.isDisposed()) {
            this.m_control = c;
            c.addFocusListener((FocusListener)this);
        }
    }

    public void detach(Control c) {
        if (c != null && !c.isDisposed()) {
            c.removeFocusListener((FocusListener)this);
        }
    }

    public void focusGained(FocusEvent e) {
        if (e.widget instanceof Control) {
            this.paintOnFieldLabel(true);
            ((Control)e.widget).redraw();
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.widget instanceof Control) {
            this.paintOnFieldLabel(false);
            ((Control)e.widget).redraw();
        }
    }
}

