/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.imagebox;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageField;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.ext.ImageViewer;
import org.eclipse.scout.rt.ui.rap.ext.MenuAdapterEx;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.form.fields.AbstractRwtScoutDndSupport;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.imagebox.IRwtScoutImageBox;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class RwtScoutImageField
extends RwtScoutFieldComposite<IImageField>
implements IRwtScoutImageBox {
    private Image m_image;
    private Menu m_contextMenu;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        ImageViewer imgViewer = this.getUiEnvironment().getFormToolkit().createImageViewer(container);
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)imgViewer);
        imgViewer.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent e) {
                RwtScoutImageField.this.freeResources();
            }
        });
        this.m_contextMenu = new Menu((Decorations)imgViewer.getShell(), 8);
        this.m_contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener((Control)imgViewer, (Control)this.getUiField()));
        imgViewer.setMenu(this.m_contextMenu);
        this.getUiContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    private void freeResources() {
        if (this.m_image != null && !this.m_image.isDisposed() && this.m_image.getDevice() != null) {
            if (this.getUiField() != null && !this.getUiField().isDisposed()) {
                this.getUiField().setImage(null);
            }
            this.m_image.dispose();
            this.m_image = null;
        }
    }

    public ImageViewer getUiField() {
        return (ImageViewer)super.getUiField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.getUiField().setAlignmentX(RwtUtility.getHorizontalAlignment(((IImageField)this.getScoutObject()).getGridData().horizontalAlignment));
        this.getUiField().setAlignmentY(RwtUtility.getHorizontalAlignment(((IImageField)this.getScoutObject()).getGridData().verticalAlignment));
        this.updateAutoFitFromScout();
        this.updateImageFromScout();
        new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getUiField());
    }

    protected void updateImageFromScout() {
        this.freeResources();
        if (((IImageField)this.getScoutObject()).getImage() instanceof byte[]) {
            this.m_image = new Image((Device)this.getUiField().getDisplay(), (InputStream)new ByteArrayInputStream((byte[])((IImageField)this.getScoutObject()).getImage()));
            this.getUiField().setImage(this.m_image);
        } else if (((IImageField)this.getScoutObject()).getImage() instanceof ImageData) {
            this.m_image = new Image((Device)this.getUiField().getDisplay(), (ImageData)((IImageField)this.getScoutObject()).getImage());
            this.getUiField().setImage(this.m_image);
        } else if (!StringUtility.isNullOrEmpty((String)((IImageField)this.getScoutObject()).getImageId())) {
            this.getUiField().setImage(this.getUiEnvironment().getIcon(((IImageField)this.getScoutObject()).getImageId()));
        }
        this.getUiField().redraw();
    }

    protected void updateAutoFitFromScout() {
        this.getUiField().setAutoFit(((IImageField)this.getScoutObject()).isAutoFit());
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if ("image".equals(name)) {
            this.updateImageFromScout();
        } else if ("autoFit".equals(name)) {
            this.updateAutoFitFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    private class P_ContextMenuListener
    extends MenuAdapterEx {
        private static final long serialVersionUID = 1L;

        public P_ContextMenuListener(Control menuControl, Control keyStrokeWidget) {
            super(menuControl, keyStrokeWidget);
        }

        @Override
        protected Menu getContextMenu() {
            return RwtScoutImageField.this.m_contextMenu;
        }

        @Override
        protected void setContextMenu(Menu contextMenu) {
            RwtScoutImageField.this.m_contextMenu = contextMenu;
        }

        @Override
        public void menuShown(MenuEvent e) {
            super.menuShown(e);
            final AtomicReference scoutMenusRef = new AtomicReference();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    IMenu[] scoutMenus = ((IImageField)RwtScoutImageField.this.getScoutObject()).getUIFacade().firePopupFromUI();
                    scoutMenusRef.set(scoutMenus);
                }
            };
            JobEx job = RwtScoutImageField.this.getUiEnvironment().invokeScoutLater(t, 1200L);
            try {
                job.join(1200L);
            }
            catch (InterruptedException interruptedException) {}
            if (scoutMenusRef.get() != null) {
                RwtMenuUtility.fillContextMenu((IMenu[])scoutMenusRef.get(), RwtScoutImageField.this.getUiEnvironment(), RwtScoutImageField.this.m_contextMenu);
            }
        }
    }

    private class P_DndSupport
    extends AbstractRwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control) {
            super(scoutObject, scoutDndSupportable, control, RwtScoutImageField.this.getUiEnvironment());
        }

        @Override
        protected TransferObject handleUiDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((IImageField)RwtScoutImageField.this.getScoutObject()).getUIFacade().fireDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            JobEx job = this.getUiEnvironment().invokeScoutLater(t, 2345L);
            try {
                job.join(2345L);
            }
            catch (InterruptedException interruptedException) {}
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleUiDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    ((IImageField)RwtScoutImageField.this.getScoutObject()).getUIFacade().fireDropActionFromUi(scoutTransferObject);
                }
            };
            this.getUiEnvironment().invokeScoutLater(job, 200L);
        }
    }
}

