/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.sequencebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.rap.form.fields.checkbox.IRwtScoutCheckbox;
import org.eclipse.scout.rt.ui.rap.form.fields.sequencebox.IRwtScoutSequenceBox;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutSequenceBox
extends RwtScoutFieldComposite<ISequenceBox>
implements IRwtScoutSequenceBox {
    private PropertyChangeListener m_scoutMandatoryChangeListener;
    private PropertyChangeListener m_scoutErrorStatusChangeListener;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        Composite fieldContainer = this.getUiEnvironment().getFormToolkit().createComposite(container);
        int visibleCount = 0;
        IFormField[] iFormFieldArray = this.getScoutObject().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField scoutField = iFormFieldArray[n2];
            IRwtScoutFormField childFormField = this.getUiEnvironment().createFormField(fieldContainer, scoutField);
            ILabelComposite childLabel = null;
            childLabel = childFormField instanceof IRwtScoutCheckbox ? ((IRwtScoutCheckbox)childFormField).getPlaceholderLabel() : childFormField.getUiLabel();
            if (childLabel != null && childLabel.getLayoutData() instanceof LogicalGridData) {
                ((LogicalGridData)childLabel.getLayoutData()).widthHint = 0;
                if (this.removeLabelCompletely(childFormField)) {
                    childLabel.setVisible(false);
                }
                if (childFormField.getScoutObject() instanceof IFormField) {
                    IFormField childScoutField = (IFormField)childFormField.getScoutObject();
                    if (childScoutField.isVisible()) {
                        ++visibleCount;
                    }
                    if (visibleCount > 1 && !childLabel.getVisible()) {
                        childLabel.setVisible(true);
                        childLabel.setText("");
                    }
                }
            }
            RwtScoutFormFieldGridData data = new RwtScoutFormFieldGridData(scoutField){

                @Override
                public void validate() {
                    super.validate();
                    this.useUiWidth = !RwtScoutSequenceBox.this.getScoutObject().isEqualColumnWidths();
                    this.useUiHeight = true;
                }
            };
            childFormField.getUiContainer().setLayoutData((Object)data);
            ++n2;
        }
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)fieldContainer);
        fieldContainer.setLayout((Layout)new LogicalGridLayout(6, 0));
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.setChildMandatoryFromScout();
    }

    private boolean removeLabelCompletely(IRwtScoutFormField rwtScoutFormField) {
        if (rwtScoutFormField == null) {
            return false;
        }
        if (!(rwtScoutFormField.getScoutObject() instanceof IFormField)) {
            return false;
        }
        IFormField formField = (IFormField)rwtScoutFormField.getScoutObject();
        return formField instanceof IBooleanField;
    }

    public Composite getUiField() {
        return (Composite)super.getUiField();
    }

    @Override
    public ISequenceBox getScoutObject() {
        return (ISequenceBox)super.getScoutObject();
    }

    protected void setChildMandatoryFromScout() {
        boolean inheritedMandatory = false;
        IFormField[] iFormFieldArray = this.getScoutObject().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isVisible() && f instanceof IValueField && (inheritedMandatory = ((IValueField)f).isMandatory())) break;
            ++n2;
        }
        this.setMandatoryFromScout(inheritedMandatory);
    }

    protected void setChildErrorStatusFromScout() {
        IProcessingStatus inheritedErrorStatus = null;
        IFormField[] iFormFieldArray = this.getScoutObject().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isVisible() && f instanceof IValueField) {
                inheritedErrorStatus = ((IValueField)f).getErrorStatus();
                break;
            }
            ++n2;
        }
        this.setErrorStatusFromScout(inheritedErrorStatus);
    }

    @Override
    protected void attachScout() {
        IFormField f;
        super.attachScout();
        this.m_scoutMandatoryChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        if (RwtScoutSequenceBox.this.getUiContainer() != null && !RwtScoutSequenceBox.this.getUiContainer().isDisposed()) {
                            RwtScoutSequenceBox.this.setChildMandatoryFromScout();
                        }
                    }
                };
                RwtScoutSequenceBox.this.getUiEnvironment().invokeUiLater(j);
            }
        };
        IFormField[] iFormFieldArray = this.getScoutObject().getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = iFormFieldArray[n2];
            f.addPropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
            ++n2;
        }
        this.m_scoutErrorStatusChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutSequenceBox.this.setChildErrorStatusFromScout();
                    }
                };
                RwtScoutSequenceBox.this.getUiEnvironment().invokeUiLater(j);
            }
        };
        iFormFieldArray = this.getScoutObject().getFields();
        n = iFormFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            f = iFormFieldArray[n2];
            f.addPropertyChangeListener("errorStatus", this.m_scoutErrorStatusChangeListener);
            ++n2;
        }
    }

    @Override
    protected void detachScout() {
        IFormField f;
        int n;
        int n2;
        IFormField[] iFormFieldArray;
        if (this.m_scoutMandatoryChangeListener != null) {
            iFormFieldArray = this.getScoutObject().getFields();
            n2 = iFormFieldArray.length;
            n = 0;
            while (n < n2) {
                f = iFormFieldArray[n];
                f.removePropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
                ++n;
            }
            this.m_scoutMandatoryChangeListener = null;
        }
        if (this.m_scoutErrorStatusChangeListener != null) {
            iFormFieldArray = this.getScoutObject().getFields();
            n2 = iFormFieldArray.length;
            n = 0;
            while (n < n2) {
                f = iFormFieldArray[n];
                f.removePropertyChangeListener("errorStatus", this.m_scoutErrorStatusChangeListener);
                ++n;
            }
            this.m_scoutErrorStatusChangeListener = null;
        }
        super.detachScout();
    }
}

