/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.tabbox;

import org.eclipse.rwt.lifecycle.UICallBack;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.rap.form.fields.groupbox.RwtScoutGroupBox;
import org.eclipse.scout.rt.ui.rap.form.fields.tabbox.IRwtScoutTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class RwtScoutTabItem
extends RwtScoutGroupBox
implements IRwtScoutTabItem {
    private final ITabBox m_scoutParentObject;
    private final Composite m_tabboxButtonbar;
    private final Composite m_tabboxContainer;
    private final String m_variantInActive;
    private final String m_variantActive;
    private final String m_variantInActiveMarked;
    private final String m_variantActiveMarked;
    private Composite m_tabItem;
    private boolean m_uiFocus;
    private Button m_tabButton;

    public RwtScoutTabItem(ITabBox scoutParentObject, Composite tabboxButtonbar, Composite tabboxContainer, String variantInActive, String variantActive, String variantInActiveMarked, String variantActiveMarked) {
        this.m_scoutParentObject = scoutParentObject;
        this.m_tabboxButtonbar = tabboxButtonbar;
        this.m_tabboxContainer = tabboxContainer;
        this.m_variantInActive = variantInActive;
        this.m_variantActive = variantActive;
        this.m_variantInActiveMarked = variantInActiveMarked;
        this.m_variantActiveMarked = variantActiveMarked;
    }

    @Override
    protected void initializeUi(Composite parent) {
        this.m_tabButton = this.getUiEnvironment().getFormToolkit().createButton(this.m_tabboxButtonbar, "", 0);
        this.m_tabButton.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantInActive);
        this.m_tabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                RwtScoutTabItem.this.handleUiSelection();
                RwtScoutTabItem.this.setActiveButton(RwtScoutTabItem.this.m_tabButton);
            }
        });
        RowData rowData = new RowData();
        this.m_tabButton.setLayoutData((Object)rowData);
        this.m_tabItem = this.getUiEnvironment().getFormToolkit().createComposite(this.m_tabboxContainer, 0);
        this.m_tabItem.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantInActive);
        this.m_tabItem.setLayout((Layout)new FillLayout());
        super.initializeUi(this.m_tabItem);
    }

    @Override
    protected void disposeImpl() {
        super.disposeImpl();
        if (this.m_tabButton != null && !this.m_tabButton.isDisposed()) {
            this.m_tabButton.dispose();
            this.m_tabButton = null;
        }
        if (this.m_tabItem != null && !this.m_tabItem.isDisposed()) {
            this.m_tabItem.dispose();
            this.m_tabItem = null;
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IGroupBox scoutField = (IGroupBox)this.getScoutObject();
        if (scoutField != null) {
            this.setEmptyFromScout(scoutField.isEmpty());
        }
    }

    private boolean isValidWidget(Widget w) {
        Control c;
        if (w == null || w.isDisposed()) {
            return false;
        }
        return !(w instanceof Control) || (c = (Control)w).getParent() != null && !c.getParent().isDisposed();
    }

    private boolean setActiveButton(Button tabButton) {
        Control[] children;
        if (!this.isValidWidget((Widget)tabButton)) {
            return false;
        }
        Control[] controlArray = children = tabButton.getParent().getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.makeButtonInActive(child);
            ++n2;
        }
        this.makeButtonActive((Control)tabButton);
        return true;
    }

    private void makeButtonInActive(Control tabButton) {
        if (!this.isValidWidget((Widget)tabButton)) {
            return;
        }
        Object oldVariant = tabButton.getData("org.eclipse.rwt.themeVariant");
        if (oldVariant == this.m_variantActiveMarked || oldVariant == this.m_variantInActiveMarked) {
            tabButton.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantInActiveMarked);
        } else {
            tabButton.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantInActive);
        }
    }

    private void makeButtonActive(Control tabButton) {
        if (!this.isValidWidget((Widget)tabButton)) {
            return;
        }
        Object oldVariant = tabButton.getData("org.eclipse.rwt.themeVariant");
        if (oldVariant == this.m_variantActiveMarked || oldVariant == this.m_variantInActiveMarked) {
            tabButton.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantActiveMarked);
        } else {
            tabButton.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantActive);
        }
    }

    private void setButtonMarker(Button tabButton, boolean marked) {
        if (!this.isValidWidget((Widget)tabButton)) {
            return;
        }
        Object oldVariant = tabButton.getData("org.eclipse.rwt.themeVariant");
        if (marked) {
            if (oldVariant == this.m_variantActive) {
                tabButton.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantActiveMarked);
            } else if (oldVariant == this.m_variantInActive) {
                tabButton.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantInActiveMarked);
            }
        } else if (oldVariant == this.m_variantActiveMarked) {
            tabButton.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantActive);
        } else if (oldVariant == this.m_variantInActiveMarked) {
            tabButton.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantInActive);
        }
    }

    protected void handleUiSelection() {
        UICallBack.activate((String)(String.valueOf(this.m_scoutParentObject.getClass().getName()) + this.m_scoutParentObject.hashCode()));
        Runnable t = new Runnable(){

            @Override
            public void run() {
                RwtScoutTabItem.this.m_scoutParentObject.getUIFacade().setSelectedTabFromUI((IGroupBox)RwtScoutTabItem.this.getScoutObject());
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    public Button getTabButton() {
        return this.m_tabButton;
    }

    protected Composite getTabItem() {
        return this.m_tabItem;
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("empty")) {
            this.setEmptyFromScout((Boolean)TypeCastUtility.castValue((Object)newValue, Boolean.TYPE));
        }
    }

    @Override
    protected void setSaveNeededFromScout(boolean b) {
        if (((IGroupBox)this.getScoutObject()).getForm() instanceof ISearchForm) {
            this.setButtonMarker(this.m_tabButton, b);
        }
    }

    protected void setEmptyFromScout(boolean b) {
        if (!(((IGroupBox)this.getScoutObject()).getForm() instanceof ISearchForm)) {
            this.setButtonMarker(this.m_tabButton, !b);
        }
    }

    @Override
    protected void setLabelFromScout(String s) {
        String label = s;
        if (label == null) {
            label = "";
        }
        this.getTabButton().setText(label);
    }

    @Override
    protected void setFontFromScout(FontSpec scoutFont) {
        super.setFontFromScout(scoutFont);
        this.m_tabItem.setFont(this.getUiEnvironment().getFont(scoutFont, this.m_tabItem.getFont()));
    }

    public boolean setUiFocus() {
        return this.setActiveButton(this.m_tabButton);
    }
}

