/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.radiobuttongroup;

import java.util.ArrayList;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.IRwtScoutFormField;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.radiobuttongroup.IRwtScoutRadioButtonGroup;
import org.eclipse.scout.rt.ui.rap.form.radiobuttongroup.layout.RadioButtonGroupLayout;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RwtScoutRadioButtonGroup
extends RwtScoutValueFieldComposite<IRadioButtonGroup<?>>
implements IRwtScoutRadioButtonGroup {
    private P_RwtButtonListener m_uiButtonListener = new P_RwtButtonListener();
    private ArrayList<Button> m_uiRadioButtons = new ArrayList();

    @Override
    protected void initializeUi(Composite parent) {
        boolean usesLogicalGrid;
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        P_RadioButtonComposite buttonArea = new P_RadioButtonComposite(container);
        this.getUiEnvironment().getFormToolkit().adapt(buttonArea);
        IFormField[] iFormFieldArray = ((IRadioButtonGroup)this.getScoutObject()).getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField scoutField = iFormFieldArray[n2];
            IRwtScoutFormField uiField = this.getUiEnvironment().createFormField(buttonArea, scoutField);
            if (uiField.getUiField() instanceof Button) {
                Button uiButton = (Button)uiField.getUiField();
                uiButton.addListener(13, (Listener)this.m_uiButtonListener);
                this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000002), false);
                this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000004), false);
                this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000001), false);
                this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000003), false);
                this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000007), false);
                this.getUiEnvironment().addKeyStroke((Control)uiButton, new P_KeyStroke(0x1000008), false);
                this.m_uiRadioButtons.add(uiButton);
                if (uiButton.getSelection()) {
                    buttonArea.setTabList(new Control[]{uiButton.getParent()});
                }
            }
            ++n2;
        }
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setUiField((Control)buttonArea);
        this.getUiContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
        GridData scoutGridData = ((IRadioButtonGroup)this.getScoutObject()).getGridData();
        boolean bl = usesLogicalGrid = ((IRadioButtonGroup)this.getScoutObject()).getGridRowCount() == scoutGridData.h && !scoutGridData.useUiHeight;
        if (usesLogicalGrid) {
            IUiDecoration deco = UiDecorationExtensionPoint.getLookAndFeel();
            this.getUiField().setLayout((Layout)new RadioButtonGroupLayout((IRadioButtonGroup)this.getScoutObject(), deco.getLogicalGridLayoutHorizontalGap(), deco.getLogicalGridLayoutVerticalGap()));
        } else {
            this.getUiField().setLayout((Layout)new RadioButtonGroupLayout((IRadioButtonGroup)this.getScoutObject(), 0, 4));
        }
    }

    public Composite getUiField() {
        return (Composite)super.getUiField();
    }

    private class P_KeyStroke
    extends RwtKeyStroke {
        public P_KeyStroke(int keyCode) {
            super(keyCode);
        }

        @Override
        public void handleUiAction(Event e) {
            int index = RwtScoutRadioButtonGroup.this.m_uiRadioButtons.indexOf(e.widget);
            switch (e.keyCode) {
                case 0x1000002: 
                case 0x1000004: {
                    ++index;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    index = index + RwtScoutRadioButtonGroup.this.m_uiRadioButtons.size() - 1;
                    break;
                }
                case 0x1000007: {
                    index = 0;
                    break;
                }
                case 0x1000008: {
                    index = RwtScoutRadioButtonGroup.this.m_uiRadioButtons.size() - 1;
                }
            }
            ((Button)RwtScoutRadioButtonGroup.this.m_uiRadioButtons.get(index %= RwtScoutRadioButtonGroup.this.m_uiRadioButtons.size())).setFocus();
        }
    }

    private class P_RadioButtonComposite
    extends Composite {
        private static final long serialVersionUID = 1L;

        public P_RadioButtonComposite(Composite parent) {
            super(parent, 0);
        }

        protected void checkSubclass() {
        }

        public boolean setFocus() {
            for (Button b : RwtScoutRadioButtonGroup.this.m_uiRadioButtons) {
                if (!b.getSelection()) continue;
                return b.getParent().setFocus();
            }
            return super.setFocus();
        }
    }

    private class P_RwtButtonListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_RwtButtonListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    Button button = (Button)event.widget;
                    this.handleSelectionChanged(button);
                }
            }
        }

        private void handleSelectionChanged(Button selectedButton) {
            RwtScoutRadioButtonGroup.this.getUiField().setTabList(new Control[]{selectedButton.getParent()});
        }
    }
}

