/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.util;

import java.util.HashMap;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class FontRegistry {
    private final Display m_display;
    private HashMap<String, Font> m_fontCache = new HashMap();

    public FontRegistry(Display display) {
        this.m_display = display;
    }

    public Font getFont(FontSpec scoutFont, Font templateFont) {
        if (scoutFont == null) {
            return templateFont;
        }
        return this.getFont(templateFont, scoutFont.getName(), FontRegistry.scoutToSwtStyle(scoutFont.getStyle()), scoutFont.getSize() > 0 ? Integer.valueOf(scoutFont.getSize()) : null);
    }

    public Font getFont(Font templateFont, String newName, Integer newStyle, Integer newSize) {
        String cacheKey;
        Font font;
        FontData fd;
        if (newName == null && newStyle == null && newSize == null) {
            return templateFont;
        }
        FontData[] fds = templateFont.getFontData();
        FontData fontData = fd = fds != null && fds.length > 0 ? fds[0] : null;
        if (newName == null || newName.equalsIgnoreCase("null")) {
            newName = fd != null ? fd.getName() : "Dialog";
        }
        if (newStyle == null) {
            newStyle = fd != null ? fd.getStyle() : 0;
        }
        if (newSize == null || newSize <= 0) {
            newSize = fd != null ? fd.getHeight() : 11;
        }
        if ((font = this.m_fontCache.get(cacheKey = String.valueOf(newName) + "_" + newSize + "_" + newStyle)) == null) {
            font = new Font((Device)this.m_display, newName, newSize.intValue(), newStyle.intValue());
            this.m_fontCache.put(cacheKey, font);
        }
        return font;
    }

    public static int scoutToSwtStyle(int scoutStyle) {
        int style = 0;
        if ((scoutStyle & 1) != 0) {
            style |= 1;
        }
        if ((scoutStyle & 2) != 0) {
            style |= 2;
        }
        return style;
    }

    public void dispose() {
        for (Font f : this.m_fontCache.values()) {
            if (f == null || f.isDisposed() || f.getDevice() == null) continue;
            f.dispose();
        }
        this.m_fontCache.clear();
    }
}

