/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window;

import java.awt.Rectangle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.window.IFormBoundsProvider;

public class DefaultFormBoundsProvider
implements IFormBoundsProvider {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultFormBoundsProvider.class);
    private final IForm m_form;
    private IRwtEnvironment m_uiEnvironment;
    private ClientSyncJob m_storeBoundsJob;

    public DefaultFormBoundsProvider(IForm form, IRwtEnvironment uiEnvironment) {
        this.m_form = form;
        this.m_uiEnvironment = uiEnvironment;
    }

    @Override
    public org.eclipse.swt.graphics.Rectangle getBounds() {
        Rectangle awtBounds = ClientUIPreferences.getInstance((IClientSession)this.m_uiEnvironment.getClientSession()).getFormBounds(this.m_form);
        if (awtBounds != null) {
            return new org.eclipse.swt.graphics.Rectangle(awtBounds.x, awtBounds.y, awtBounds.width, awtBounds.height);
        }
        return null;
    }

    @Override
    public void storeBounds(final org.eclipse.swt.graphics.Rectangle bounds) {
        if (this.m_storeBoundsJob != null) {
            this.m_storeBoundsJob.cancel();
        }
        this.m_storeBoundsJob = new ClientSyncJob("Saving form bounds", this.m_uiEnvironment.getClientSession()){

            protected void runVoid(IProgressMonitor monitor) {
                DefaultFormBoundsProvider.this.storeBoundsInternal(bounds);
            }
        };
        this.m_storeBoundsJob.schedule(200L);
    }

    private void storeBoundsInternal(org.eclipse.swt.graphics.Rectangle bounds) {
        Rectangle awtBounds = null;
        if (bounds != null) {
            awtBounds = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        ClientUIPreferences.getInstance((IClientSession)this.m_uiEnvironment.getClientSession()).setFormBounds(this.m_form, awtBounds);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Bounds stored for " + this.m_form.getClass() + ". Bounds: " + bounds);
        }
    }
}

