/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.IRwtStandaloneEnvironment;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtDesktop;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutToolbar;
import org.eclipse.scout.rt.ui.rap.window.desktop.IViewArea;
import org.eclipse.scout.rt.ui.rap.window.desktop.RwtScoutViewStack;
import org.eclipse.scout.rt.ui.rap.window.desktop.toolbar.RwtScoutToolbar;
import org.eclipse.scout.rt.ui.rap.window.desktop.viewarea.ILayoutListener;
import org.eclipse.scout.rt.ui.rap.window.desktop.viewarea.ViewArea;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

public class RwtScoutDesktop
extends RwtScoutComposite<IDesktop>
implements IRwtDesktop {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutDesktop.class);
    private static final String VARIANT_VIEWS_AREA = "viewsArea";
    private ViewArea m_viewArea;
    private RwtScoutToolbar m_uiToolbar;
    private Integer m_toolbarHeight;

    @Override
    protected void attachScout() {
        super.attachScout();
    }

    @Override
    protected void detachScout() {
        super.detachScout();
    }

    @Override
    protected void initializeUi(Composite parent) {
        try {
            Composite desktopComposite = parent;
            Control toolbar = this.createToolBar(desktopComposite);
            Control viewsArea = this.createViewsArea(desktopComposite);
            viewsArea.setData("org.eclipse.rwt.themeVariant", (Object)VARIANT_VIEWS_AREA);
            this.initLayout(desktopComposite, toolbar, viewsArea);
            this.setUiContainer(desktopComposite);
        }
        catch (Throwable t) {
            LOG.error("Exception occured while creating ui desktop.", t);
        }
    }

    protected void initLayout(Composite container, Control toolbar, Control viewsArea) {
        GridLayout layout = RwtLayoutUtility.createGridLayoutNoSpacing(1, true);
        container.setLayout((Layout)layout);
        if (toolbar != null) {
            GridData toolbarData = new GridData(768);
            if (this.getToolbarHeight() != null) {
                toolbarData.heightHint = this.getToolbarHeight();
            }
            toolbar.setLayoutData((Object)toolbarData);
        }
        if (viewsArea != null) {
            GridData viewsAreaData = new GridData(1808);
            viewsArea.setLayoutData((Object)viewsAreaData);
        }
    }

    protected Control createToolBar(Composite parent) {
        this.m_uiToolbar = new RwtScoutToolbar();
        this.m_uiToolbar.createUiField(parent, (IDesktop)this.getScoutObject(), this.getUiEnvironment());
        return this.m_uiToolbar.getUiContainer();
    }

    protected Control createViewsArea(Composite parent) {
        this.m_viewArea = new ViewArea(parent);
        this.m_viewArea.getLayout().addLayoutListener(new ILayoutListener(){

            @Override
            public void handleCompositeLayouted() {
                int xOffset = -1;
                Sash sash = RwtScoutDesktop.this.m_viewArea.getSash(ViewArea.SashKey.VERTICAL_RIGHT);
                if (sash.getVisible()) {
                    Rectangle sashBounds = sash.getBounds();
                    xOffset = sashBounds.x + sashBounds.width;
                }
                RwtScoutDesktop.this.getUiToolbar().handleRightViewPositionChanged(xOffset);
            }
        });
        return this.m_viewArea;
    }

    @Override
    public IRwtStandaloneEnvironment getUiEnvironment() {
        return (IRwtStandaloneEnvironment)super.getUiEnvironment();
    }

    @Override
    public IRwtScoutPart addForm(IForm form) {
        RwtScoutViewStack stack = this.m_viewArea.getStackForForm(form);
        IRwtScoutPart rwtForm = stack.addForm(form);
        this.m_viewArea.updateSashPositionForViewStack(stack);
        this.updateLayout();
        return rwtForm;
    }

    @Override
    public void updateLayout() {
        this.m_viewArea.layout();
    }

    @Override
    public IRwtScoutToolbar getUiToolbar() {
        return this.m_uiToolbar;
    }

    @Override
    public IViewArea getViewArea() {
        return this.m_viewArea;
    }

    public Integer getToolbarHeight() {
        return this.m_toolbarHeight;
    }

    public void setToolbarHeight(Integer toolbarHeight) {
        this.m_toolbarHeight = toolbarHeight;
    }
}

