/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBox;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.form.IRwtScoutForm;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.AbstractRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutViewStack;
import org.eclipse.scout.rt.ui.rap.window.desktop.ViewStackTabButton;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;

public class RwtScoutDesktopForm
extends AbstractRwtScoutPart {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutDesktopForm.class);
    private IRwtScoutViewStack m_stackComposite;
    private IRwtScoutForm m_formComposite;
    private Form m_uiForm;
    private ViewStackTabButton m_button;

    @Override
    public Form getUiForm() {
        return this.m_uiForm;
    }

    public void createPart(IRwtScoutViewStack stackComposite, Composite parent, ViewStackTabButton button, IForm scoutForm, IRwtEnvironment uiEnvironment) {
        this.m_stackComposite = stackComposite;
        this.m_button = button;
        super.createPart(scoutForm, uiEnvironment);
        this.m_uiForm = this.getUiEnvironment().getFormToolkit().createForm(parent);
        Composite contentPane = this.m_uiForm.getBody();
        contentPane.setLayout((Layout)new FillLayout());
        try {
            parent.setRedraw(false);
            this.m_formComposite = this.getUiEnvironment().createForm(contentPane, this.getScoutObject());
            this.attachScout();
        }
        finally {
            parent.setRedraw(true);
        }
    }

    @Override
    protected void showPartImpl() {
    }

    @Override
    protected void closePartImpl() {
        this.detachScout();
        this.m_button.dispose();
        this.m_uiForm.dispose();
        this.m_stackComposite = null;
    }

    public ViewStackTabButton getTabButton() {
        return this.m_button;
    }

    @Override
    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Control c = this.getUiEnvironment().getDisplay().getFocusControl();
        if (c == null) {
            return true;
        }
        return RwtUtility.isAncestorOf((Control)this.getUiForm(), c);
    }

    @Override
    public void activate() {
        if (this.m_stackComposite == null) {
            LOG.error("stack composite is null");
            return;
        }
        this.m_stackComposite.setPartVisible(this);
    }

    @Override
    public boolean isVisible() {
        if (this.m_stackComposite == null) {
            LOG.error("stack composite is null");
            return false;
        }
        return this.m_stackComposite.isPartVisible(this);
    }

    @Override
    public boolean setStatusLineMessage(Image image, final String message) {
        this.getUiEnvironment().invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                MessageBox mbox = new MessageBox("Info", message, null);
                mbox.setAutoCloseMillis(2500L);
                mbox.startMessageBox();
            }
        }, 3000L);
        return true;
    }

    @Override
    protected void setImageFromScout() {
        if (this.m_button == null || this.m_button.isDisposed() || this.getUiForm() == null) {
            return;
        }
        String iconId = this.getScoutObject().getIconId();
        Image img = this.getUiEnvironment().getIcon(iconId);
        this.m_button.setImage(img);
        String sub = this.getScoutObject().getSubTitle();
        if (sub != null) {
            this.getUiForm().setImage(img);
        } else {
            this.getUiForm().setImage(null);
        }
    }

    @Override
    protected void setTitleFromScout() {
        if (this.m_button == null || this.m_button.isDisposed() || this.getUiForm() == null) {
            return;
        }
        IForm f = this.getScoutObject();
        String s = f.getBasicTitle();
        this.m_button.setLabel(StringUtility.removeNewLines((String)(s != null ? s : "")));
        s = f.getSubTitle();
        if (s != null) {
            this.getUiForm().setText(RwtUtility.escapeMnemonics(StringUtility.removeNewLines((String)(s != null ? s : ""))));
        } else {
            this.getUiForm().setText(null);
        }
    }

    @Override
    protected void setCloseEnabledFromScout(boolean defaultValue) {
        if (this.m_button != null && !this.m_button.isDisposed()) {
            this.m_button.setShowClose(defaultValue);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
    }
}

