/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop.viewarea;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.window.desktop.IViewArea;
import org.eclipse.scout.rt.ui.rap.window.desktop.RwtScoutViewStack;
import org.eclipse.scout.rt.ui.rap.window.desktop.viewarea.ViewAreaLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class ViewArea
extends Composite
implements IViewArea {
    private static final long serialVersionUID = 1L;
    private P_SashSelectionListener m_sashListener;
    private HashMap<SashKey, Integer> m_sashPositions;
    RwtScoutViewStack[][] m_viewStacks;
    HashMap<SashKey, Sash> m_sashes = new HashMap();

    public ViewArea(Composite parent) {
        super(parent, 0);
        this.m_sashPositions = new HashMap();
        this.m_sashListener = new P_SashSelectionListener();
        this.createContent(this);
        this.readPreferences();
        this.setLayout(new ViewAreaLayout());
    }

    private void readPreferences() {
        IUiDecoration deco = UiDecorationExtensionPoint.getLookAndFeel();
        this.m_sashPositions.put(SashKey.VERTICAL_RIGHT, deco.getLogicalGridLayoutDefaultColumnWidth());
    }

    protected void createContent(Composite parent) {
        this.m_viewStacks = new RwtScoutViewStack[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.m_viewStacks[i][j] = new RwtScoutViewStack(parent, this.getUiEnvironment());
                ++j;
            }
            ++i;
        }
        SashKey[] sashKeyArray = SashKey.values();
        int n = sashKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            SashKey k = sashKeyArray[n2];
            int style = 256;
            switch (k) {
                case VERTICAL_LEFT: 
                case VERTICAL_RIGHT: {
                    style = 512;
                }
            }
            Sash sash = new Sash(parent, style);
            sash.setData("SASH_KEY", (Object)k);
            sash.addListener(13, (Listener)this.m_sashListener);
            this.m_sashes.put(k, sash);
            ++n2;
        }
    }

    int getSashPosition(SashKey key) {
        Integer pos = this.m_sashPositions.get((Object)key);
        if (pos != null && this.m_sashes.get((Object)key).getVisible()) {
            return pos;
        }
        return -1;
    }

    public void updateSashPositionForViewStack(RwtScoutViewStack viewStack) {
        this.updateVerticalSashPositionForViewStack(viewStack, SashKey.VERTICAL_LEFT, 0);
        this.updateVerticalSashPositionForViewStack(viewStack, SashKey.VERTICAL_RIGHT, 2);
        List<RwtScoutViewStack> horizontalViewStacks = this.getHorizontalViewStacks(0);
        if (horizontalViewStacks.get(0) == viewStack) {
            this.updateSashPositionWithViewStackHeight(viewStack, SashKey.HORIZONTAL_LEFT_TOP);
        } else if (horizontalViewStacks.get(1) == viewStack) {
            this.updateSashPositionWithViewStackHeight(viewStack, SashKey.HORIZONTAL_CENTER_TOP);
        } else if (horizontalViewStacks.get(2) == viewStack) {
            this.updateSashPositionWithViewStackHeight(viewStack, SashKey.HORIZONTAL_RIGHT_TOP);
        }
        horizontalViewStacks = this.getHorizontalViewStacks(2);
        if (horizontalViewStacks.get(0) == viewStack) {
            this.updateSashPositionWithViewStackHeight(viewStack, SashKey.HORIZONTAL_LEFT_BOTTOM);
        } else if (horizontalViewStacks.get(1) == viewStack) {
            this.updateSashPositionWithViewStackHeight(viewStack, SashKey.HORIZONTAL_CENTER_BOTTOM);
        } else if (horizontalViewStacks.get(2) == viewStack) {
            this.updateSashPositionWithViewStackHeight(viewStack, SashKey.HORIZONTAL_RIGHT_BOTTOM);
        }
    }

    private void updateVerticalSashPositionForViewStack(RwtScoutViewStack viewStack, SashKey sashKey, int col) {
        List<RwtScoutViewStack> verticalViewStacks = this.getVerticalViewStacks(col);
        if (!verticalViewStacks.contains(viewStack)) {
            return;
        }
        int maxWidth = -1;
        for (RwtScoutViewStack verticalViewStack : verticalViewStacks) {
            if (verticalViewStack.getWidthHint() <= maxWidth) continue;
            maxWidth = viewStack.getWidthHint();
        }
        if (maxWidth < 0) {
            return;
        }
        this.m_sashPositions.put(sashKey, maxWidth);
    }

    private void updateSashPositionWithViewStackHeight(RwtScoutViewStack viewStack, SashKey sashKey) {
        int heightHint = viewStack.getHeightHint();
        if (heightHint < 0) {
            return;
        }
        this.m_sashPositions.put(sashKey, heightHint);
    }

    private List<RwtScoutViewStack> getVerticalViewStacks(int col) {
        LinkedList<RwtScoutViewStack> viewStacks = new LinkedList<RwtScoutViewStack>();
        int j = 0;
        while (j < 3) {
            viewStacks.add(this.m_viewStacks[col][j]);
            ++j;
        }
        return viewStacks;
    }

    private List<RwtScoutViewStack> getHorizontalViewStacks(int row) {
        LinkedList<RwtScoutViewStack> viewStacks = new LinkedList<RwtScoutViewStack>();
        int i = 0;
        while (i < 3) {
            viewStacks.add(this.m_viewStacks[i][row]);
            ++i;
        }
        return viewStacks;
    }

    public Sash getSash(SashKey key) {
        return this.m_sashes.get((Object)key);
    }

    private IRwtEnvironment getUiEnvironment() {
        return (IRwtEnvironment)this.getDisplay().getData(IRwtEnvironment.class.getName());
    }

    public RwtScoutViewStack getStackForForm(IForm form) {
        String scoutId = form.getDisplayViewId();
        if (scoutId == null) {
            return null;
        }
        if ("OUTLINE_SELECTOR".equalsIgnoreCase(scoutId)) {
            scoutId = "SW";
        } else if ("OUTLINE".equalsIgnoreCase(scoutId)) {
            scoutId = "NW";
        } else if ("PAGE_DETAIL".equalsIgnoreCase(scoutId)) {
            scoutId = "N";
        } else if ("PAGE_TABLE".equalsIgnoreCase(scoutId)) {
            scoutId = "C";
        } else if (scoutId.startsWith("EDITOR") || scoutId.startsWith("EDITOR")) {
            scoutId = "C";
        } else if ("PAGE_SEARCH".equalsIgnoreCase(scoutId)) {
            scoutId = "S";
        }
        if ("NW".equals(scoutId)) {
            return this.m_viewStacks[0][0];
        }
        if ("N".equals(scoutId)) {
            return this.m_viewStacks[1][0];
        }
        if ("NE".equals(scoutId)) {
            return this.m_viewStacks[2][0];
        }
        if ("W".equals(scoutId)) {
            return this.m_viewStacks[0][1];
        }
        if ("C".equals(scoutId)) {
            return this.m_viewStacks[1][1];
        }
        if ("E".equals(scoutId)) {
            return this.m_viewStacks[2][1];
        }
        if ("SW".equals(scoutId)) {
            return this.m_viewStacks[0][2];
        }
        if ("S".equals(scoutId)) {
            return this.m_viewStacks[1][2];
        }
        if ("SE".equals(scoutId)) {
            return this.m_viewStacks[2][2];
        }
        return null;
    }

    public ViewAreaLayout getLayout() {
        return (ViewAreaLayout)super.getLayout();
    }

    private class P_SashSelectionListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_SashSelectionListener() {
        }

        public void handleEvent(Event event) {
            if (event.detail != 1) {
                int position = -1;
                Sash sash = (Sash)event.widget;
                Point size = sash.getParent().getSize();
                SashKey sashKey = (SashKey)((Object)sash.getData("SASH_KEY"));
                switch (sashKey) {
                    case VERTICAL_LEFT: {
                        position = event.x;
                        break;
                    }
                    case HORIZONTAL_LEFT_TOP: 
                    case HORIZONTAL_CENTER_TOP: 
                    case HORIZONTAL_RIGHT_TOP: {
                        position = event.y;
                        break;
                    }
                    case VERTICAL_RIGHT: {
                        position = size.x - event.x;
                        break;
                    }
                    case HORIZONTAL_LEFT_BOTTOM: 
                    case HORIZONTAL_CENTER_BOTTOM: 
                    case HORIZONTAL_RIGHT_BOTTOM: {
                        position = size.y - event.y;
                    }
                }
                if (position > 0) {
                    ViewArea.this.m_sashPositions.put(sashKey, new Integer(position));
                    ViewArea.this.layout();
                }
            }
        }
    }

    public static enum SashKey {
        VERTICAL_LEFT,
        VERTICAL_RIGHT,
        HORIZONTAL_LEFT_TOP,
        HORIZONTAL_LEFT_BOTTOM,
        HORIZONTAL_CENTER_TOP,
        HORIZONTAL_CENTER_BOTTOM,
        HORIZONTAL_RIGHT_TOP,
        HORIZONTAL_RIGHT_BOTTOM;

    }
}

