/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.form.IRwtScoutForm;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.scout.rt.ui.rap.window.AbstractRwtScoutPart;
import org.eclipse.scout.rt.ui.rap.window.DefaultFormBoundsProvider;
import org.eclipse.scout.rt.ui.rap.window.IFormBoundsProvider;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Form;

public class RwtScoutDialog
extends AbstractRwtScoutPart {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutDialog.class);
    private DialogImpl m_uiDialog;
    private Form m_uiForm;
    private Point m_uiInitialLocation;
    private Point m_uiInitialSize;
    private IFormBoundsProvider m_boundsProvider;

    protected void initInitialBounds(IFormBoundsProvider boundsProvider) {
        if (boundsProvider == null) {
            return;
        }
        Rectangle bounds = boundsProvider.getBounds();
        if (bounds != null) {
            this.setUiInitialLocation(new Point(bounds.x, bounds.y));
            this.setUiInitialSize(new Point(bounds.width, bounds.height));
        }
    }

    protected IFormBoundsProvider createFormBoundsProvider(IForm scoutForm, IRwtEnvironment uiEnvironment) {
        return new DefaultFormBoundsProvider(scoutForm, uiEnvironment);
    }

    @Override
    public void setBusy(boolean b) {
        this.getUiForm().setBusy(b);
        this.getUiForm().layout(true);
    }

    @Override
    public Form getUiForm() {
        return this.m_uiForm;
    }

    public void setUiInitialLocation(Point initialLocation) {
        this.m_uiInitialLocation = initialLocation;
    }

    public Point getUiInitialLocation() {
        return this.m_uiInitialLocation;
    }

    public Point getUiInitialSize() {
        return this.m_uiInitialSize;
    }

    public void setUiInitialSize(Point uiInitialSize) {
        this.m_uiInitialSize = uiInitialSize;
    }

    public void createPart(IForm scoutForm, Shell parentShell, IRwtEnvironment uiEnvironment) {
        this.createPart(scoutForm, parentShell, 68720, uiEnvironment);
    }

    public void createPart(IForm scoutForm, Shell parentShell, int style, IRwtEnvironment uiEnvironment) {
        super.createPart(scoutForm, uiEnvironment);
        if (scoutForm.isCacheBounds()) {
            this.m_boundsProvider = this.createFormBoundsProvider(scoutForm, this.getUiEnvironment());
            this.initInitialBounds(this.m_boundsProvider);
        }
        this.m_uiDialog = new DialogImpl((Shell)((style & 0x10000) != 0 ? parentShell : null), style);
        this.m_uiDialog.create();
        this.m_uiDialog.getShell().addShellListener(new ShellListener(){
            private static final long serialVersionUID = 1L;

            public void shellDeactivated(ShellEvent e) {
                RwtScoutDialog.this.getUiEnvironment().invokeScoutLater(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutDialog.this.getScoutObject().toBack();
                    }
                }, 5432L);
            }

            public void shellClosed(ShellEvent e) {
            }

            public void shellActivated(ShellEvent e) {
                RwtScoutDialog.this.getUiEnvironment().invokeScoutLater(new Runnable(){

                    @Override
                    public void run() {
                        RwtScoutDialog.this.getScoutObject().toFront();
                    }
                }, 5432L);
            }
        });
    }

    protected Control createContentsDelegate(Composite parent) {
        GridData d;
        this.m_uiForm = this.getUiEnvironment().getFormToolkit().createForm(parent);
        Composite contentPane = this.m_uiForm.getBody();
        try {
            contentPane.setRedraw(false);
            IRwtScoutForm rwtForm = this.getUiEnvironment().createForm(contentPane, this.getScoutObject());
            d = new GridData(1808);
            rwtForm.getUiContainer().setLayoutData((Object)d);
            this.attachScout();
        }
        finally {
            contentPane.setRedraw(true);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        contentPane.setLayout((Layout)gridLayout);
        d = new GridData(1808);
        this.m_uiForm.setLayoutData((Object)d);
        return this.m_uiForm;
    }

    @Override
    protected void showPartImpl() {
        this.m_uiDialog.setBlockOnOpen(false);
        this.m_uiDialog.open();
    }

    @Override
    protected void closePartImpl() {
        try {
            Control focusControl;
            if (this.m_boundsProvider != null) {
                this.m_boundsProvider.storeBounds(this.m_uiDialog.getShell().getBounds());
            }
            if ((focusControl = this.m_uiDialog.getShell().getDisplay().getFocusControl()) != null) {
                focusControl.isDisposed();
            }
            this.detachScout();
        }
        finally {
            this.m_uiDialog.closePhysically();
        }
    }

    @Override
    protected void setImageFromScout() {
        String iconId = this.getScoutObject().getIconId();
        Image img = this.getUiEnvironment().getIcon(iconId);
        this.m_uiDialog.getShell().setImage(img);
        String sub = this.getScoutObject().getSubTitle();
        if (sub != null) {
            this.getUiForm().setImage(img);
        } else {
            this.getUiForm().setImage(null);
        }
    }

    @Override
    protected void setTitleFromScout() {
        IForm f = this.getScoutObject();
        String s = f.getBasicTitle();
        this.m_uiDialog.getShell().setText(StringUtility.removeNewLines((String)(s != null ? s : "")));
        s = f.getSubTitle();
        if (s != null) {
            this.getUiForm().setText(RwtUtility.escapeMnemonics(StringUtility.removeNewLines((String)(s != null ? s : ""))));
        } else {
            this.getUiForm().setText(null);
        }
    }

    @Override
    public void activate() {
        this.m_uiDialog.getShell().setActive();
    }

    @Override
    public boolean isActive() {
        return this.m_uiDialog.getShell() == this.getUiEnvironment().getDisplay().getActiveShell();
    }

    @Override
    public boolean isVisible() {
        return this.m_uiDialog.getShell().isVisible();
    }

    @Override
    public boolean setStatusLineMessage(Image image, String message) {
        return false;
    }

    private class DialogImpl
    extends Dialog {
        private static final long serialVersionUID = 1L;

        public DialogImpl(Shell parentShell, int style) {
            super(parentShell);
            this.setShellStyle(style);
        }

        protected Control createContents(Composite parent) {
            return RwtScoutDialog.this.createContentsDelegate(parent);
        }

        protected final Control createButtonBar(Composite parent) {
            return null;
        }

        public boolean close() {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    RwtScoutDialog.this.getScoutObject().getUIFacade().fireFormClosingFromUI();
                }
            };
            RwtScoutDialog.this.getUiEnvironment().invokeScoutLater(job, 0L);
            return false;
        }

        public boolean closePhysically() {
            return super.close();
        }

        protected Point getInitialLocation(Point initialSize) {
            if (RwtScoutDialog.this.m_uiInitialLocation != null) {
                return RwtScoutDialog.this.m_uiInitialLocation;
            }
            return super.getInitialLocation(initialSize);
        }

        protected Point getInitialSize() {
            if (RwtScoutDialog.this.m_uiInitialSize != null) {
                return RwtScoutDialog.this.m_uiInitialSize;
            }
            return super.getInitialSize();
        }
    }
}

