/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.messagebox;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxEvent;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxListener;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.form.fields.groupbox.layout.ButtonBarLayout;
import org.eclipse.scout.rt.ui.rap.form.fields.groupbox.layout.ButtonBarLayoutData;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RwtScoutMessageBoxDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private P_ScoutMessageBoxListener m_scoutMessageBoxListener;
    private final IMessageBox m_scoutObject;
    private IRwtEnvironment m_uiEnvironment;
    private Label m_imageLabel;
    private Label m_introLabel;
    private Label m_actionLabel;

    public RwtScoutMessageBoxDialog(Shell parentShell, IMessageBox scoutObject, IRwtEnvironment uiEnvironment) {
        super(parentShell);
        this.m_scoutObject = scoutObject;
        this.m_uiEnvironment = uiEnvironment;
        int dialogStyle = 67680;
        this.setShellStyle(dialogStyle);
        this.setBlockOnOpen(false);
    }

    public void create() {
        super.create();
        this.attachScout();
    }

    void attachScout() {
        if (this.m_scoutMessageBoxListener == null) {
            this.m_scoutMessageBoxListener = new P_ScoutMessageBoxListener();
            this.getScoutObject().addMessageBoxListener((MessageBoxListener)this.m_scoutMessageBoxListener);
        }
        this.setTitleTextFromScout(this.getScoutObject().getTitle());
        this.setIntroTextFromScout(this.getScoutObject().getIntroText());
        this.setActionTextFromScout(this.getScoutObject().getActionText());
        this.setImageFromScout(this.getScoutObject().getIconId());
    }

    protected void setImageFromScout(String iconId) {
        Image icon = this.getUiEnvironment().getIcon(iconId);
        this.setImageInternal(icon);
    }

    private void setImageInternal(Image img) {
        boolean exclude = false;
        if (img == null) {
            exclude = true;
        }
        this.m_imageLabel.setImage(img);
        if (this.m_imageLabel.getLayoutData() instanceof GridData && ((GridData)this.m_imageLabel.getLayoutData()).exclude != exclude) {
            GridData gridData = (GridData)this.m_imageLabel.getLayoutData();
            if (gridData.exclude != exclude) {
                gridData.exclude = exclude;
                this.m_imageLabel.getParent().getParent().layout(true, true);
                this.getShell().layout(true);
            }
        }
    }

    protected void setTitleTextFromScout(String titleText) {
        if (titleText == null) {
            titleText = "";
        }
        this.getShell().setText(titleText);
        this.getShell().layout(true);
    }

    protected void setIntroTextFromScout(String introText) {
        boolean exclude = false;
        if (introText == null) {
            introText = "";
            exclude = true;
        }
        this.m_introLabel.setText(introText);
        if (this.m_introLabel.getLayoutData() instanceof GridData) {
            GridData gridData = (GridData)this.m_introLabel.getLayoutData();
            if (gridData.exclude != exclude) {
                gridData.exclude = exclude;
                this.getShell().layout(true);
                this.m_introLabel.getParent().getParent().layout(true, true);
            }
        }
        this.m_introLabel.setVisible(StringUtility.hasText((String)this.m_introLabel.getText()));
    }

    protected void setActionTextFromScout(String actionText) {
        if (this.getScoutObject().getIntroText() == null) {
            this.setIntroTextFromScout(actionText);
            actionText = null;
        }
        boolean exclude = false;
        if (actionText == null) {
            actionText = "";
            exclude = true;
        }
        this.m_actionLabel.setText(actionText);
        if (this.m_actionLabel.getLayoutData() instanceof GridData) {
            GridData gridData = (GridData)this.m_actionLabel.getLayoutData();
            if (gridData.exclude != exclude) {
                gridData.exclude = exclude;
                this.getShell().layout(true, true);
                this.m_actionLabel.getParent().getParent().layout(true, true);
            }
        }
        this.m_actionLabel.setVisible(StringUtility.hasText((String)this.m_actionLabel.getText()));
    }

    protected void dettachScout() {
        if (this.m_scoutMessageBoxListener == null) {
            this.m_scoutMessageBoxListener = new P_ScoutMessageBoxListener();
            this.getScoutObject().addMessageBoxListener((MessageBoxListener)this.m_scoutMessageBoxListener);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        Control header = this.createHeaderArea(container);
        this.m_actionLabel = this.getUiEnvironment().getFormToolkit().createLabel(container, "", 16448);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout dialogAreaLayout = new GridLayout(1, true);
        dialogAreaLayout.marginHeight = 12;
        dialogAreaLayout.marginWidth = 12;
        container.setLayout((Layout)dialogAreaLayout);
        GridData gridData = new GridData(512);
        header.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        gridData.horizontalIndent = 5;
        this.m_actionLabel.setLayoutData((Object)gridData);
        container.setTabList(new Control[0]);
        return container;
    }

    private Control createHeaderArea(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        this.m_imageLabel = this.getUiEnvironment().getFormToolkit().createLabel(container, "");
        this.m_introLabel = this.getUiEnvironment().getFormToolkit().createLabel(container, "", 16448);
        GridLayout headerLayout = new GridLayout(2, false);
        headerLayout.marginBottom = 7;
        headerLayout.marginWidth = 0;
        headerLayout.horizontalSpacing = 5;
        container.setLayout((Layout)headerLayout);
        GridData gridData = new GridData(2);
        gridData.exclude = true;
        this.m_imageLabel.setLayoutData((Object)gridData);
        gridData = new GridData(1840);
        gridData.horizontalIndent = 7;
        gridData.verticalIndent = 0;
        gridData.exclude = true;
        this.m_introLabel.setLayoutData((Object)gridData);
        return container;
    }

    protected Control createButtonBar(Composite parent) {
        ButtonBarLayoutData data;
        if (this.getScoutObject().getYesButtonText() == null && this.getScoutObject().getNoButtonText() == null && this.getScoutObject().getCancelButtonText() == null && this.getScoutObject().getHiddenText() == null) {
            return null;
        }
        Composite buttonArea = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        int inset = 10;
        Button defaultButton = null;
        buttonArea.setBackground(this.getUiEnvironment().getDisplay().getSystemColor(22));
        if (this.getScoutObject().getYesButtonText() != null) {
            Button yesButton = this.createButton(buttonArea, this.getScoutObject().getYesButtonText(), null, 0);
            data = new ButtonBarLayoutData();
            data.insetTop = inset;
            data.insetBottom = inset;
            data.insetRight = inset;
            yesButton.setLayoutData((Object)data);
            Button button = defaultButton = defaultButton == null ? yesButton : defaultButton;
        }
        if (this.getScoutObject().getNoButtonText() != null) {
            Button noButton = this.createButton(buttonArea, this.getScoutObject().getNoButtonText(), null, 1);
            data = new ButtonBarLayoutData();
            data.insetTop = inset;
            data.insetBottom = inset;
            data.insetRight = inset;
            noButton.setLayoutData((Object)data);
            Button button = defaultButton = defaultButton == null ? noButton : defaultButton;
        }
        if (this.getScoutObject().getCancelButtonText() != null) {
            Button cancelButton = this.createButton(buttonArea, this.getScoutObject().getCancelButtonText(), null, 2);
            data = new ButtonBarLayoutData();
            data.insetTop = inset;
            data.insetBottom = inset;
            data.insetRight = inset;
            cancelButton.setLayoutData((Object)data);
            Button button = defaultButton = defaultButton == null ? cancelButton : defaultButton;
        }
        if (defaultButton != null) {
            defaultButton.setFocus();
            this.getShell().setDefaultButton(defaultButton);
            final Button fDefaultButton = defaultButton;
            this.m_uiEnvironment.addKeyStroke((Control)this.getShell(), new RwtKeyStroke(13){

                @Override
                public void handleUiAction(Event e) {
                    fDefaultButton.notifyListeners(13, null);
                }
            }, false);
        }
        this.m_uiEnvironment.addKeyStroke((Control)this.getShell(), new RwtKeyStroke(27){

            @Override
            public void handleUiAction(Event e) {
                RwtScoutMessageBoxDialog.this.cancelPressed();
            }
        }, false);
        this.getShell().addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent event) {
                RwtScoutMessageBoxDialog.this.m_uiEnvironment.removeKeyStrokes((Control)RwtScoutMessageBoxDialog.this.getShell());
            }
        });
        GridData gridData = new GridData(768);
        buttonArea.setLayoutData((Object)gridData);
        ButtonBarLayout layout = new ButtonBarLayout(131072);
        layout.horizontalGap = 0;
        buttonArea.setLayout((Layout)layout);
        return buttonArea;
    }

    protected Button createButton(Composite parent, String text, String iconId, int buttonId) {
        Button b = this.getUiEnvironment().getFormToolkit().createButton(parent, text, 8);
        if (iconId != null) {
            b.setImage(this.getUiEnvironment().getIcon(iconId));
        }
        if (buttonId >= 0) {
            b.addSelectionListener((SelectionListener)new P_RwtButtonListener(buttonId));
        }
        return b;
    }

    protected Point getInitialSize() {
        Point buttonBarSize = this.getButtonBar() == null ? new Point(0, 0) : this.getButtonBar().computeSize(-1, -1, true);
        Point initialSize = this.getShell().computeSize(UiDecorationExtensionPoint.getLookAndFeel().getMessageBoxMinWidth(), -1, true);
        initialSize.x = Math.max(buttonBarSize.x + 20, UiDecorationExtensionPoint.getLookAndFeel().getMessageBoxMinWidth());
        initialSize.y = Math.max(initialSize.y, UiDecorationExtensionPoint.getLookAndFeel().getMessageBoxMinHeight());
        return initialSize;
    }

    public int open() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            this.create();
        }
        this.initializeBounds();
        return super.open();
    }

    public boolean close() {
        this.handleUiButtonSelection(2);
        return false;
    }

    public void closeNoFire() {
        super.close();
    }

    private IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    public IMessageBox getScoutObject() {
        return this.m_scoutObject;
    }

    protected void handleScoutMessageBoxClosed(MessageBoxEvent e) {
        this.dettachScout();
        this.closeNoFire();
    }

    private void handleUiButtonSelection(final int buttonId) {
        Runnable j = new Runnable(){

            @Override
            public void run() {
                RwtScoutMessageBoxDialog.this.getScoutObject().getUIFacade().setResultFromUI(buttonId);
            }
        };
        this.getUiEnvironment().invokeScoutLater(j, 0L);
    }

    private class P_RwtButtonListener
    extends SelectionAdapter {
        private static final long serialVersionUID = 1L;
        private final int m_buttonId;

        P_RwtButtonListener(int buttonId) {
            this.m_buttonId = buttonId;
        }

        public void widgetSelected(SelectionEvent e) {
            RwtScoutMessageBoxDialog.this.handleUiButtonSelection(this.m_buttonId);
        }
    }

    private class P_ScoutMessageBoxListener
    implements MessageBoxListener {
        private P_ScoutMessageBoxListener() {
        }

        public void messageBoxChanged(final MessageBoxEvent e) {
            switch (e.getType()) {
                case 900: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            switch (e.getType()) {
                                case 900: {
                                    RwtScoutMessageBoxDialog.this.handleScoutMessageBoxClosed(e);
                                }
                            }
                        }
                    };
                    RwtScoutMessageBoxDialog.this.getUiEnvironment().invokeUiLater(t);
                }
            }
        }
    }
}

