/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.svg.calendar.builder;

import java.awt.Point;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.dom.svg.SVGTextContentSupport;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.ui.svg.calendar.Activator;
import org.eclipse.scout.rt.ui.svg.calendar.CalendarSvgUtility;
import org.eclipse.scout.rt.ui.svg.calendar.builder.CalendarDayBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.builder.CalendarMonthBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.builder.CalendarWeekBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.builder.CalendarWorkWeekBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.builder.listener.CalendarDocumentEvent;
import org.eclipse.scout.rt.ui.svg.calendar.builder.listener.ICalendarDocumentListener;
import org.eclipse.scout.rt.ui.svg.calendar.comp.IComponentElementFactory;
import org.eclipse.scout.svg.client.SVGUtility;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGStylable;

public abstract class AbstractCalendarDocumentBuilder {
    private static final Pattern REGEX_URL_GRID_CLICK = Pattern.compile("http://local/grid/([0-9]{1})([0-9]{1})");
    private static final Pattern REGEX_URL_COMP_CLICK = Pattern.compile("http://local/comp/([0-9]*)/([0-9]{1})([0-9]{1})");
    public static final float ORIG_CALENDAR_WIDTH = 557.0f;
    public static final float ORIG_CALENDAR_HEIGHT = 464.667f;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCalendarDocumentBuilder.class);
    private static final float MIN_FONT_SIZE = 8.0f;
    private static final float ORIG_FONT_SIZE = 12.0f;
    private static final float MAX_FONT_SIZE = 23.0f;
    private static final int NUM_TIME_LINE_ROWS = 15;
    protected static final int NUM_DAYS_IN_WEEK = 7;
    private static final String LINK_NEXT_SMALL = "http://local/arrow/nextSmall";
    private static final String LINK_NEXT_BIG = "http://local/arrow/nextBig";
    private static final String LINK_PREV_SMALL = "http://local/arrow/prevSmall";
    private static final String LINK_PREV_BIG = "http://local/arrow/prevBig";
    private static final String LINK_CONTEXT_MENU = "http://local/menu";
    private static final String FONT = "Arial";
    private static final String PROP_GRID_DATE = "Date";
    private static final String LINK_COMPONENT_PREFIX = "http://local/comp/";
    private static final String LINK_DISPLAY_MODE_PREFIX = "http://local/displayMode/";
    private static final String LINK_GRID_PREFIX = "http://local/grid/";
    private static final String COLOR_LINKS = "#67a8ce";
    private static final String COLOR_BLACK = "#000000";
    private static final String COLOR_WHITE = "#ffffff";
    private static final String COLOR_FOREIGN_MONTH_BACKGROUND = "#eeeeee";
    private static final String COLOR_TIME_LINE = "#cccccc";
    private static final String COLOR_MONTH_BACKGROUND = "#ffffff";
    private static final String COLOR_SELECTED_DAY_BORDER = "#000000";
    private static final String COLOR_NOT_SELECTED_DAY_BORDER = "#c0c0c0";
    private final BridgeContext m_bridgeContext;
    private final EventListenerList m_listenerList;
    private final String[] m_monthsLabels;
    private final String[] m_weekDayLabels;
    private final String[] m_weekDayLongLabels;
    private final String[] m_displayModeLabels;
    private final int m_firstDayOfWeek;
    private final float[] m_displayModeTextWidth;
    private final Element[] m_elDisplayMode;
    private final Element m_elTitle;
    private final Element m_elComponentsContainer;
    private final Element m_elMoveNextBig;
    private final Element m_elMoveNextSmall;
    private final Element m_elMovePrevBig;
    private final Element m_elMovePrevSmall;
    private final Element m_elLinkMenuContainer;
    private final Element[][] m_elGridBox;
    private final Element[][] m_elGridText;
    private final Element[][] m_elTimeLineGrid;
    private final Element[] m_elTimeLineTexts;
    private final Element[] m_elWeekDayHeadings;
    private final Element m_elMenuContainer;
    private Element m_selectedElement;
    private Date m_selectedDate;
    private Date m_shownDate;
    private Date m_startDate;
    private Date m_endDate;
    private CalendarComponent m_selectedComponent;
    private CalendarComponent[] m_components;
    private int m_numContextMenus;

    protected AbstractCalendarDocumentBuilder(String svgFile) {
        InputStream is = null;
        try {
            try {
                is = Activator.getDefault().getBundle().getResource(svgFile).openStream();
                this.m_bridgeContext = SVGUtility.readSVGDocumentForGraphicalModification((InputStream)is);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find svg resource '" + svgFile + "'", e);
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        this.m_listenerList = new EventListenerList();
        DateFormatSymbols dateSymbols = new DateFormatSymbols(LocaleThreadLocal.get());
        this.m_monthsLabels = dateSymbols.getMonths();
        this.m_weekDayLabels = dateSymbols.getShortWeekdays();
        this.m_weekDayLongLabels = dateSymbols.getWeekdays();
        this.m_displayModeLabels = new String[]{ScoutTexts.get((String)"Day", (String[])new String[0]), ScoutTexts.get((String)"WorkWeek", (String[])new String[0]), ScoutTexts.get((String)"Week", (String[])new String[0]), ScoutTexts.get((String)"Month", (String[])new String[0])};
        this.m_firstDayOfWeek = AbstractCalendarDocumentBuilder.createCalendar().getFirstDayOfWeek();
        SVGDocument doc = this.getSVGDocument();
        this.m_elComponentsContainer = doc.getElementById("Components");
        this.m_elTitle = doc.getElementById("Title");
        this.m_elLinkMenuContainer = doc.getElementById("LinkMenuLayer");
        this.m_elMoveNextBig = doc.getElementById("nextYear");
        this.m_elMoveNextSmall = doc.getElementById("nextMonth");
        this.m_elMovePrevBig = doc.getElementById("prevYear");
        this.m_elMovePrevSmall = doc.getElementById("prevMonth");
        this.m_elGridBox = this.getGridElements("b", this.getNumWeekdays(), this.getNumWeeks());
        this.m_elGridText = this.getGridElements("t", this.getNumWeekdays(), this.getNumWeeks());
        this.m_elWeekDayHeadings = new Element[]{doc.getElementById("Mo"), doc.getElementById("Tu"), doc.getElementById("We"), doc.getElementById("Th"), doc.getElementById("Fr"), doc.getElementById("Sa"), doc.getElementById("So")};
        this.m_elDisplayMode = new Element[]{doc.getElementById("displayModeDay"), doc.getElementById("displayModeWorkWeek"), doc.getElementById("displayModeWeek"), doc.getElementById("displayModeMonth")};
        this.m_elMenuContainer = doc.getElementById("MenuLayer");
        this.m_elTimeLineGrid = this.getGridElements("tlg", this.getNumWeekdays(), 15);
        this.m_elTimeLineTexts = new Element[15];
        int i = 0;
        while (i < this.m_elTimeLineTexts.length) {
            this.m_elTimeLineTexts[i] = doc.getElementById("tlt" + i);
            ++i;
        }
        this.m_displayModeTextWidth = new float[this.m_elDisplayMode.length];
        CalendarSvgUtility.setFont(this.m_elTitle, FONT);
        this.visitGrid(this.m_elGridText, new IGridVisitor(){

            @Override
            public void visit(Element element, int weekday, int week) {
                if (element != null) {
                    CalendarSvgUtility.setFont(element, AbstractCalendarDocumentBuilder.FONT);
                }
            }
        });
        if (this.hasTimeLine()) {
            i = 0;
            while (i < this.m_elTimeLineTexts.length) {
                if (this.m_elTimeLineTexts[i] != null) {
                    CalendarSvgUtility.setFont(this.m_elTimeLineTexts[i], FONT);
                }
                ++i;
            }
        }
        CalendarSvgUtility.setFontWeightBold(this.m_elTitle);
        CalendarSvgUtility.setTextAlignCenter(this.m_elTitle);
        SVGUtility.addHyperlink((Element)this.m_elMoveNextBig, (String)LINK_NEXT_BIG);
        SVGUtility.addHyperlink((Element)this.m_elMovePrevSmall, (String)LINK_PREV_SMALL);
        SVGUtility.addHyperlink((Element)this.m_elMoveNextSmall, (String)LINK_NEXT_SMALL);
        SVGUtility.addHyperlink((Element)this.m_elMovePrevBig, (String)LINK_PREV_BIG);
        this.initWeekdayHeadingNames();
        this.initDisplayModeLinks();
        this.initTimeLineText();
        this.initGridHyperlink();
    }

    protected abstract int getNumWeekdays();

    protected abstract int getNumWeeks();

    protected abstract int getSmallNextField();

    protected abstract int getBigNextField();

    protected abstract void truncateToRange(Calendar var1);

    protected abstract String getRangeTitle(Calendar var1);

    protected abstract String getDayTitle(Calendar var1);

    protected abstract boolean hasTimeLine();

    protected abstract int getDisplayMode();

    protected abstract IComponentElementFactory getComponentElementFactory();

    public void hyperlinkActivated(String hyperlinkUrl) {
        Date currentDate = this.getShownDate();
        if (currentDate == null) {
            return;
        }
        Calendar cal = AbstractCalendarDocumentBuilder.createCalendar(currentDate);
        if (LINK_NEXT_SMALL.equals(hyperlinkUrl)) {
            cal.add(this.getSmallNextField(), 1);
            this.setShownDate(cal.getTime());
        } else if (LINK_NEXT_BIG.equals(hyperlinkUrl)) {
            cal.add(this.getBigNextField(), 1);
            this.setShownDate(cal.getTime());
        } else if (LINK_PREV_SMALL.equals(hyperlinkUrl)) {
            cal.add(this.getSmallNextField(), -1);
            this.setShownDate(cal.getTime());
        } else if (LINK_PREV_BIG.equals(hyperlinkUrl)) {
            cal.add(this.getBigNextField(), -1);
            this.setShownDate(cal.getTime());
        } else if (LINK_CONTEXT_MENU.equals(hyperlinkUrl)) {
            this.firePopupMenuActivatedEvent();
        } else if (hyperlinkUrl.startsWith(LINK_GRID_PREFIX)) {
            Matcher m = REGEX_URL_GRID_CLICK.matcher(hyperlinkUrl);
            if (m.matches()) {
                int weekday = Integer.parseInt(m.group(1));
                int week = Integer.parseInt(m.group(2));
                Date clickedDate = this.getDateAt(weekday, week);
                this.setSelection(clickedDate);
            }
        } else if (hyperlinkUrl.startsWith(LINK_COMPONENT_PREFIX)) {
            Matcher m = REGEX_URL_COMP_CLICK.matcher(hyperlinkUrl);
            if (m.matches()) {
                long id = Long.parseLong(m.group(1));
                int weekday = Integer.parseInt(m.group(2));
                int week = Integer.parseInt(m.group(3));
                Date clickedDate = this.getDateAt(weekday, week);
                CalendarComponent selected = this.getComponentWithId(id);
                this.setSelection(clickedDate, selected);
            }
        } else if (hyperlinkUrl.startsWith(LINK_DISPLAY_MODE_PREFIX)) {
            int displayMode = Integer.parseInt(hyperlinkUrl.substring(LINK_DISPLAY_MODE_PREFIX.length()));
            this.fireDisplayModeLinkActivatedEvent(displayMode);
        }
    }

    public static Calendar createCalendar(Date initDate) {
        Calendar cal = AbstractCalendarDocumentBuilder.createCalendar();
        cal.setTime(initDate);
        return cal;
    }

    public static Calendar createCalendar() {
        return new GregorianCalendar(LocaleThreadLocal.get());
    }

    public static AbstractCalendarDocumentBuilder createInstance(int displayMode) {
        switch (displayMode) {
            case 1: {
                return new CalendarDayBuilder();
            }
            case 4: {
                return new CalendarWorkWeekBuilder();
            }
            case 2: {
                return new CalendarWeekBuilder();
            }
            case 3: {
                return new CalendarMonthBuilder();
            }
        }
        return null;
    }

    private void initDisplayModeLinks() {
        int[] linkMenuIds = new int[]{1, 4, 2, 3};
        float xPos = 4.0f;
        int i = 0;
        while (i < this.m_elDisplayMode.length) {
            boolean isCurrentDisplayMode = linkMenuIds[i] == this.getDisplayMode();
            Element e = this.m_elDisplayMode[i];
            e.setTextContent(this.m_displayModeLabels[i]);
            CalendarSvgUtility.setFontWeightNormal(e);
            CalendarSvgUtility.setFont(e, FONT);
            CalendarSvgUtility.setFontSize(e, 12.0f);
            CalendarSvgUtility.setFontColor(e, COLOR_LINKS, isCurrentDisplayMode);
            CalendarSvgUtility.setCalendarDisplayModeXPos(e, xPos);
            this.m_displayModeTextWidth[i] = xPos;
            SVGUtility.addHyperlink((Element)e, (String)(LINK_DISPLAY_MODE_PREFIX + linkMenuIds[i]));
            xPos += SVGTextContentSupport.getComputedTextLength((Element)e) + 12.0f;
            if (isCurrentDisplayMode) {
                CalendarSvgUtility.setFontWeightBold(e);
            }
            ++i;
        }
    }

    private void initTimeLineText() {
        Element late;
        Element early = this.getSVGDocument().getElementById("tlt0");
        if (early != null) {
            early.setTextContent(ScoutTexts.get((String)"Calendar_earlier", (String[])new String[0]));
        }
        if ((late = this.getSVGDocument().getElementById("tlt13")) != null) {
            late.setTextContent(ScoutTexts.get((String)"Calendar_later", (String[])new String[0]));
        }
    }

    private void initGridHyperlink() {
        if (this.hasTimeLine()) {
            this.visitGrid(this.m_elGridBox, new IGridVisitor(){

                @Override
                public void visit(Element element, int x, int y) {
                    int i = 0;
                    while (i < AbstractCalendarDocumentBuilder.this.m_elTimeLineGrid.length) {
                        SVGUtility.addHyperlink((Element)AbstractCalendarDocumentBuilder.this.m_elTimeLineGrid[i][x], (String)AbstractCalendarDocumentBuilder.this.getGridClickUrl(x, y));
                        ++i;
                    }
                }
            });
        } else {
            this.visitGrid(this.m_elGridBox, new IGridVisitor(){

                @Override
                public void visit(Element element, int x, int y) {
                    SVGUtility.addHyperlink((Element)element, (String)AbstractCalendarDocumentBuilder.this.getGridClickUrl(x, y));
                }
            });
            this.visitGrid(this.m_elGridText, new IGridVisitor(){

                @Override
                public void visit(Element element, int x, int y) {
                    SVGUtility.addHyperlink((Element)element, (String)AbstractCalendarDocumentBuilder.this.getGridClickUrl(x, y));
                }
            });
        }
    }

    private void initWeekdayHeadingNames() {
        int weekstart = this.m_firstDayOfWeek - 1;
        int numDays = Math.min(this.m_elWeekDayHeadings.length, this.getNumWeekdays());
        int i = 0;
        while (i < numDays) {
            String label = this.getWeekDayLabel(1 + (i + weekstart) % 7);
            Element e = this.m_elWeekDayHeadings[i];
            if (e != null) {
                e.setTextContent(label);
                CalendarSvgUtility.setFontWeightBold(e);
                CalendarSvgUtility.setTextAlignCenter(e);
                CalendarSvgUtility.setFont(e, FONT);
            }
            ++i;
        }
    }

    public void setSize(int w, int h) {
        Element e;
        float ratio = Math.max(Math.min((float)w / 557.0f, 1.5f), 0.5217391f);
        final float newFontSize = 12.0f / ratio;
        CalendarSvgUtility.setFontSize(this.m_elTitle, newFontSize);
        this.visitGrid(this.m_elGridText, new IGridVisitor(){

            @Override
            public void visit(Element element, int weekday, int week) {
                if (element != null) {
                    CalendarSvgUtility.setFontSize(element, newFontSize);
                }
            }
        });
        Element[] elementArray = this.m_elWeekDayHeadings;
        int n = this.m_elWeekDayHeadings.length;
        int n2 = 0;
        while (n2 < n) {
            e = elementArray[n2];
            if (e != null) {
                CalendarSvgUtility.setFontSize(e, newFontSize);
            }
            ++n2;
        }
        elementArray = CalendarSvgUtility.getAllChildElements(this.m_elComponentsContainer, "text");
        n = elementArray.length;
        n2 = 0;
        while (n2 < n) {
            e = elementArray[n2];
            CalendarSvgUtility.setFontSize(e, newFontSize);
            CalendarSvgUtility.setFont(e, FONT);
            ++n2;
        }
        if (this.hasTimeLine()) {
            elementArray = this.m_elTimeLineTexts;
            n = this.m_elTimeLineTexts.length;
            n2 = 0;
            while (n2 < n) {
                e = elementArray[n2];
                if (e != null) {
                    CalendarSvgUtility.setFontSize(e, newFontSize);
                }
                ++n2;
            }
        }
        int i = 0;
        while (i < this.m_elDisplayMode.length) {
            CalendarSvgUtility.setFontSize(this.m_elDisplayMode[i], newFontSize);
            CalendarSvgUtility.setCalendarDisplayModeXPos(this.m_elDisplayMode[i], this.m_displayModeTextWidth[i] / ratio);
            ++i;
        }
    }

    private Element[][] getGridElements(final String idPrefix, int numX, int numY) {
        final Element[][] ret = new Element[numY][numX];
        this.visitGrid(ret, new IGridVisitor(){

            @Override
            public void visit(Element element, int weekday, int week) {
                ret[week][weekday] = AbstractCalendarDocumentBuilder.this.getSVGDocument().getElementById(String.valueOf(idPrefix) + weekday + week);
            }
        });
        return ret;
    }

    private void visitGrid(Element[][] grid, IGridVisitor visitor) {
        int row = 0;
        while (row < grid.length) {
            int col = 0;
            while (col < grid[row].length) {
                visitor.visit(grid[row][col], col, row);
                ++col;
            }
            ++row;
        }
    }

    public void addCalendarDocumentListener(ICalendarDocumentListener listener) {
        this.m_listenerList.add(ICalendarDocumentListener.class, (EventListener)listener);
    }

    public void removeCalendarDocumentListener(ICalendarDocumentListener listener) {
        this.m_listenerList.remove(ICalendarDocumentListener.class, (EventListener)listener);
    }

    private void firePopupMenuActivatedEvent() {
        CalendarDocumentEvent event = new CalendarDocumentEvent(1);
        this.fireCalendarDocumentEvent(event);
    }

    private void fireDisplayModeLinkActivatedEvent(int mode) {
        CalendarDocumentEvent event = new CalendarDocumentEvent(8);
        event.displayMode = mode;
        this.fireCalendarDocumentEvent(event);
    }

    private void fireSelectionChangedEvent(Date selectedDate, CalendarComponent selectedComponent) {
        CalendarDocumentEvent event = new CalendarDocumentEvent(2);
        event.selectedDate = selectedDate;
        event.selectedComponent = selectedComponent;
        this.fireCalendarDocumentEvent(event);
    }

    private void fireVisibleRangeChangedEvent(Date start, Date end) {
        CalendarDocumentEvent event = new CalendarDocumentEvent(4);
        event.startDate = start;
        event.endDate = end;
        this.fireCalendarDocumentEvent(event);
    }

    private void fireCalendarDocumentEvent(CalendarDocumentEvent event) {
        ICalendarDocumentListener[] iCalendarDocumentListenerArray = (ICalendarDocumentListener[])this.m_listenerList.getListeners(ICalendarDocumentListener.class);
        int n = iCalendarDocumentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICalendarDocumentListener l = iCalendarDocumentListenerArray[n2];
            try {
                switch (event.type) {
                    case 1: {
                        l.popupMenuActivated();
                        break;
                    }
                    case 2: {
                        l.selectionChanged(event.selectedDate, event.selectedComponent);
                        break;
                    }
                    case 4: {
                        l.visibleRangeChanged(event.startDate, event.endDate);
                        break;
                    }
                    case 8: {
                        l.displayModeMenuActivated(event.displayMode);
                        break;
                    }
                    default: {
                        throw new InvalidParameterException(String.valueOf(event.type) + " is no valid calendar document event type.");
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Calendar document listener error", (Throwable)ex);
            }
            ++n2;
        }
    }

    protected int getNumOfDaysInWeekBefore(Calendar cal) {
        int numDaysBefore = cal.get(7) - this.m_firstDayOfWeek;
        if (numDaysBefore < 0) {
            numDaysBefore += 7;
        }
        return numDaysBefore;
    }

    protected String getMonthLabel(int month) {
        return this.m_monthsLabels[month];
    }

    protected String getWeekDayLabel(int weekday) {
        return this.m_weekDayLabels[weekday];
    }

    protected String getWeekDayLabelLong(int weekday) {
        return this.m_weekDayLongLabels[weekday];
    }

    public void setShownDate(Date d) {
        this.m_shownDate = DateUtility.truncDate((Date)d);
        final Calendar cal = AbstractCalendarDocumentBuilder.createCalendar(this.getShownDate());
        final int month = cal.get(2);
        this.truncateToRange(cal);
        this.m_startDate = cal.getTime();
        Calendar end = AbstractCalendarDocumentBuilder.createCalendar();
        end.setTime(this.m_startDate);
        end.add(5, this.m_elGridBox.length * this.m_elGridBox[0].length);
        this.m_endDate = new Date(end.getTimeInMillis() - 1L);
        this.visitGrid(this.m_elGridBox, new IGridVisitor(){

            @Override
            public void visit(Element gridElement, int wd, int week) {
                Date curDate = cal.getTime();
                Element textElement = AbstractCalendarDocumentBuilder.this.m_elGridText[week][wd];
                if (textElement != null) {
                    String dayTitle = AbstractCalendarDocumentBuilder.this.getDayTitle(cal);
                    if (dayTitle != null) {
                        textElement.setTextContent(dayTitle);
                    }
                    CalendarSvgUtility.setTextAlignCenter(textElement);
                }
                String bgColor = null;
                bgColor = month != cal.get(2) ? AbstractCalendarDocumentBuilder.COLOR_FOREIGN_MONTH_BACKGROUND : "#ffffff";
                if (AbstractCalendarDocumentBuilder.this.hasTimeLine()) {
                    int i = 0;
                    while (i < AbstractCalendarDocumentBuilder.this.m_elTimeLineGrid.length) {
                        CalendarSvgUtility.setBackgroundColor(AbstractCalendarDocumentBuilder.this.m_elTimeLineGrid[i][wd], bgColor);
                        ++i;
                    }
                } else {
                    CalendarSvgUtility.setBackgroundColor(gridElement, bgColor);
                }
                gridElement.setUserData(AbstractCalendarDocumentBuilder.PROP_GRID_DATE, curDate, null);
                cal.add(5, 1);
            }
        });
        this.m_elTitle.setTextContent(this.getRangeTitle(AbstractCalendarDocumentBuilder.createCalendar(this.getShownDate())));
        this.setSelectedDate(this.getSelectedDate());
        this.refreshComponents();
        this.fireVisibleRangeChangedEvent(this.getStartDate(), this.getEndDate());
    }

    private Point getPosition(Date d) {
        if (this.isInRange(d)) {
            long dif = (d.getTime() - this.m_startDate.getTime()) / 86400000L;
            int x = (int)dif % 7;
            int y = (int)dif / 7;
            return new Point(x, y);
        }
        return null;
    }

    private Point getPosition(Element e) {
        return this.getPosition(this.getDateOfGridElement(e));
    }

    private Date getDateOfGridElement(Element e) {
        return (Date)e.getUserData(PROP_GRID_DATE);
    }

    private String getGridClickUrl(int weekday, int week) {
        return LINK_GRID_PREFIX + weekday + week;
    }

    public void setSelection(Date d) {
        this.setSelection(d, null);
    }

    public void setSelection(Date d, CalendarComponent c) {
        this.setSelectedDate(d);
        this.setSelectedComponent(c);
        this.fireSelectionChangedEvent(d, c);
    }

    private Date getSelectedDate() {
        return this.m_selectedDate;
    }

    private void setSelectedDate(Date d) {
        this.m_selectedDate = d;
        Point p = this.getPosition(d);
        if (p != null) {
            this.setHighlightedBox(p.x, p.y);
        } else {
            this.clearHighlightedBox();
        }
    }

    private CalendarComponent getSelectedComponent() {
        return this.m_selectedComponent;
    }

    private void setSelectedComponent(CalendarComponent c) {
        CalendarComponent old = this.m_selectedComponent;
        this.m_selectedComponent = c;
        if (old != this.m_selectedComponent) {
            this.refreshComponents();
        }
    }

    public CalendarComponent[] getComponents() {
        return this.m_components;
    }

    public void setComponents(CalendarComponent[] components) {
        this.m_components = components;
        HashMap<Date, HashSet<CalendarComponent>> map = new HashMap<Date, HashSet<CalendarComponent>>();
        if (this.m_components != null) {
            CalendarComponent[] calendarComponentArray = this.m_components;
            int n = this.m_components.length;
            int n2 = 0;
            while (n2 < n) {
                CalendarComponent c = calendarComponentArray[n2];
                Date[] dateArray = c.getCoveredDays();
                int n3 = dateArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Date d = dateArray[n4];
                    HashSet<Object> l = map.get(d);
                    if (l == null) {
                        l = new HashSet();
                        map.put(d, l);
                    }
                    l.add(c);
                    ++n4;
                }
                ++n2;
            }
        }
        this.refreshComponents(map);
    }

    private CalendarComponent getComponentWithId(long id) {
        CalendarComponent[] calendarComponentArray = this.getComponents();
        int n = calendarComponentArray.length;
        int n2 = 0;
        while (n2 < n) {
            CalendarComponent c = calendarComponentArray[n2];
            if (c != null && c.getItem() != null && c.getItem().getId() == id) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    private void refreshComponents() {
        this.setComponents(this.m_components);
    }

    private void refreshComponents(HashMap<Date, HashSet<CalendarComponent>> map) {
        CalendarSvgUtility.clearChildNodes(this.m_elComponentsContainer);
        for (Map.Entry<Date, HashSet<CalendarComponent>> e : map.entrySet()) {
            Point p = this.getPosition(e.getKey());
            if (p == null || e.getValue() == null) continue;
            Element parent = this.m_elGridBox[p.y][p.x];
            CalendarComponent[] comps = e.getValue().toArray(new CalendarComponent[e.getValue().size()]);
            IComponentElementFactory fact = this.getComponentElementFactory();
            if (fact == null) continue;
            fact.setSelectedComponent(this.getSelectedComponent());
            Map<CalendarComponent, Element> compEls = fact.create(parent, this.getDateOfGridElement(parent), comps);
            if (compEls == null || compEls.size() <= 0) continue;
            for (Map.Entry<CalendarComponent, Element> el : compEls.entrySet()) {
                this.m_elComponentsContainer.appendChild(el.getValue());
                SVGUtility.addHyperlink((Element)el.getValue(), (String)(LINK_COMPONENT_PREFIX + el.getKey().getItem().getId() + "/" + p.x + p.y));
            }
        }
    }

    private boolean isInRange(Date d) {
        if (this.m_startDate == null || this.m_endDate == null || d == null) {
            return false;
        }
        return d.after(this.m_startDate) && d.before(this.m_endDate) || d.equals(this.m_startDate) || d.equals(this.m_endDate);
    }

    private void clearHighlightedBox() {
        if (this.m_selectedElement != null) {
            this.setBorder(this.m_selectedElement, false);
            this.m_selectedElement = null;
        }
    }

    private void setBorder(Element element, boolean selected) {
        SVGStylable css = (SVGStylable)element;
        CalendarSvgUtility.setBorderColor(element, selected ? "#000000" : COLOR_NOT_SELECTED_DAY_BORDER);
        css.getStyle().setProperty("stroke-width", "2", "");
    }

    private void setHighlightedBox(int weekday, int week) {
        if (this.m_selectedElement != null) {
            this.setBorder(this.m_selectedElement, false);
        }
        this.m_selectedElement = this.m_elGridBox[week][weekday];
        this.setBorder(this.m_selectedElement, true);
    }

    private Date getDateAt(int weekday, int week) {
        return (Date)this.m_elGridBox[week][weekday].getUserData(PROP_GRID_DATE);
    }

    public Date getEndDate() {
        return this.m_endDate;
    }

    public Date getStartDate() {
        return this.m_startDate;
    }

    public SVGDocument getSVGDocument() {
        return (SVGDocument)this.m_bridgeContext.getDocument();
    }

    public void dispose() {
        this.m_bridgeContext.dispose();
    }

    public void setNumContextMenus(int numContextMenus) {
        this.m_numContextMenus = numContextMenus;
        this.refreshContextMenu();
    }

    public int getNumContextMenus() {
        return this.m_numContextMenus;
    }

    private Date getShownDate() {
        return this.m_shownDate;
    }

    private void refreshContextMenu() {
        CalendarSvgUtility.clearChildNodes(this.m_elMenuContainer);
        if (this.getNumContextMenus() > 0) {
            float[] rectDimensions = new float[]{536.088f, 447.602f, 14.912f, 14.914f};
            Element rect = this.getSVGDocument().createElementNS("http://www.w3.org/2000/svg", "rect");
            rect.setAttribute("x", "" + rectDimensions[0]);
            rect.setAttribute("y", "" + rectDimensions[1]);
            rect.setAttribute("width", "" + rectDimensions[2]);
            rect.setAttribute("height", "" + rectDimensions[3]);
            CalendarSvgUtility.setBorderColor(rect, COLOR_NOT_SELECTED_DAY_BORDER);
            CalendarSvgUtility.setBackgroundColor(rect, "#ffffff");
            this.m_elMenuContainer.appendChild(rect);
            SVGUtility.addHyperlink((Element)rect, (String)LINK_CONTEXT_MENU);
            Element triangle = this.getSVGDocument().createElementNS("http://www.w3.org/2000/svg", "polygon");
            triangle.setAttribute("points", "549.525,451.794 543.614,458.496 537.703,451.794");
            this.m_elMenuContainer.appendChild(triangle);
            SVGUtility.addHyperlink((Element)triangle, (String)LINK_CONTEXT_MENU);
        }
    }

    private static interface IGridVisitor {
        public void visit(Element var1, int var2, int var3);
    }
}

