/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class JTabbedPaneEx
extends JTabbedPane
implements ChangeListener {
    private static final long serialVersionUID = 1L;

    public JTabbedPaneEx() {
        SwingUtility.installDefaultFocusHandling(this);
        this.addChangeListener(this);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension m = new Dimension(super.getMinimumSize());
        Dimension p = super.getPreferredSize();
        if (m.width > p.width) {
            m.width = p.width;
        }
        if (m.height > p.height) {
            m.height = p.height;
        }
        return m;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        comp.setFocusable(false);
        super.addImpl(comp, constraints, index);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component selectedTab = this.getSelectedComponent();
        int i = 0;
        int n = this.getTabCount();
        while (i < n) {
            Component comp;
            comp.setFocusable((comp = this.getComponentAt(i)) == selectedTab);
            ++i;
        }
    }

    @Override
    public Color getBackgroundAt(int index) {
        Color c = super.getBackgroundAt(index);
        if (super.getSelectedIndex() == index) {
            return c;
        }
        return new Color(Math.max(0, c.getRed() - 48), Math.max(0, c.getGreen() - 48), Math.max(0, c.getBlue() - 48));
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public String getTitleAt(int index) {
        return "";
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Component selected = this.getSelectedComponent();
        int i = 0;
        int n = this.getComponentCount();
        while (i < n) {
            Component comp = this.getComponent(i);
            if (comp != selected) {
                comp.setBounds(0, 0, 0, 0);
            }
            ++i;
        }
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        return SwingUtility.getAdjustedToolTipLocation(e, this, this.getTopLevelAncestor());
    }
}

