/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.datefield;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.basic.document.BasicDocumentFilter;
import org.eclipse.scout.rt.ui.swing.ext.IDropDownButtonListener;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldWithTransparentIcon;
import org.eclipse.scout.rt.ui.swing.ext.calendar.TimeChooser;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.datefield.ISwingScoutDateField;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewEvent;
import org.eclipse.scout.rt.ui.swing.window.SwingScoutViewListener;
import org.eclipse.scout.rt.ui.swing.window.popup.SwingScoutDropDownPopup;

public class SwingScoutTimeField
extends SwingScoutValueFieldComposite<IDateField>
implements ISwingScoutDateField {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutTimeField.class);
    private boolean m_ignoreLabel;
    private boolean m_dateTimeCompositeMember;
    private String m_displayTextToVerify;
    private SwingScoutDropDownPopup m_proposalPopup;

    public boolean isIgnoreLabel() {
        return this.m_ignoreLabel;
    }

    public void setIgnoreLabel(boolean ignoreLabel) {
        this.m_ignoreLabel = ignoreLabel;
    }

    public boolean isDateTimeCompositeMember() {
        return this.m_dateTimeCompositeMember;
    }

    public void setDateTimeCompositeMember(boolean dateTimeCompositeMember) {
        this.m_dateTimeCompositeMember = dateTimeCompositeMember;
    }

    @Override
    protected void initializeSwing() {
        JTextField timeField;
        Document doc;
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        if (!this.isIgnoreLabel()) {
            JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
            container.add(label);
            this.setSwingLabel(label);
        }
        if ((doc = (timeField = this.createTimeField(container)).getDocument()) instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(new BasicDocumentFilter(60));
        }
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingScoutTimeField.this.setInputDirty(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingScoutTimeField.this.setInputDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingScoutTimeField.this.setInputDirty(true);
            }
        });
        container.add(timeField);
        InputMap inputMap = timeField.getInputMap(0);
        inputMap.put(SwingUtility.createKeystroke("F2"), "timeChooser");
        inputMap.put(SwingUtility.createKeystroke("UP"), "nextQuarterHour");
        inputMap.put(SwingUtility.createKeystroke("DOWN"), "prevQuarterHour");
        inputMap.put(SwingUtility.createKeystroke("shift UP"), "nextHour");
        inputMap.put(SwingUtility.createKeystroke("shift DOWN"), "prevHour");
        ActionMap actionMap = timeField.getActionMap();
        actionMap.put("timeChooser", new P_SwingTimeChooserAction());
        actionMap.put("nextQuarterHour", new P_SwingTimeShiftAction(0, 1));
        actionMap.put("prevQuarterHour", new P_SwingTimeShiftAction(0, -1));
        actionMap.put("nextHour", new P_SwingTimeShiftAction(1, 1));
        actionMap.put("prevHour", new P_SwingTimeShiftAction(1, -1));
        this.setSwingContainer(container);
        this.setSwingField(timeField);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    protected JTextField createTimeField(JComponent container) {
        JTextFieldWithTransparentIcon textField = new JTextFieldWithTransparentIcon();
        this.initializeTimeField(textField);
        container.add(textField);
        return textField;
    }

    protected void initializeTimeField(JTextFieldWithTransparentIcon textField) {
        textField.setIconGroup(new IconGroup(this.getSwingEnvironment(), "datefield_time"));
        textField.addDropDownButtonListener(new IDropDownButtonListener(){

            @Override
            public void iconClicked(Object source) {
                SwingScoutTimeField.this.getSwingTimeField().requestFocus();
                SwingScoutTimeField.this.handleSwingTimeChooserAction();
            }

            @Override
            public void menuClicked(Object source) {
            }
        });
    }

    public JTextField getSwingTimeField() {
        return (JTextField)this.getSwingField();
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        int swingAlign = SwingUtility.createHorizontalAlignment(scoutAlign);
        this.getSwingTimeField().setHorizontalAlignment(swingAlign);
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        this.m_displayTextToVerify = s;
        IDateField f = (IDateField)this.getScoutObject();
        Date value = (Date)f.getValue();
        JTextField textField = this.getSwingTimeField();
        if (value == null) {
            textField.setText(this.m_displayTextToVerify);
            textField.setCaretPosition(0);
            return;
        }
        DateFormat format = f.getIsolatedTimeFormat();
        if (format != null) {
            this.m_displayTextToVerify = format.format(value);
            textField.setText(this.m_displayTextToVerify);
            textField.setCaretPosition(0);
        }
    }

    @Override
    protected boolean handleSwingInputVerifier() {
        final String text = this.getSwingTimeField().getText();
        if (CompareUtility.equals((Object)text, (Object)this.m_displayTextToVerify) && (this.isDateTimeCompositeMember() || ((IDateField)this.getScoutObject()).getErrorStatus() == null)) {
            return true;
        }
        this.m_displayTextToVerify = text;
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IDateField)SwingScoutTimeField.this.getScoutObject()).getUIFacade().setTimeTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getSwingEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {}
        this.getSwingEnvironment().dispatchImmediateSwingJobs();
        return true;
    }

    @Override
    protected void handleSwingFocusGained() {
        super.handleSwingFocusGained();
        JTextField swingField = this.getSwingTimeField();
        if (swingField.getDocument().getLength() > 0) {
            swingField.setCaretPosition(swingField.getDocument().getLength());
            swingField.moveCaretPosition(0);
        }
    }

    private void acceptProposalFromSwing(final Date newDate) {
        this.closePopup();
        if (newDate != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IDateField)SwingScoutTimeField.this.getScoutObject()).getUIFacade().setTimeFromUI(newDate);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private void closePopup() {
        if (this.m_proposalPopup != null) {
            this.m_proposalPopup.closeView();
            this.m_proposalPopup = null;
            this.getSwingTimeField().getInputMap(0).remove(SwingUtility.createKeystroke("ENTER"));
            this.getSwingTimeField().getInputMap(0).remove(SwingUtility.createKeystroke("ESCAPE"));
        }
    }

    protected boolean isTimeChooserEnabled() {
        return this.getSwingTimeField() != null && this.getSwingTimeField().isEnabled();
    }

    protected void handleSwingTimeChooserAction() {
        this.closePopup();
        if (this.isTimeChooserEnabled()) {
            Date d = (Date)((IDateField)this.getScoutObject()).getValue();
            if (d == null) {
                d = new Date();
            }
            final TimeChooser timeChooser = new TimeChooser();
            timeChooser.setTime(d);
            timeChooser.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SwingScoutTimeField.this.acceptProposalFromSwing(timeChooser.getTime());
                }
            });
            JPanel popupContent = timeChooser.getContainer();
            AbstractAction acceptAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTimeField.this.closePopup();
                    SwingScoutTimeField.this.handleSwingInputVerifier();
                }
            };
            AbstractAction escAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTimeField.this.closePopup();
                }
            };
            JTextField textField = this.getSwingTimeField();
            textField.getInputMap(0).put(SwingUtility.createKeystroke("ENTER"), "enter");
            textField.getActionMap().put("enter", acceptAction);
            textField.getInputMap(0).put(SwingUtility.createKeystroke("ESCAPE"), "escape");
            textField.getActionMap().put("escape", escAction);
            popupContent.getInputMap(1).put(SwingUtility.createKeystroke("ENTER"), "enter");
            popupContent.getActionMap().put("enter", acceptAction);
            popupContent.getInputMap(1).put(SwingUtility.createKeystroke("ESCAPE"), "escape");
            popupContent.getActionMap().put("escape", escAction);
            this.m_proposalPopup = new SwingScoutDropDownPopup(this.getSwingEnvironment(), (Component)textField, textField);
            this.m_proposalPopup.setFixedWidth(100);
            this.m_proposalPopup.makeNonFocusable();
            this.m_proposalPopup.addSwingScoutViewListener(new SwingScoutViewListener(){

                @Override
                public void viewChanged(SwingScoutViewEvent e) {
                    if (e.getType() == 40) {
                        SwingScoutTimeField.this.closePopup();
                    }
                }
            });
            this.m_proposalPopup.getSwingContentPane().add(popupContent);
            this.m_proposalPopup.openView();
        }
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        JComponent fld = this.getSwingField();
        if (fld != null && scoutColor != null && fld instanceof JTextComponent) {
            this.setDisabledTextColor(SwingUtility.createColor(scoutColor), (JTextComponent)fld);
        }
        super.setForegroundFromScout(scoutColor);
    }

    private class P_SwingTimeChooserAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_SwingTimeChooserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutTimeField.this.handleSwingTimeChooserAction();
        }
    }

    private class P_SwingTimeShiftAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private int m_level;
        private int m_value;

        public P_SwingTimeShiftAction(int level, int value) {
            this.m_level = level;
            this.m_value = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutTimeField.this.closePopup();
            if (SwingScoutTimeField.this.getSwingTimeField().isVisible() && SwingScoutTimeField.this.getSwingTimeField().isEditable()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((IDateField)SwingScoutTimeField.this.getScoutObject()).getUIFacade().fireTimeShiftActionFromUI(P_SwingTimeShiftAction.this.m_level, P_SwingTimeShiftAction.this.m_value);
                    }
                };
                SwingScoutTimeField.this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        }
    }
}

